/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.mpeg2.packets;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.mpeg2.MPEG2ProgramStreamConstants;
import com.apple.jingle.leghorn.mpeg2.packets.descriptors.Descriptor;
import com.apple.jingle.media.foundation.io.ByteArraySeekableDataInput;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.util.BitReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class ElementaryStream {
    int streamType;
    int elementaryStreamId;
    int elementaryStreamInfoLength;
    List<Descriptor> descriptors;

    public void parse(@Nonnull LeghornValidationContext ctx, @Nonnull SeekableDataInput sdi) throws IOException {
        byte[] b = new byte[2];
        sdi.readFully(b);
        BitReader bitReader = new BitReader(b);
        this.elementaryStreamInfoLength = (int)bitReader.readUBits(16);
        long posInFile = sdi.getFilePointer();
        this.descriptors = new ArrayList<Descriptor>();
        ByteArraySeekableDataInput bsdi = new ByteArraySeekableDataInput(new byte[this.elementaryStreamInfoLength], (long)this.elementaryStreamInfoLength);
        while (bsdi.getFilePointer() < bsdi.length()) {
            long descriptorStartOffset = posInFile + bsdi.getFilePointer();
            long bytesLeftInDescriptors = bsdi.length() - bsdi.getFilePointer();
            if (bytesLeftInDescriptors < 2L) {
                String msg = "Found only " + bytesLeftInDescriptors + " bytes before descriptors end, " + "need at least 2 bytes";
                ctx.addCheckAlert(descriptorStartOffset, MediaValidationCode.MPEG2_INSUFFICIENT_DESCRIPTOR_BYTES, MediaUtil.dictionary.add("message", msg).add("offset", Long.toString(posInFile)).add("bytesRequired", "2").add("bytesRemaining", Long.toString(bytesLeftInDescriptors)));
            }
            int descriptorTag = bsdi.readUnsignedByte();
            bsdi.seek(bsdi.getFilePointer() - 1L);
            Descriptor descriptor = new Descriptor();
            if (MPEG2ProgramStreamConstants.MAP_OF_DESCRIPTOR_IDS_TO_CLASS.containsKey(descriptorTag)) {
                try {
                    descriptor = MPEG2ProgramStreamConstants.MAP_OF_DESCRIPTOR_IDS_TO_CLASS.get(descriptorTag).newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            descriptor.parse(ctx, (SeekableDataInput)bsdi, descriptorStartOffset);
            this.descriptors.add(descriptor);
        }
    }

    public void setAttributes(int elementaryStreamType, int elementaryStreamId) {
        this.streamType = elementaryStreamType;
        this.elementaryStreamId = elementaryStreamId;
    }
}

