/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.mpeg2.packets;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.mpeg2.packets.PESPacket;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.util.BitReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public class AudioSequencePacket
extends PESPacket {
    private static final Logger logger = Logger.getLogger(AudioSequencePacket.class);
    int syncWord;
    int algorithm;
    int layer;
    int protectionBit;
    int bitRateIndex;
    int samplingFrequency;
    int paddingBit;
    int privateBit;
    int mode;
    int modeExtension;
    int copyright;
    int original;
    int emphasis;
    public static Map<Integer, String> LAYER = new HashMap<Integer, String>();
    public static Map<Integer, Float> SAMPLING_FREQUENCY;
    public static Map<Integer, String> MODE;
    public static Map<String, Integer> MODE_TO_CHANNEL_COUNT;
    public static Map<Integer, String> EMPHASIS;
    public static Map<Integer, Float> LAYER_1_BIT_RATE_INDEX;
    public static Map<Integer, Float> LAYER_2_BIT_RATE_INDEX;
    public static Map<Integer, Float> LAYER_3_BIT_RATE_INDEX;

    @Override
    public boolean parse(@Nonnull LeghornValidationContext ctx, SeekableDataInput sdi) throws IOException {
        if (!super.parse(ctx, sdi)) {
            return false;
        }
        long audioSequencePacketStart = sdi.getFilePointer();
        byte[] buffer = new byte[4];
        sdi.readFully(buffer);
        BitReader bitReader = new BitReader(buffer);
        this.syncWord = (int)bitReader.readUBits(12);
        if (this.syncWord != 4095) {
            this.skipToEndOfSequence(sdi);
            return true;
        }
        this.algorithm = bitReader.readBit();
        this.layer = (int)bitReader.readUBits(2);
        if (this.layer == 0) {
            String msg = "Value 00 for ADTS Audio Coding Layer (tentatively using Layer III table for bit rate computation)";
            logger.warn((Object)("At file offset " + audioSequencePacketStart + ", " + msg));
        }
        this.protectionBit = bitReader.readBit();
        this.bitRateIndex = (int)bitReader.readUBits(4);
        this.samplingFrequency = (int)bitReader.readUBits(2);
        this.paddingBit = bitReader.readBit();
        this.privateBit = bitReader.readBit();
        this.mode = (int)bitReader.readUBits(2);
        this.modeExtension = (int)bitReader.readUBits(2);
        this.copyright = bitReader.readBit();
        this.original = bitReader.readBit();
        this.emphasis = bitReader.readBit();
        this.skipToEndOfSequence(sdi);
        return true;
    }

    public String getLayer() {
        return LAYER.get(this.layer);
    }

    public float getBitRate() {
        if (this.layer == 1) {
            return LAYER_1_BIT_RATE_INDEX.get(this.bitRateIndex).floatValue();
        }
        if (this.layer == 2) {
            return LAYER_2_BIT_RATE_INDEX.get(this.bitRateIndex).floatValue();
        }
        if (this.layer == 3) {
            return LAYER_3_BIT_RATE_INDEX.get(this.bitRateIndex).floatValue();
        }
        logger.warn((Object)"Using Layer III (layer bits = 01) bit rate map as fall back value");
        if (this.bitRateIndex < 1 || this.bitRateIndex > 15) {
            return 48.0f;
        }
        return LAYER_3_BIT_RATE_INDEX.get(this.bitRateIndex).floatValue();
    }

    public Float getSamplingFrequency() {
        return SAMPLING_FREQUENCY.get(this.samplingFrequency);
    }

    public String getMode() {
        return MODE.get(this.mode);
    }

    public Integer getChannels() {
        return MODE_TO_CHANNEL_COUNT.get(MODE.get(this.mode));
    }

    public boolean getCopyright() {
        return this.copyright == 1;
    }

    public boolean getOriginal() {
        return this.original == 1;
    }

    public String getEmphasis() {
        return EMPHASIS.get(this.emphasis);
    }

    static {
        LAYER.put(0, "Invalid Layer");
        LAYER.put(1, "Layer III");
        LAYER.put(2, "Layer II");
        LAYER.put(3, "Layer I");
        SAMPLING_FREQUENCY = new HashMap<Integer, Float>();
        SAMPLING_FREQUENCY.put(0, Float.valueOf(44.1f));
        SAMPLING_FREQUENCY.put(1, Float.valueOf(48.0f));
        SAMPLING_FREQUENCY.put(2, Float.valueOf(32.0f));
        SAMPLING_FREQUENCY.put(3, Float.valueOf(48.0f));
        MODE = new HashMap<Integer, String>();
        MODE.put(0, "Stereo");
        MODE.put(1, "Joint Stereo");
        MODE.put(2, "Dual Channel");
        MODE.put(3, "Single Channel");
        MODE_TO_CHANNEL_COUNT = new HashMap<String, Integer>();
        MODE_TO_CHANNEL_COUNT.put("Stereo", 2);
        MODE_TO_CHANNEL_COUNT.put("Joint Stereo", 2);
        MODE_TO_CHANNEL_COUNT.put("Dual Channel", 2);
        MODE_TO_CHANNEL_COUNT.put("Single Channel", 1);
        EMPHASIS = new HashMap<Integer, String>();
        EMPHASIS.put(0, "No Emphasis");
        EMPHASIS.put(1, "50/15 microsec. emphasis");
        EMPHASIS.put(2, "reserved");
        EMPHASIS.put(3, "CCITT J.17");
        LAYER_1_BIT_RATE_INDEX = new HashMap<Integer, Float>();
        LAYER_2_BIT_RATE_INDEX = new HashMap<Integer, Float>();
        LAYER_3_BIT_RATE_INDEX = new HashMap<Integer, Float>();
        LAYER_1_BIT_RATE_INDEX.put(1, Float.valueOf(32.0f));
        LAYER_1_BIT_RATE_INDEX.put(2, Float.valueOf(64.0f));
        LAYER_1_BIT_RATE_INDEX.put(3, Float.valueOf(96.0f));
        LAYER_1_BIT_RATE_INDEX.put(4, Float.valueOf(28.0f));
        LAYER_1_BIT_RATE_INDEX.put(5, Float.valueOf(160.0f));
        LAYER_1_BIT_RATE_INDEX.put(6, Float.valueOf(192.0f));
        LAYER_1_BIT_RATE_INDEX.put(7, Float.valueOf(224.0f));
        LAYER_1_BIT_RATE_INDEX.put(8, Float.valueOf(256.0f));
        LAYER_1_BIT_RATE_INDEX.put(9, Float.valueOf(288.0f));
        LAYER_1_BIT_RATE_INDEX.put(10, Float.valueOf(320.0f));
        LAYER_1_BIT_RATE_INDEX.put(11, Float.valueOf(352.0f));
        LAYER_1_BIT_RATE_INDEX.put(12, Float.valueOf(384.0f));
        LAYER_1_BIT_RATE_INDEX.put(13, Float.valueOf(416.0f));
        LAYER_1_BIT_RATE_INDEX.put(14, Float.valueOf(448.0f));
        LAYER_2_BIT_RATE_INDEX.put(1, Float.valueOf(32.0f));
        LAYER_2_BIT_RATE_INDEX.put(2, Float.valueOf(48.0f));
        LAYER_2_BIT_RATE_INDEX.put(3, Float.valueOf(56.0f));
        LAYER_2_BIT_RATE_INDEX.put(4, Float.valueOf(64.0f));
        LAYER_2_BIT_RATE_INDEX.put(5, Float.valueOf(80.0f));
        LAYER_2_BIT_RATE_INDEX.put(6, Float.valueOf(96.0f));
        LAYER_2_BIT_RATE_INDEX.put(7, Float.valueOf(112.0f));
        LAYER_2_BIT_RATE_INDEX.put(8, Float.valueOf(128.0f));
        LAYER_2_BIT_RATE_INDEX.put(9, Float.valueOf(160.0f));
        LAYER_2_BIT_RATE_INDEX.put(10, Float.valueOf(192.0f));
        LAYER_2_BIT_RATE_INDEX.put(11, Float.valueOf(224.0f));
        LAYER_2_BIT_RATE_INDEX.put(12, Float.valueOf(256.0f));
        LAYER_2_BIT_RATE_INDEX.put(13, Float.valueOf(320.0f));
        LAYER_2_BIT_RATE_INDEX.put(14, Float.valueOf(384.0f));
        LAYER_3_BIT_RATE_INDEX.put(1, Float.valueOf(32.0f));
        LAYER_3_BIT_RATE_INDEX.put(2, Float.valueOf(40.0f));
        LAYER_3_BIT_RATE_INDEX.put(3, Float.valueOf(48.0f));
        LAYER_3_BIT_RATE_INDEX.put(4, Float.valueOf(56.0f));
        LAYER_3_BIT_RATE_INDEX.put(5, Float.valueOf(64.0f));
        LAYER_3_BIT_RATE_INDEX.put(6, Float.valueOf(80.0f));
        LAYER_3_BIT_RATE_INDEX.put(7, Float.valueOf(96.0f));
        LAYER_3_BIT_RATE_INDEX.put(8, Float.valueOf(112.0f));
        LAYER_3_BIT_RATE_INDEX.put(9, Float.valueOf(128.0f));
        LAYER_3_BIT_RATE_INDEX.put(10, Float.valueOf(160.0f));
        LAYER_3_BIT_RATE_INDEX.put(11, Float.valueOf(192.0f));
        LAYER_3_BIT_RATE_INDEX.put(12, Float.valueOf(224.0f));
        LAYER_3_BIT_RATE_INDEX.put(13, Float.valueOf(256.0f));
        LAYER_3_BIT_RATE_INDEX.put(14, Float.valueOf(320.0f));
        LAYER_3_BIT_RATE_INDEX.put(15, Float.valueOf(384.0f));
    }
}

