/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.mpeg2.datatypes;

import java.math.BigInteger;

public class ProgramClockReference {
    long base;
    int extension;
    long hours;
    long minutes;
    long seconds;
    long subSeconds;

    public String toString() {
        return "ProgramClockReference: " + this.humanReadablePCR();
    }

    public ProgramClockReference(long base, int extension) {
        this.base = base;
        this.extension = extension;
        BigInteger time = BigInteger.valueOf(base);
        time = time.multiply(BigInteger.valueOf(300L));
        time = time.add(BigInteger.valueOf(extension));
        BigInteger p = time.divide(BigInteger.valueOf(27L));
        long fa = 1000000L;
        this.hours = p.divide(BigInteger.valueOf(fa * 60L * 60L)).longValue();
        this.minutes = p.divide(BigInteger.valueOf(fa * 60L)).longValue() - this.hours * 60L;
        this.seconds = p.divide(BigInteger.valueOf(fa)).longValue() - this.hours * 3600L - this.minutes * 60L;
        this.subSeconds = p.longValue() - this.hours * fa * 60L * 60L - this.minutes * fa * 60L - this.seconds * fa;
    }

    public String humanReadablePCR() {
        return String.format("%d:%02d:%02d.%06d", this.hours, this.minutes, this.seconds, this.subSeconds);
    }

    public long toMillis() {
        return this.hours * 3600000L + this.minutes * 60000L + this.seconds * 1000L + this.subSeconds / 100000L;
    }
}

