/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.mpeg2;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.media.foundation.io.ByteSequence;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.util.BitReader;
import com.apple.jingle.media.foundation.util.MPEG2MediaReader;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public class SystemHeader {
    private static final Logger logger = Logger.getLogger(SystemHeader.class);
    long offset;
    int headerLength;
    int rateBound;
    int audioBound;
    int fixedBitrateFlag;
    int cspsFlag;
    int systemAudioLocFlag;
    int systemVideoLocFlag;
    int videoBound;
    int packetRateRestrictionFlag;
    int reservedBits;
    int streamId;
    int pSTDBufferBoundScale;
    int pSTDBufferSizeBound;

    public void parse(@Nonnull LeghornValidationContext ctx, @Nonnull SeekableDataInput sdi) throws IOException {
        this.headerLength = (int)MPEG2MediaReader.readU16((ByteSequence)sdi);
        this.offset = sdi.getFilePointer();
        byte[] buffer = new byte[6];
        sdi.readFully(buffer);
        BitReader bitReader = new BitReader(buffer);
        MPEG2MediaReader.readMarker((BitReader)bitReader);
        this.rateBound = (int)bitReader.readUBits(22);
        MPEG2MediaReader.readMarker((BitReader)bitReader);
        this.audioBound = (int)bitReader.readUBits(6);
        this.fixedBitrateFlag = bitReader.readBit();
        this.cspsFlag = bitReader.readBit();
        this.systemAudioLocFlag = bitReader.readBit();
        this.systemVideoLocFlag = bitReader.readBit();
        MPEG2MediaReader.readMarker((BitReader)bitReader);
        this.videoBound = (int)bitReader.readUBits(5);
        this.packetRateRestrictionFlag = bitReader.readBit();
        this.reservedBits = (int)bitReader.readUBits(7);
        logger.debug((Object)("Max audio streams: " + this.audioBound + ", max video streams: " + this.videoBound));
        while (true) {
            byte streamId;
            if (((streamId = sdi.readByte()) & 0x80) == 0) break;
            if ((streamId & 0xE0) == 224) {
                streamId = (byte)(streamId & 0xF);
            } else if ((streamId & 0xC0) == 192) {
                streamId = (byte)(streamId & 0x1F);
            }
            buffer = new byte[2];
            sdi.readFully(buffer);
            bitReader = new BitReader(buffer);
            MPEG2MediaReader.readMarker((BitReader)bitReader);
            MPEG2MediaReader.readMarker((BitReader)bitReader);
            this.pSTDBufferBoundScale = bitReader.readBit();
            this.pSTDBufferSizeBound = (int)bitReader.readUBits(13);
        }
        sdi.seek(sdi.getFilePointer() - 1L);
        if (sdi.getFilePointer() != this.offset + (long)this.headerLength) {
            logger.info((Object)("More bytes after all streams (" + sdi.getFilePointer() + " != " + this.offset + " + " + this.headerLength + ")"));
            sdi.seek(this.offset + (long)this.headerLength);
        }
    }

    public String toString() {
        return "SystemHeader{headerLength=" + this.headerLength + ", rateBound=" + this.rateBound + ", audioBound=" + this.audioBound + ", fixedBitrateFlag=" + this.fixedBitrateFlag + ", cspsFlag=" + this.cspsFlag + ", systemAudioLocFlag=" + this.systemAudioLocFlag + ", systemVideoLocFlag=" + this.systemVideoLocFlag + ", videoBound=" + this.videoBound + ", streamId=" + this.streamId + ", pSTDBufferBoundScale=" + this.pSTDBufferBoundScale + ", pSTDBufferSizeBound=" + this.pSTDBufferSizeBound + "}\n";
    }
}

