/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.mpeg2;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.mpeg2.MPEG2ProgramStreamConstants;
import com.apple.jingle.leghorn.mpeg2.PackHeader;
import com.apple.jingle.leghorn.mpeg2.ProgramPack;
import com.apple.jingle.leghorn.mpeg2.packets.AudioSequencePacket;
import com.apple.jingle.leghorn.mpeg2.packets.PESPacket;
import com.apple.jingle.leghorn.mpeg2.packets.VideoSequencePacket;
import com.apple.jingle.leghorn.mpeg2.streams.AudioStream;
import com.apple.jingle.leghorn.mpeg2.streams.Stream;
import com.apple.jingle.leghorn.mpeg2.streams.VideoStream;
import com.apple.jingle.media.foundation.io.ByteSequence;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.util.MPEG2MediaReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;

public class ProgramStream {
    private static final Logger log = Logger.getLogger(ProgramStream.class);
    private static final long maximumOffsetForFirstPackStartCode = 100000L;
    private List<ProgramPack> packs;
    private Map<Integer, Stream> streams;
    private long length;
    private long numberOfBytesToLookAt = 1000000L;
    private long maxNumberOfBytesToScanBackwards = 4L * this.numberOfBytesToLookAt;

    public ProgramStream() {
        this.packs = new ArrayList<ProgramPack>();
        this.streams = new HashMap<Integer, Stream>();
    }

    private Pair<Integer, Integer> scanRange(@Nonnull LeghornValidationContext ctx, @Nonnull SeekableDataInput sdi, @Nonnegative long numberOfBytesToScan) throws IOException {
        log.debug((Object)String.format("====> Scanning range from %d for %d bytes", sdi.getFilePointer(), numberOfBytesToScan));
        Pair result = Pair.of((Object)-1, (Object)-1);
        boolean foundRangeEnd = false;
        boolean seenFirstPackStartCode = false;
        long scanStartFilePosition = sdi.getFilePointer();
        boolean scanAtStartOfFile = scanStartFilePosition == 0L;
        log.debug((Object)String.format("Scanning starts at %d (startOfFile: %b)", scanStartFilePosition, scanAtStartOfFile));
        while (!foundRangeEnd && sdi.getFilePointer() < sdi.length() && sdi.getFilePointer() - scanStartFilePosition < numberOfBytesToScan) {
            if (scanAtStartOfFile && !seenFirstPackStartCode && sdi.getFilePointer() > 100000L) {
                String msg = String.format("Failed to find first Pack Start Code after scanning first %d bytes of file, giving up...", 100000L);
                ctx.addCheckAlert(sdi.getFilePointer(), MediaValidationCode.MPEG2_FAILED_TO_FIND_PACKET_START_CODE, MediaUtil.dictionary.add("message", msg).add("offset", Long.toString(sdi.getFilePointer())).add("maximumOffsetForFirstPackStartCode", Long.toString(100000L)));
                foundRangeEnd = true;
                continue;
            }
            long bytesLeftInFile = sdi.length() - sdi.getFilePointer();
            if (bytesLeftInFile < 4L) {
                ctx.addCheckAlert(sdi.getFilePointer(), MediaValidationCode.MPEG2_INSUFFICIENT_BYTES_FOR_PROGRAM_PACK, MediaUtil.dictionary.add("offset", Long.toString(sdi.getFilePointer())).add("remainingBytes", Long.toString(bytesLeftInFile)));
                foundRangeEnd = true;
                continue;
            }
            byte[] code = MPEG2MediaReader.readFourByteCode((ByteSequence)sdi);
            if (Arrays.equals(code, MPEG2ProgramStreamConstants.MPEG_PROGRAM_END_CODE)) {
                foundRangeEnd = true;
                continue;
            }
            if (!Arrays.equals(code, MPEG2ProgramStreamConstants.PACKET_START_CODE)) {
                sdi.seek(sdi.getFilePointer() - 4L);
                if (seenFirstPackStartCode) {
                    ctx.addCheckAlert(sdi.getFilePointer(), MediaValidationCode.MPEG2_INVALID_PACKET_START_CODE, MediaUtil.dictionary.add("offset", Long.toString(sdi.getFilePointer())).add("value", ProgramStream.getHexString(code).toUpperCase()).add("expectedValue", ProgramStream.getHexString(MPEG2ProgramStreamConstants.PACKET_START_CODE).toUpperCase()));
                }
                if (ProgramStream.skipToNextPacket(ctx, sdi, scanAtStartOfFile && !seenFirstPackStartCode)) {
                    log.warn((Object)String.format("Skipped to next packet @%d", sdi.getFilePointer()));
                    seenFirstPackStartCode = true;
                    log.debug((Object)String.format("Found first start code at %d bytes from start", sdi.getFilePointer()));
                    continue;
                }
                foundRangeEnd = true;
                continue;
            }
            if (!seenFirstPackStartCode) {
                log.debug((Object)String.format("Found first start code at %d bytes from start", sdi.getFilePointer() - 4L));
                result = Pair.of((Object)0, (Object)0);
            }
            seenFirstPackStartCode = true;
            ProgramPack programPack = new ProgramPack();
            Pair<Integer, Integer> packResult = programPack.parse(ctx, sdi);
            log.debug((Object)("-=====> pack: " + packResult));
            this.packs.add(programPack);
            result = Pair.of((Object)((Integer)result.getLeft() + (Integer)packResult.getLeft()), (Object)((Integer)result.getRight() + (Integer)packResult.getRight()));
        }
        if (seenFirstPackStartCode) {
            log.debug((Object)String.format("Got %d video PES packets and %d audio packets.", result.getLeft(), result.getRight()));
        } else {
            log.debug((Object)String.format("Failed to get first packet in %d bytes", 100000L));
        }
        return result;
    }

    public void parse(@Nonnull LeghornValidationContext ctx, @Nonnull SeekableDataInput sdi) throws IOException {
        String msg;
        boolean seenFirstVideoPacket = false;
        boolean seenFirstAudioPacket = false;
        boolean seenLastVideoPacket = false;
        boolean seenLastAudioPacket = false;
        this.length = sdi.length();
        log.debug((Object)("LENGTH=" + this.length + ", noBytesToLookAt=" + this.numberOfBytesToLookAt));
        if (this.length <= 2L * this.numberOfBytesToLookAt) {
            Pair<Integer, Integer> result = this.scanRange(ctx, sdi, this.length);
            seenFirstVideoPacket = (Integer)result.getLeft() > 0;
            seenFirstAudioPacket = (Integer)result.getRight() > 0;
            seenLastVideoPacket = (Integer)result.getLeft() > 1;
            seenLastAudioPacket = (Integer)result.getRight() > 1;
        } else {
            Pair<Integer, Integer> result = this.scanRange(ctx, sdi, this.numberOfBytesToLookAt);
            seenFirstVideoPacket = (Integer)result.getLeft() > 0;
            seenFirstAudioPacket = (Integer)result.getRight() > 0;
            seenLastVideoPacket = (Integer)result.getLeft() > 1;
            boolean bl = seenLastAudioPacket = (Integer)result.getRight() > 1;
            if ((Integer)result.getLeft() < 0 && (Integer)result.getRight() < 0) {
                return;
            }
            long filePositionToStartFrom = sdi.length() - this.numberOfBytesToLookAt;
            boolean seenLastVideoPacketAtEnd = false;
            boolean seenLastAudioPacketAtEnd = false;
            while (!(seenLastVideoPacketAtEnd && seenLastAudioPacketAtEnd || filePositionToStartFrom < this.numberOfBytesToLookAt)) {
                sdi.seek(filePositionToStartFrom);
                Pair<Integer, Integer> resultForEndScan = this.scanRange(ctx, sdi, this.numberOfBytesToLookAt);
                if (!seenLastVideoPacketAtEnd) {
                    boolean bl2 = seenLastVideoPacketAtEnd = (Integer)resultForEndScan.getLeft() > 0;
                }
                if (!seenLastAudioPacketAtEnd) {
                    seenLastAudioPacketAtEnd = (Integer)resultForEndScan.getRight() > 0;
                }
                seenLastVideoPacket |= seenLastVideoPacketAtEnd;
                seenLastAudioPacket |= seenLastAudioPacketAtEnd;
                if (sdi.length() - (filePositionToStartFrom -= this.numberOfBytesToLookAt) <= this.maxNumberOfBytesToScanBackwards) continue;
            }
        }
        if (!seenFirstVideoPacket || !seenLastVideoPacket) {
            msg = !seenFirstVideoPacket ? "Failed to find first video packet, giving up..." : String.format("Failed to find last video packet (needed to compute duration) in last %d bytes, giving up...", this.maxNumberOfBytesToScanBackwards);
            ctx.addCheckAlert(sdi.getFilePointer(), MediaValidationCode.MPEG2_FAILED_TO_FIND_PACKET_START_CODE, MediaUtil.dictionary.add("message", msg).add("offset", Long.toString(sdi.getFilePointer())).add("maxNumberOfBytesToScanBackwards", Long.toString(this.maxNumberOfBytesToScanBackwards)));
        }
        if (!seenFirstAudioPacket || !seenLastAudioPacket) {
            msg = !seenFirstAudioPacket ? "Failed to find first audio packet, giving up..." : String.format("Failed to find last audio packet (needed to compute duration) in last %d bytes, giving up...", this.maxNumberOfBytesToScanBackwards);
            ctx.addCheckAlert(sdi.getFilePointer(), MediaValidationCode.MPEG2_FAILED_TO_FIND_PACKET_START_CODE, MediaUtil.dictionary.add("message", msg).add("offset", Long.toString(sdi.getFilePointer())).add("maxNumberOfBytesToScanBackwards", Long.toString(this.maxNumberOfBytesToScanBackwards)));
        }
        this.createStreams();
    }

    private void createStreams() {
        for (ProgramPack programPack : this.packs) {
            for (PESPacket packet : programPack.packets) {
                Stream stream;
                if (packet instanceof VideoSequencePacket) {
                    if (!this.streams.containsKey(packet.getStreamId())) {
                        VideoStream videoStream = new VideoStream(this.streams.size());
                        videoStream.setId(packet.getStreamId());
                        videoStream.addPacket(packet);
                        this.streams.put(packet.getStreamId(), videoStream);
                        continue;
                    }
                    stream = this.streams.get(packet.getStreamId());
                    stream.addPacket(packet);
                    continue;
                }
                if (!(packet instanceof AudioSequencePacket)) continue;
                if (!this.streams.containsKey(packet.getStreamId())) {
                    AudioStream audioStream = new AudioStream(this.streams.size());
                    audioStream.addPacket(packet);
                    this.streams.put(packet.getStreamId(), audioStream);
                    continue;
                }
                stream = this.streams.get(packet.getStreamId());
                stream.addPacket(packet);
            }
        }
        for (Map.Entry entry : this.streams.entrySet()) {
            Stream stream = (Stream)entry.getValue();
            stream.sortPacketsAndTimestamps();
        }
    }

    public static boolean skipToNextPacket(@Nonnull LeghornValidationContext ctx, SeekableDataInput sdi) throws IOException {
        return ProgramStream.skipToNextPacket(ctx, sdi, false);
    }

    private static boolean skipToNextPacket(@Nonnull LeghornValidationContext ctx, SeekableDataInput sdi, boolean searchForFirstPackStartCode) throws IOException {
        long startFileOffset = sdi.getFilePointer();
        boolean packetStartFound = false;
        while (!packetStartFound) {
            if (searchForFirstPackStartCode && sdi.getFilePointer() > 100000L) {
                String msg = String.format("Failed to find first Pack Start Code after scanning first %d bytes of file, giving up...", 100000L);
                ctx.addCheckAlert(sdi.getFilePointer(), MediaValidationCode.MPEG2_FAILED_TO_FIND_PACKET_START_CODE, MediaUtil.dictionary.add("message", msg).add("offset", Long.toString(sdi.getFilePointer())).add("maximumOffset", Long.toString(100000L)));
                return false;
            }
            if (sdi.getFilePointer() + 4L > sdi.length()) {
                log.warn((Object)String.format("Failed to get next packet start starting from file offset %d, file end reached", startFileOffset));
                return false;
            }
            byte[] code = MPEG2MediaReader.readFourByteCode((ByteSequence)sdi);
            if (code == null) {
                log.warn((Object)String.format("Failed to get next packet start starting from file offset %d, file end reached", startFileOffset));
                return false;
            }
            if (Arrays.equals(code, MPEG2ProgramStreamConstants.PACKET_START_CODE)) {
                packetStartFound = true;
                continue;
            }
            if (Arrays.equals(code, MPEG2ProgramStreamConstants.QT_FTYP_CODE)) {
                ctx.addCheckAlert(sdi.getFilePointer(), MediaValidationCode.FILE_APPEARS_CORRUPT, MediaUtil.dictionary.add("errorMessage", "Your MPEG-2 file appears to actually be a QuickTime (.mov) file."));
                return false;
            }
            if (code[1] == MPEG2ProgramStreamConstants.PACKET_START_CODE[0] && code[2] == MPEG2ProgramStreamConstants.PACKET_START_CODE[1] && code[3] == MPEG2ProgramStreamConstants.PACKET_START_CODE[2]) {
                sdi.seek(sdi.getFilePointer() - 3L);
                continue;
            }
            if (code[2] == MPEG2ProgramStreamConstants.PACKET_START_CODE[0] && code[3] == MPEG2ProgramStreamConstants.PACKET_START_CODE[1]) {
                sdi.seek(sdi.getFilePointer() - 2L);
                continue;
            }
            if (code[3] != MPEG2ProgramStreamConstants.PACKET_START_CODE[0]) continue;
            sdi.seek(sdi.getFilePointer() - 1L);
        }
        sdi.seek(sdi.getFilePointer() - 4L);
        return true;
    }

    public List<ProgramPack> getPacks() {
        return this.packs;
    }

    public Map<Integer, Stream> getStreams() {
        return this.streams;
    }

    public String toString() {
        return "ProgramStream{packs=" + this.packs + ", streams=" + this.streams + '}';
    }

    public long length() {
        return this.length;
    }

    public long getProgramMuxRate() {
        long muxRate = 0L;
        for (ProgramPack programPack : this.packs) {
            PackHeader packHeader = programPack.getHeader();
            if (null == packHeader) continue;
            muxRate = packHeader.getMultiplexRate() * 50 * 8;
        }
        return muxRate;
    }

    public static String getHexString(byte[] b) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            sb.append(Integer.toString((b[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }
}

