/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.mpeg2;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.mpeg2.MPEG2ProgramStreamConstants;
import com.apple.jingle.leghorn.mpeg2.PackHeader;
import com.apple.jingle.leghorn.mpeg2.ProgramStream;
import com.apple.jingle.leghorn.mpeg2.packets.PESPacket;
import com.apple.jingle.media.foundation.io.ByteSequence;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.util.MPEG2MediaReader;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;

public class ProgramPack {
    private static final Logger logger = Logger.getLogger(ProgramPack.class);
    protected PackHeader packHeader;
    protected List<PESPacket> packets = new ArrayList<PESPacket>();

    ProgramPack() {
    }

    public Pair<Integer, Integer> parse(@Nonnull LeghornValidationContext ctx, @Nonnull SeekableDataInput sdi) throws IOException {
        this.packHeader = new PackHeader();
        this.packHeader.parse(ctx, sdi);
        logger.debug((Object)("PACKHEADER: " + this.packHeader));
        boolean packDone = false;
        int videoPackets = 0;
        int audioPackets = 0;
        byte[] nextBytes = new byte[3];
        while (!packDone && sdi.length() - sdi.getFilePointer() > 0L) {
            long bytesLeftInFile = sdi.length() - sdi.getFilePointer();
            if (bytesLeftInFile < 3L) {
                ctx.addCheckAlert(sdi.getFilePointer(), MediaValidationCode.MPEG2_INSUFFICIENT_BYTES_FOR_PROGRAM_PACK, MediaUtil.dictionary.add("offset", Long.toString(sdi.getFilePointer())).add("remainingBytes", Long.toString(bytesLeftInFile)));
                packDone = true;
                continue;
            }
            logger.debug((Object)("Checking ProgramPack @" + sdi.getFilePointer()));
            sdi.readFully(nextBytes);
            if (!Arrays.equals(nextBytes, MPEG2ProgramStreamConstants.PACKET_START_CODE_PREFIX)) {
                logger.debug((Object)"NOT PACKET_START_CODE_PREFIX");
                sdi.seek(sdi.getFilePointer() - 3L);
                ctx.addCheckAlert(sdi.getFilePointer(), MediaValidationCode.MPEG2_INVALID_PROGRAM_PACK_BYTES, MediaUtil.dictionary.add("offset", Long.toString(sdi.getFilePointer())).add("expectedValue", "0x000001").add("value", ProgramStream.getHexString(nextBytes).toUpperCase()));
                if (ProgramStream.skipToNextPacket(ctx, sdi)) {
                    logger.warn((Object)("Skipped to next packet @" + sdi.getFilePointer()));
                    continue;
                }
                packDone = true;
                continue;
            }
            int streamId = (int)MPEG2MediaReader.readU8((ByteSequence)sdi);
            logger.debug((Object)("streamId= " + String.format("%02x", streamId)));
            if (streamId == 186 || streamId == 185) {
                logger.debug((Object)"IS packet_start_code or end code");
                sdi.seek(sdi.getFilePointer() - 4L);
                packDone = true;
                continue;
            }
            int packetLength = (int)MPEG2MediaReader.readU16((ByteSequence)sdi);
            long offset = sdi.getFilePointer();
            logger.debug((Object)String.format("Checking PES packet (streamId %s [%s] length %d @%d)", Strings.padStart((String)Integer.toHexString(streamId).toUpperCase(), (int)2, (char)'0'), MPEG2ProgramStreamConstants.MAP_OF_STREAM_IDS_TO_NAME.get(streamId), packetLength, offset));
            if (offset + (long)packetLength > sdi.length()) {
                logger.debug((Object)"PES package length problem");
                String msg = String.format("PES packet length = %d, but this is beyond file end", packetLength);
                ctx.addCheckAlert(offset - 6L, MediaValidationCode.MPEG2_INCOMPLETE_LAST_PACKET, MediaUtil.dictionary.add("message", msg).add("offset", Long.toString(sdi.getFilePointer())).add("packetLength", Integer.toString(packetLength)));
                packDone = true;
                continue;
            }
            if (packetLength < 1 && (streamId < 224 || streamId > 239)) {
                logger.debug((Object)"STREAM CORRUPT");
                ctx.addCheckAlert(offset - 6L, MediaValidationCode.MPEG2_STREAM_CORRUPT, MediaUtil.dictionary.add("offset", Long.toString(sdi.getFilePointer())).add("packetLength", Integer.toString(packetLength)).add("streamId", Strings.padStart((String)Integer.toHexString(streamId).toUpperCase(), (int)2, (char)'0')));
                if (ProgramStream.skipToNextPacket(ctx, sdi)) {
                    logger.warn((Object)("Skipped to next packet @" + sdi.getFilePointer()));
                    continue;
                }
                packDone = true;
                continue;
            }
            PESPacket pesPacket = null;
            if (MPEG2ProgramStreamConstants.MAP_OF_STREAM_IDS_TO_CLASS.containsKey(streamId)) {
                try {
                    pesPacket = MPEG2ProgramStreamConstants.MAP_OF_STREAM_IDS_TO_CLASS.get(streamId).newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                logger.debug((Object)("isPes: " + pesPacket));
            }
            if (null == pesPacket) {
                pesPacket = new PESPacket();
            }
            pesPacket.setAttributes(streamId, packetLength, offset);
            logger.debug((Object)("===> Calling " + pesPacket + ".parse with offset=" + offset + ", len=" + packetLength));
            if (!pesPacket.parse(ctx, sdi)) {
                logger.debug((Object)("Read " + pesPacket));
                packDone = true;
                continue;
            }
            if (MPEG2ProgramStreamConstants.isVideoPESPacket(streamId)) {
                ++videoPackets;
            } else if (MPEG2ProgramStreamConstants.isAudioPESPacket(streamId)) {
                ++audioPackets;
            }
            this.packets.add(pesPacket);
        }
        return Pair.of((Object)videoPackets, (Object)audioPackets);
    }

    public List<PESPacket> getPackets() {
        return this.packets;
    }

    public String toString() {
        return "ProgramPack{packHeader=" + this.packHeader + ", packets=" + this.packets + "}\n";
    }

    public PackHeader getHeader() {
        return this.packHeader;
    }
}

