/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.mpeg2;

import com.apple.jingle.leghorn.Configuration;
import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.fileformat.ContainerDescription;
import com.apple.jingle.leghorn.mpeg2.MPEG2DescriptionGenerator;
import com.apple.jingle.leghorn.mpeg2.ProgramPack;
import com.apple.jingle.leghorn.mpeg2.ProgramStream;
import com.apple.jingle.leghorn.mpeg2.ProgramStreamValidationContext;
import com.apple.jingle.leghorn.mpeg2.packets.AudioSequencePacket;
import com.apple.jingle.leghorn.mpeg2.packets.PESPacket;
import com.apple.jingle.leghorn.mpeg2.packets.VideoSequencePacket;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.util.XMLUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;

public class Parser {
    LeghornValidationContext ctx;
    ProgramStream programStream = new ProgramStream();
    SeekableDataInput sdi;

    public Parser(LeghornValidationContext ctx, SeekableDataInput sdi) throws IOException {
        this.programStream.parse(ctx, sdi);
    }

    public ProgramStream getParsedProgramStream() {
        return this.programStream;
    }

    private static void findVideoSequenceHeaderExtension(ProgramStream programStream) {
        for (ProgramPack pack : programStream.getPacks()) {
            int counter = 0;
            for (PESPacket packet : pack.packets) {
                if (packet instanceof VideoSequencePacket) {
                    if (((VideoSequencePacket)packet).getSequenceHeaderExtension() != null) {
                        System.out.println("Packet " + counter + " has a sequence header extension.");
                    }
                    if (((VideoSequencePacket)packet).getSequenceDisplayExtension() != null) {
                        System.out.println("Packet " + counter + " has a sequence display extension.");
                    }
                    if (((VideoSequencePacket)packet).getSequenceScalableExtension() != null) {
                        System.out.println("Packet " + counter + " has a sequence scalable extension.");
                    }
                }
                ++counter;
            }
        }
    }

    private static void printFirstAndLastPTS(ProgramStream ps) {
        ArrayList<Long> videoPtsList = new ArrayList<Long>();
        ArrayList<Long> videoDtsList = new ArrayList<Long>();
        ArrayList<Long> audioPtsList = new ArrayList<Long>();
        ArrayList<Long> audioDtsList = new ArrayList<Long>();
        ArrayList<Long> scrList = new ArrayList<Long>();
        for (ProgramPack pack : ps.getPacks()) {
            scrList.add(pack.packHeader.getScr());
            for (PESPacket packet : pack.packets) {
                if (packet instanceof VideoSequencePacket) {
                    if (packet.getPtsDtsFlags() == 2) {
                        videoPtsList.add(packet.getPts());
                        continue;
                    }
                    if (packet.getPtsDtsFlags() != 3) continue;
                    videoPtsList.add(packet.getPts());
                    videoDtsList.add(packet.getDts());
                    continue;
                }
                if (!(packet instanceof AudioSequencePacket)) continue;
                if (packet.getPtsDtsFlags() == 2) {
                    audioPtsList.add(packet.getPts());
                    continue;
                }
                if (packet.getPtsDtsFlags() != 3) continue;
                audioPtsList.add(packet.getPts());
                audioDtsList.add(packet.getDts());
            }
        }
        Collections.sort(scrList);
        Collections.sort(audioPtsList);
        Collections.sort(audioDtsList);
        Collections.sort(videoPtsList);
        Collections.sort(videoDtsList);
        System.out.println("SCR LIST: " + scrList);
        if (!scrList.isEmpty()) {
            System.out.println("SCR MIN/MAX: " + scrList.get(0) + "/" + scrList.get(scrList.size() - 1));
            System.out.println("SCR LENGTH MS: " + ((Long)scrList.get(scrList.size() - 1) - (Long)scrList.get(0)) / 180L + "ms");
            System.out.println("SCR LENGTH SECONDS: " + ((Long)scrList.get(scrList.size() - 1) - (Long)scrList.get(0)) / 180000L + "seconds");
            System.out.println("SCR LENGTH MINUTES: " + ((Long)scrList.get(scrList.size() - 1) - (Long)scrList.get(0)) / 180000L / 60L + "minutes");
        }
        System.out.println("AUDIO PTS LIST:\n" + audioPtsList);
        if (!audioPtsList.isEmpty()) {
            System.out.println("AUDIO PTS MIN/MAX: " + audioPtsList.get(0) + "/" + audioPtsList.get(audioPtsList.size() - 1));
            System.out.println("AUDIO LENGTH MS: " + ((Long)audioPtsList.get(audioPtsList.size() - 1) - (Long)audioPtsList.get(0)) / 180L + "ms");
            System.out.println("AUDIO LENGTH MS: " + ((Long)audioPtsList.get(audioPtsList.size() - 1) - (Long)audioPtsList.get(0)) / 180000L + "seconds");
            System.out.println("AUDIO LENGTH MS: " + ((Long)audioPtsList.get(audioPtsList.size() - 1) - (Long)audioPtsList.get(0)) / 180000L / 60L + "minutes");
        }
        System.out.println("AUDIO DTS LIST:\n" + audioDtsList);
        System.out.println("VIDEO PTS LIST:\n" + videoPtsList);
        if (!videoPtsList.isEmpty()) {
            System.out.println("VIDEO PTS MIN/MAX: " + videoPtsList.get(0) + "/" + videoPtsList.get(videoPtsList.size() - 1));
            System.out.println("VIDEO LENGTH MS: " + ((Long)videoPtsList.get(videoPtsList.size() - 1) - (Long)videoPtsList.get(0)) / 180L + "ms");
            System.out.println("VIDEO LENGTH MS: " + ((Long)videoPtsList.get(videoPtsList.size() - 1) - (Long)videoPtsList.get(0)) / 180000L + "seconds");
            System.out.println("VIDEO LENGTH MS: " + ((Long)videoPtsList.get(videoPtsList.size() - 1) - (Long)videoPtsList.get(0)) / 180000L / 60L + "minutes");
        }
        System.out.println("VIDEO DTS LIST:\n" + videoDtsList);
    }

    public static void printLastPacketWithPTSOrDTS(ProgramStream ps, FileWriter writer) throws IOException {
        for (ProgramPack pack : ps.getPacks()) {
            writer.write("SCR: " + pack.packHeader.getScr() + "\n");
            for (PESPacket packet : pack.packets) {
                String typeOfPacket = packet instanceof VideoSequencePacket ? "VIDEO" : (packet instanceof AudioSequencePacket ? "AUDIO" : "OTHER");
                if ("OTHER".equals(typeOfPacket)) continue;
                if (packet.getPtsDtsFlags() == 2) {
                    writer.write(typeOfPacket + " PTS: " + packet.getPts() + "\n");
                    continue;
                }
                if (packet.getPtsDtsFlags() != 3) continue;
                writer.write(typeOfPacket + " PTS: " + packet.getPts() + "\n");
                writer.write(typeOfPacket + " DTS: " + packet.getDts() + "\n");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, TransformerException {
        try (SeekableDataInput sdi = SeekableDataInput.Factory.fromURI((URI)new File(args[0]).toURI());){
            ProgramStreamValidationContext ctx = new ProgramStreamValidationContext(sdi.getFileName(), "Parser", Configuration.getVersion());
            ProgramStream programStream = new ProgramStream();
            programStream.parse(ctx, sdi);
            Parser.findVideoSequenceHeaderExtension(programStream);
            Parser.printFirstAndLastPTS(programStream);
            ContainerDescription<Node> cd = MPEG2DescriptionGenerator.generateDescription(ctx, programStream);
            System.out.println(XMLUtil.nodeToString((Node)cd.getDescriptionDocument()));
        }
    }
}

