/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.mpeg2;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.mpeg2.MPEG2ProgramStreamConstants;
import com.apple.jingle.leghorn.mpeg2.SystemHeader;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.util.BitReader;
import com.apple.jingle.media.foundation.util.MPEG2MediaReader;
import com.google.common.base.Strings;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public class PackHeader {
    private static final Logger logger = Logger.getLogger(PackHeader.class);
    private long packHeaderStartOffset;
    private boolean isMPEG1;
    private int scrBaseBits3230;
    private int scrBaseBits2915;
    private int scrBaseBits140;
    private int scrExtension;
    private int multiplexRate;
    private int stuffingLength;
    private SystemHeader systemHeader;

    public void parse(@Nonnull LeghornValidationContext ctx, SeekableDataInput sdi) throws IOException {
        this.packHeaderStartOffset = sdi.getFilePointer();
        byte firstByte = sdi.readByte();
        sdi.seek(sdi.getFilePointer() - 1L);
        if ((firstByte & 0xF0) == 32) {
            logger.debug((Object)("ISO/IEC 11171-1/MPEG-1 pack header @" + this.packHeaderStartOffset + ":" + Strings.padStart((String)Integer.toHexString(firstByte).toUpperCase(), (int)2, (char)' ')));
            this.parseMPEG1PackHeader(ctx, sdi);
            return;
        }
        if ((firstByte & 0xC0) == 64) {
            logger.debug((Object)("ISO/IEC 13818-1/H.222.0 pack header @" + this.packHeaderStartOffset + ":" + Strings.padStart((String)Integer.toHexString(firstByte).toUpperCase(), (int)2, (char)' ')));
        } else {
            ctx.addCheckAlert(this.packHeaderStartOffset, MediaValidationCode.MPEG2_PACK_HEADER_INVALID_FOURTH_BYTE, MediaUtil.dictionary.add("value", Strings.padStart((String)Integer.toBinaryString((firstByte & 0xF0) >> 4), (int)4, (char)'0')).add("expectedValue", "0010"));
        }
        this.parseMPEG2PackHeader(ctx, sdi);
        this.getScr();
    }

    public void parseMPEG1PackHeader(@Nonnull LeghornValidationContext ctx, SeekableDataInput sdi) throws IOException {
        this.isMPEG1 = true;
        byte[] buffer = new byte[8];
        sdi.readFully(buffer);
        BitReader bitReader = new BitReader(buffer);
        bitReader.readUBits(4);
        this.scrBaseBits3230 = (int)bitReader.readUBits(3);
        MPEG2MediaReader.readMarker((BitReader)bitReader);
        this.scrBaseBits2915 = (int)bitReader.readUBits(15);
        MPEG2MediaReader.readMarker((BitReader)bitReader);
        this.scrBaseBits140 = (int)bitReader.readUBits(15);
        MPEG2MediaReader.readMarker((BitReader)bitReader);
        MPEG2MediaReader.readMarker((BitReader)bitReader);
        this.multiplexRate = (int)bitReader.readUBits(22);
        MPEG2MediaReader.readMarker((BitReader)bitReader);
        this.scrExtension = 0;
        this.stuffingLength = 0;
        if (MPEG2MediaReader.matchesFourByteCode((SeekableDataInput)sdi, (byte[])MPEG2ProgramStreamConstants.SYSTEM_HEADER_START_CODE)) {
            this.systemHeader = new SystemHeader();
            this.systemHeader.parse(ctx, sdi);
        } else {
            sdi.seek(sdi.getFilePointer() - 4L);
        }
    }

    public void parseMPEG2PackHeader(@Nonnull LeghornValidationContext ctx, SeekableDataInput sdi) throws IOException {
        int actualSkippedBytes;
        this.isMPEG1 = false;
        byte[] buffer = new byte[10];
        sdi.readFully(buffer);
        BitReader bitReader = new BitReader(buffer);
        bitReader.readUBits(2);
        this.scrBaseBits3230 = (int)bitReader.readUBits(3);
        MPEG2MediaReader.readMarker((BitReader)bitReader);
        this.scrBaseBits2915 = (int)bitReader.readUBits(15);
        MPEG2MediaReader.readMarker((BitReader)bitReader);
        this.scrBaseBits140 = (int)bitReader.readUBits(15);
        MPEG2MediaReader.readMarker((BitReader)bitReader);
        this.scrExtension = (int)bitReader.readUBits(9);
        MPEG2MediaReader.readMarker((BitReader)bitReader);
        this.multiplexRate = (int)bitReader.readUBits(22);
        MPEG2MediaReader.readMarker((BitReader)bitReader);
        MPEG2MediaReader.readMarker((BitReader)bitReader);
        bitReader.readUBits(5);
        this.stuffingLength = (int)bitReader.readUBits(3);
        if (this.stuffingLength != 0 && (actualSkippedBytes = sdi.skipBytes(this.stuffingLength)) != this.stuffingLength) {
            ctx.addCheckAlert(this.packHeaderStartOffset, MediaValidationCode.MPEG2_INSUFFICIENT_STUFFING_BYTES, MediaUtil.dictionary.add("offset", Long.toString(sdi.getFilePointer())).add("stuffingBytes", Integer.toString(actualSkippedBytes)).add("expectedStuffingBytes", Integer.toString(this.stuffingLength)));
        }
        if (sdi.getFilePointer() < sdi.length() && MPEG2MediaReader.matchesFourByteCode((SeekableDataInput)sdi, (byte[])MPEG2ProgramStreamConstants.SYSTEM_HEADER_START_CODE)) {
            this.systemHeader = new SystemHeader();
            this.systemHeader.parse(ctx, sdi);
        } else {
            sdi.seek(sdi.getFilePointer() - 4L);
        }
    }

    public long getScr() {
        long scrBase = 0L;
        scrBase += (long)this.scrBaseBits3230 << 30;
        scrBase += (long)this.scrBaseBits2915 << 15;
        long scr = !this.isMPEG1 ? scrBase * 300L + (long)this.scrExtension : (scrBase += (long)this.scrBaseBits140) * 300L;
        return scr;
    }

    public int getMultiplexRate() {
        return this.multiplexRate;
    }

    public String toString() {
        return "ProgramPack{, scrBaseBits3230=" + this.scrBaseBits3230 + ", scrBaseBits2915=" + this.scrBaseBits2915 + ", scrBaseBits140=" + this.scrBaseBits140 + ", scrExtension=" + this.scrExtension + ", scr=" + this.getScr() + ", multiplexRate=" + this.multiplexRate + ", stuffingLength=" + this.stuffingLength + '}';
    }
}

