/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.mpeg2;

import com.apple.jingle.leghorn.mpeg2.packets.AudioSequencePacket;
import com.apple.jingle.leghorn.mpeg2.packets.ElementaryStream;
import com.apple.jingle.leghorn.mpeg2.packets.PESPacket;
import com.apple.jingle.leghorn.mpeg2.packets.PaddingStreamPacket;
import com.apple.jingle.leghorn.mpeg2.packets.ProgramStreamMap;
import com.apple.jingle.leghorn.mpeg2.packets.VideoSequencePacket;
import com.apple.jingle.leghorn.mpeg2.packets.descriptors.Descriptor;
import com.apple.jingle.leghorn.mpeg2.packets.descriptors.TargetBackgroundGridDescriptor;
import com.apple.jingle.leghorn.mpeg2.packets.descriptors.VideoStreamDescriptor;
import com.apple.jingle.leghorn.mpeg2.ts.packets.ADTSAACAudioSequencePacket;
import com.apple.jingle.leghorn.mpeg2.ts.packets.AVCVideoSequencePacket;
import com.apple.jingle.leghorn.mpeg2.ts.packets.TSPESPacket;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class MPEG2ProgramStreamConstants {
    public static final Charset usAsciiCharSet;
    public static final byte[] PACKET_START_CODE_PREFIX;
    public static final byte[] PACKET_START_CODE;
    public static final byte[] SYSTEM_HEADER_START_CODE;
    public static final byte[] MPEG_PROGRAM_END_CODE;
    public static final byte[] QT_FTYP_CODE;
    public static final int PACKET_START_CODE_ID = 186;
    public static final int MPEG_PROGRAM_END_CODE_ID = 185;
    public static final Map<Integer, Class<? extends PESPacket>> MAP_OF_STREAM_IDS_TO_CLASS;
    public static final Map<Integer, String> MAP_OF_STREAM_IDS_TO_NAME;
    public static final Map<String, Integer> VIDEO_SEQUENCE_START_CODE_VALUES;
    public static final byte[] VIDEO_STREAM_SEQUENCE_HEADER_CODE;
    public static final byte[] VIDEO_STREAM_EXTENSION_START_CODE;
    public static final byte[] GOP_START_CODE;
    public static final byte[] PICTURE_START_CODE;
    public static final byte[] EXTENSION_START_CODE;
    public static final Map<Integer, Class<? extends Descriptor>> MAP_OF_DESCRIPTOR_IDS_TO_CLASS;
    public static final Map<Integer, Class<? extends ElementaryStream>> MAP_OF_ELEMENTARY_STREAM_IDS_TO_CLASS;
    public static final Map<Integer, String> MAP_OF_STREAM_TYPE_CODES;
    public static final Map<Integer, String> MAP_OF_DESCRIPTOR_TYPES;
    public static final Map<Integer, Class<? extends TSPESPacket>> MAP_OF_STREAM_TYPE_TO_CLASS;

    public static boolean isAudioPESPacket(int streamId) {
        return streamId >= 192 && streamId < 224;
    }

    public static boolean isVideoPESPacket(int streamId) {
        return streamId >= 224 && streamId < 240;
    }

    static {
        int i;
        usAsciiCharSet = Charset.forName("US-ASCII");
        PACKET_START_CODE_PREFIX = new byte[]{0, 0, 1};
        PACKET_START_CODE = new byte[]{0, 0, 1, -70};
        SYSTEM_HEADER_START_CODE = new byte[]{0, 0, 1, -69};
        MPEG_PROGRAM_END_CODE = new byte[]{0, 0, 1, -71};
        QT_FTYP_CODE = "ftyp".getBytes(usAsciiCharSet);
        MAP_OF_STREAM_IDS_TO_CLASS = new HashMap<Integer, Class<? extends PESPacket>>();
        MAP_OF_STREAM_IDS_TO_CLASS.put(190, PaddingStreamPacket.class);
        MAP_OF_STREAM_IDS_TO_CLASS.put(188, ProgramStreamMap.class);
        for (i = 192; i < 224; ++i) {
            MAP_OF_STREAM_IDS_TO_CLASS.put(i, AudioSequencePacket.class);
        }
        for (i = 224; i < 240; ++i) {
            MAP_OF_STREAM_IDS_TO_CLASS.put(i, VideoSequencePacket.class);
        }
        MAP_OF_STREAM_IDS_TO_NAME = new HashMap<Integer, String>();
        for (i = 0; i < 192; ++i) {
            MAP_OF_STREAM_IDS_TO_NAME.put(i, "Invalid stream id");
        }
        MAP_OF_STREAM_IDS_TO_NAME.put(185, "Program Stream end");
        MAP_OF_STREAM_IDS_TO_NAME.put(186, "Pack Header");
        MAP_OF_STREAM_IDS_TO_NAME.put(187, "System Header");
        MAP_OF_STREAM_IDS_TO_NAME.put(188, "Program Stream Map");
        MAP_OF_STREAM_IDS_TO_NAME.put(189, "Private stream 1");
        MAP_OF_STREAM_IDS_TO_NAME.put(190, "Padding stream");
        MAP_OF_STREAM_IDS_TO_NAME.put(191, "Private stream 2");
        for (i = 192; i < 224; ++i) {
            MAP_OF_STREAM_IDS_TO_NAME.put(i, "MPEG-1 or MPEG-2 audio stream");
        }
        for (i = 224; i < 240; ++i) {
            MAP_OF_STREAM_IDS_TO_NAME.put(i, "MPEG-1 or MPEG-2 video stream");
        }
        MAP_OF_STREAM_IDS_TO_NAME.put(240, "ECM Stream");
        MAP_OF_STREAM_IDS_TO_NAME.put(241, "EMM Stream");
        MAP_OF_STREAM_IDS_TO_NAME.put(242, "ITU-T Rec. H.222.0 | IEC 13818-1 Annex A or ISO/IEC 13818-6 DSCMCC stream");
        MAP_OF_STREAM_IDS_TO_NAME.put(243, "ISO/IEC 13522 stream");
        MAP_OF_STREAM_IDS_TO_NAME.put(244, "ITU-T Rec. H.222.1 type A");
        MAP_OF_STREAM_IDS_TO_NAME.put(245, "ITU-T Rec. H.222.1 type B");
        MAP_OF_STREAM_IDS_TO_NAME.put(246, "ITU-T Rec. H.222.1 type C");
        MAP_OF_STREAM_IDS_TO_NAME.put(247, "ITU-T Rec. H.222.1 type D");
        MAP_OF_STREAM_IDS_TO_NAME.put(248, "ITU-T Rec. H.222.1 type E");
        MAP_OF_STREAM_IDS_TO_NAME.put(249, "Ancillary Stream");
        for (i = 250; i < 254; ++i) {
            MAP_OF_STREAM_IDS_TO_NAME.put(i, "Reserved");
        }
        MAP_OF_STREAM_IDS_TO_NAME.put(255, "Program Stream Directory");
        VIDEO_SEQUENCE_START_CODE_VALUES = new HashMap<String, Integer>();
        VIDEO_SEQUENCE_START_CODE_VALUES.put("picture_start_code", 0);
        VIDEO_SEQUENCE_START_CODE_VALUES.put("reserved", 176);
        VIDEO_SEQUENCE_START_CODE_VALUES.put("reserved", 177);
        VIDEO_SEQUENCE_START_CODE_VALUES.put("user_data_start_code", 178);
        VIDEO_SEQUENCE_START_CODE_VALUES.put("sequence_header_start_code", 179);
        VIDEO_SEQUENCE_START_CODE_VALUES.put("sequence_error_start_code", 180);
        VIDEO_SEQUENCE_START_CODE_VALUES.put("extension_start_code", 181);
        VIDEO_SEQUENCE_START_CODE_VALUES.put("reserved", 182);
        VIDEO_SEQUENCE_START_CODE_VALUES.put("sequence_end_code", 183);
        VIDEO_SEQUENCE_START_CODE_VALUES.put("group_start_code", 184);
        for (i = 1; i < 175; ++i) {
            VIDEO_SEQUENCE_START_CODE_VALUES.put("slice_code_start", i);
        }
        VIDEO_STREAM_SEQUENCE_HEADER_CODE = new byte[]{0, 0, 1, -77};
        VIDEO_STREAM_EXTENSION_START_CODE = new byte[]{0, 0, 1, -75};
        GOP_START_CODE = new byte[]{0, 0, 1, -72};
        PICTURE_START_CODE = new byte[]{0, 0, 1, 0};
        EXTENSION_START_CODE = new byte[]{0, 0, 1, -75};
        MAP_OF_DESCRIPTOR_IDS_TO_CLASS = new HashMap<Integer, Class<? extends Descriptor>>();
        MAP_OF_DESCRIPTOR_IDS_TO_CLASS.put(2, VideoStreamDescriptor.class);
        MAP_OF_DESCRIPTOR_IDS_TO_CLASS.put(7, TargetBackgroundGridDescriptor.class);
        MAP_OF_ELEMENTARY_STREAM_IDS_TO_CLASS = new HashMap<Integer, Class<? extends ElementaryStream>>();
        MAP_OF_STREAM_TYPE_CODES = new HashMap<Integer, String>();
        MAP_OF_STREAM_TYPE_CODES.put(0, "ITU-T | ISO/IEC Reserved");
        MAP_OF_STREAM_TYPE_CODES.put(1, "ISO/IEC 11172 Video");
        MAP_OF_STREAM_TYPE_CODES.put(2, "ITU-T Rec. H.262 | ISO/IEC 13818-2 Video");
        MAP_OF_STREAM_TYPE_CODES.put(3, "ISO/IEC 11172 Audio");
        MAP_OF_STREAM_TYPE_CODES.put(4, "ISO/IEC 13818-3 Audio");
        MAP_OF_STREAM_TYPE_CODES.put(5, "ITU-T Rec. H.222.0 | ISO/IEC 13818-1 private sections");
        MAP_OF_STREAM_TYPE_CODES.put(6, "ITU-T Rec. H.222.0 | ISO/IEC 13818-1 PES packets containing private data");
        MAP_OF_STREAM_TYPE_CODES.put(7, "ISO/IEC 13522 MHEG");
        MAP_OF_STREAM_TYPE_CODES.put(8, "ITU-T Rec. H.222.0 | ISO/IEC 13818-1 DSM-CC");
        MAP_OF_STREAM_TYPE_CODES.put(9, "ITU-T Rec. H.222.0 | ISO/IEC 13818-1/11172-1 auxiliary");
        MAP_OF_STREAM_TYPE_CODES.put(10, "ISO/IEC 13818-6 Multi-protocol Encapsulation");
        MAP_OF_STREAM_TYPE_CODES.put(11, "ISO/IEC 13818-6 DSM-CC U-N Messages");
        MAP_OF_STREAM_TYPE_CODES.put(12, "ISO/IEC 13818-6 Stream Descriptors");
        MAP_OF_STREAM_TYPE_CODES.put(13, "ISO/IEC 13818-6 Sections (any type");
        MAP_OF_STREAM_TYPE_CODES.put(14, "ISO/IEC 13818-1 auxiliary");
        MAP_OF_STREAM_TYPE_CODES.put(15, "ISO/IEC 13818-7 Audio (AAC) with ADTS transport");
        MAP_OF_STREAM_TYPE_CODES.put(16, "ISO/IEC 14496-2 Visual");
        MAP_OF_STREAM_TYPE_CODES.put(17, "ISO/IEC 14496-3 Audio with the LATM transport syntax as defined in ISO/IEC 14496-3");
        MAP_OF_STREAM_TYPE_CODES.put(18, "ISO/IEC 14496-1 SL-packetized stream or FlexMux stream carried in PES packets");
        MAP_OF_STREAM_TYPE_CODES.put(19, "ISO/IEC 14496-1 SL-packetized stream or FlexMux stream carried in ISO/IEC 14496_sections");
        MAP_OF_STREAM_TYPE_CODES.put(20, "ISO/IEC 13818-6 DSM-CC Synchronized Download Protocol");
        MAP_OF_STREAM_TYPE_CODES.put(21, "Metadata carried in PES packets");
        MAP_OF_STREAM_TYPE_CODES.put(22, "Metadata carried in metadata_sections");
        MAP_OF_STREAM_TYPE_CODES.put(23, "Metadata carried in ISO/IEC 13818-6 Data Carousel");
        MAP_OF_STREAM_TYPE_CODES.put(24, "Metadata carried in ISO/IEC 13818-6 Object Carousel");
        MAP_OF_STREAM_TYPE_CODES.put(25, "Metadata carried in ISO/IEC 13818-6 Synchronized Download Protocol");
        MAP_OF_STREAM_TYPE_CODES.put(26, "IPMP stream (defined in ISO/IEC 13818-11");
        MAP_OF_STREAM_TYPE_CODES.put(27, "AVC video stream as defined in ITU-T Rec. H.264 | ISO/IEC 14496-10 Video");
        MAP_OF_STREAM_TYPE_CODES.put(128, "DigiCipher\u00ae II video | Identical to ITU-T Rec. H.262 | ISO/IEC 13818-2 Video");
        MAP_OF_STREAM_TYPE_CODES.put(129, "ATSC A/53 audio [2] | AC-3 audio");
        MAP_OF_STREAM_TYPE_CODES.put(130, "SCTE Standard Subtitle");
        MAP_OF_STREAM_TYPE_CODES.put(131, "SCTE Isochronous Data | Reserved");
        MAP_OF_STREAM_TYPE_CODES.put(132, "ATSC/SCTE reserved");
        MAP_OF_STREAM_TYPE_CODES.put(133, "ATSC Program Identifier");
        MAP_OF_STREAM_TYPE_CODES.put(134, "SCTE 35 splice_information_table | [Cueing]");
        MAP_OF_STREAM_TYPE_CODES.put(135, "E-AC-3");
        MAP_OF_STREAM_TYPE_CODES.put(-24, "SCTE Reserved");
        MAP_OF_STREAM_TYPE_CODES.put(136, "ATSC Reserved");
        MAP_OF_STREAM_TYPE_CODES.put(137, "ATSC Reserved");
        MAP_OF_STREAM_TYPE_CODES.put(144, "DVB stream_type value for Time Slicing / MPE-FEC");
        MAP_OF_STREAM_TYPE_CODES.put(145, "IETF Unidirectional Link Encapsulation (ULE)");
        MAP_OF_STREAM_TYPE_CODES.put(149, "ATSC Data Service Table");
        MAP_OF_STREAM_TYPE_CODES.put(160, "SCTE [IP Data] | ATSC Reserved");
        MAP_OF_STREAM_TYPE_CODES.put(192, "DCII (DigiCipher\u00ae) Text");
        MAP_OF_STREAM_TYPE_CODES.put(193, "ATSC Reserved");
        MAP_OF_STREAM_TYPE_CODES.put(194, "ATSC synchronous data stream | [Isochronous Data]");
        MAP_OF_STREAM_TYPE_CODES.put(195, "SCTE Asynchronous Data");
        MAP_OF_STREAM_TYPE_CODES.put(234, "VC-1 Elementary Stream per RP227");
        MAP_OF_DESCRIPTOR_TYPES = new HashMap<Integer, String>();
        MAP_OF_DESCRIPTOR_TYPES.put(0, "Reserved (0)");
        MAP_OF_DESCRIPTOR_TYPES.put(1, "Reserved (1)");
        MAP_OF_DESCRIPTOR_TYPES.put(2, "video_stream_descriptor");
        MAP_OF_DESCRIPTOR_TYPES.put(3, "audio_stream_descriptor");
        MAP_OF_DESCRIPTOR_TYPES.put(4, "hierarchy_descriptor");
        MAP_OF_DESCRIPTOR_TYPES.put(5, "registration_descriptor");
        MAP_OF_DESCRIPTOR_TYPES.put(6, "data_stream_alignment_descriptor");
        MAP_OF_DESCRIPTOR_TYPES.put(7, "target_background_grid_descriptor");
        MAP_OF_DESCRIPTOR_TYPES.put(8, "Video_window_descriptor");
        MAP_OF_DESCRIPTOR_TYPES.put(9, "CA_descriptor");
        MAP_OF_DESCRIPTOR_TYPES.put(10, "ISO_639_language_descriptor");
        MAP_OF_DESCRIPTOR_TYPES.put(11, "System_clock_descriptor");
        MAP_OF_DESCRIPTOR_TYPES.put(12, "Multiplex_buffer_utilization_descriptor");
        MAP_OF_DESCRIPTOR_TYPES.put(13, "Copyright_descriptor");
        MAP_OF_DESCRIPTOR_TYPES.put(14, "Maximum_bitrate_descriptor");
        MAP_OF_DESCRIPTOR_TYPES.put(15, "Private_data_indicator_descriptor");
        MAP_OF_DESCRIPTOR_TYPES.put(16, "Smoothing_buffer_descriptor");
        MAP_OF_DESCRIPTOR_TYPES.put(17, "STD_descriptor");
        MAP_OF_DESCRIPTOR_TYPES.put(18, "IBP_descriptor");
        for (i = 19; i < 27; ++i) {
            MAP_OF_DESCRIPTOR_TYPES.put(i, String.format("ISO/IEC 13818-6 descriptor %d", i));
        }
        MAP_OF_DESCRIPTOR_TYPES.put(27, "MPEG-4_video_descriptor");
        MAP_OF_DESCRIPTOR_TYPES.put(28, "MPEG-4_audio_descriptor");
        MAP_OF_DESCRIPTOR_TYPES.put(29, "IOD_descriptor");
        MAP_OF_DESCRIPTOR_TYPES.put(30, "SL_descriptor");
        MAP_OF_DESCRIPTOR_TYPES.put(31, "FMC_descriptor");
        MAP_OF_DESCRIPTOR_TYPES.put(32, "External_ES_ID_descriptor");
        MAP_OF_DESCRIPTOR_TYPES.put(33, "MuxCode_descriptor");
        MAP_OF_DESCRIPTOR_TYPES.put(34, "FmxBufferSize_descriptor");
        MAP_OF_DESCRIPTOR_TYPES.put(35, "MultiplexBuffer_descriptor");
        for (i = 36; i < 64; ++i) {
            MAP_OF_DESCRIPTOR_TYPES.put(i, "ITU-T Rec. H.222.0 | ISO/IEC 13818-1 Reserved");
        }
        for (i = 64; i < 256; ++i) {
            MAP_OF_DESCRIPTOR_TYPES.put(i, String.format("User private descriptor %d", i));
        }
        MAP_OF_STREAM_TYPE_TO_CLASS = new HashMap<Integer, Class<? extends TSPESPacket>>();
        MAP_OF_STREAM_TYPE_TO_CLASS.put(27, AVCVideoSequencePacket.class);
        MAP_OF_STREAM_TYPE_TO_CLASS.put(15, ADTSAACAudioSequencePacket.class);
    }

    public static enum ChromaSubsampling {
        UNKNOWN("Unknown"),
        MONOCHROME("Monochrome"),
        FOURTWOZERO("4:2:0"),
        FOURTWOTWO("4:2:2"),
        FOURFOURFOUR("4:4:4");

        private String toolParameter;

        private ChromaSubsampling(String toolParameter) {
            this.toolParameter = toolParameter;
        }

        public String getToolParameter() {
            return this.toolParameter;
        }
    }

    public static enum ColorSpace {
        YUV("yuv");

        private String toolParameter;

        private ColorSpace(String toolParameter) {
            this.toolParameter = toolParameter;
        }

        public String getToolParameter() {
            return this.toolParameter;
        }
    }
}

