/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.mpeg2;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.fileformat.ContainerDescription;
import com.apple.jingle.leghorn.fileformat.impl.SimpleContainerDescription;
import com.apple.jingle.leghorn.media.beans.DescriberInformation;
import com.apple.jingle.leghorn.media.validator.ValidationLevel;
import com.apple.jingle.leghorn.mpeg2.ProgramStream;
import com.apple.jingle.leghorn.mpeg2.streams.AudioStream;
import com.apple.jingle.leghorn.mpeg2.streams.Stream;
import com.apple.jingle.leghorn.mpeg2.streams.VideoStream;
import java.math.BigInteger;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import noNamespace.Channels;
import noNamespace.CodecName;
import noNamespace.ContainerDocument;
import noNamespace.DataRate;
import noNamespace.DisplayHeight;
import noNamespace.DisplayWidth;
import noNamespace.Duration;
import noNamespace.FrameRate;
import noNamespace.Height;
import noNamespace.Layer;
import noNamespace.Mode;
import noNamespace.Mpeg2DataSize;
import noNamespace.Mpeg2FieldDominance;
import noNamespace.OriginalVideoFormat;
import noNamespace.PixelFormat;
import noNamespace.SampleAspectRatio;
import noNamespace.SampleRate;
import noNamespace.Streams;
import noNamespace.TrackId;
import noNamespace.Width;
import org.apache.xmlbeans.XmlCursor;
import org.w3c.dom.Node;

public class MPEG2DescriptionGenerator {
    public static ContainerDescription<Node> generateDescription(@Nonnull LeghornValidationContext ctx, @Nonnull ProgramStream programStream) {
        ContainerDocument containerDocument = ContainerDocument.Factory.newInstance();
        ContainerDocument.Container container = containerDocument.addNewContainer();
        XmlCursor cursor = container.newCursor();
        cursor.insertComment(String.format("Generated by the %s, version %s", ctx.getDescriptionToolName(), ctx.getDescriptionToolVersion()));
        DescriberInformation describerInformation = container.addNewDescriber();
        describerInformation.newCursor().insertNamespace("ma", "http://beans.media.leghorn.jingle.apple.com");
        describerInformation.setName(ctx.getDescriptionToolName());
        describerInformation.setVersion(ctx.getDescriptionToolVersion());
        if (ctx.hasValidations(ValidationLevel.FATAL)) {
            ctx.populateAlertList(container.addNewNotifications(), ValidationLevel.DEBUG);
            SimpleContainerDescription containerDescription = new SimpleContainerDescription();
            containerDescription.setDescriptionDocument(containerDocument.getDomNode());
            return containerDescription;
        }
        Mpeg2DataSize dataSize = container.addNewDataSize();
        dataSize.setLongValue(programStream.length());
        dataSize.setUnits("bytes");
        Streams streams = container.addNewStreams();
        DataRate muxRate = container.addNewMuxRate();
        muxRate.setUnits("Mbps");
        muxRate.setFloatValue((float)(programStream.getProgramMuxRate() / 1000L) / 1000.0f);
        Map<Integer, Stream> programStreamStreams = programStream.getStreams();
        Set<Integer> keySet = programStreamStreams.keySet();
        for (Integer key : keySet) {
            CodecName codec;
            TrackId trackId;
            Stream currentStream = programStreamStreams.get(key);
            noNamespace.Stream stream = streams.addNewStream();
            stream.setType(currentStream.getType());
            stream.setEnabled(true);
            stream.setIndex(currentStream.getIndex());
            if (currentStream instanceof AudioStream) {
                ((AudioStream)currentStream).materialize();
                trackId = stream.addNewTrackId();
                trackId.setStringValue(String.format("0x%s", Integer.toHexString(currentStream.getId()).toUpperCase()));
                codec = stream.addNewCodecName();
                codec.setStringValue(currentStream.getCodecName());
                Layer layer = stream.addNewLayer();
                layer.setStringValue(((AudioStream)currentStream).getLayer());
                Mode mode = stream.addNewMode();
                mode.setStringValue(((AudioStream)currentStream).getMode());
                Channels channels = stream.addNewChannels();
                channels.setStringValue(((AudioStream)currentStream).getChannels().toString());
                DataRate dataRate = stream.addNewDataRate();
                dataRate.setUnits("kbps");
                dataRate.setFloatValue(((AudioStream)currentStream).getBitRate());
                Mpeg2DataSize audioDataSize = stream.addNewDataSize();
                audioDataSize.setUnits("bytes");
                audioDataSize.setLongValue(currentStream.getDuration() * (long)((AudioStream)currentStream).getBitRate() / 8L);
                SampleRate sampleRate = stream.addNewSampleRate();
                sampleRate.setFloatValue(((AudioStream)currentStream).getSamplingFrequency().floatValue());
                sampleRate.setUnits("kilohertz");
                Duration duration = stream.addNewDuration();
                duration.setUnits("milliseconds");
                duration.setStringValue(String.valueOf(currentStream.getDuration()));
                duration.setMilliseconds(currentStream.getDuration());
                continue;
            }
            if (!(currentStream instanceof VideoStream)) continue;
            ((VideoStream)currentStream).materialize();
            trackId = stream.addNewTrackId();
            trackId.setStringValue(String.format("0x%s", Integer.toHexString(currentStream.getId()).toUpperCase()));
            codec = stream.addNewCodecName();
            codec.setStringValue(currentStream.getCodecName());
            PixelFormat pixelFormat = stream.addNewPixelFormat();
            pixelFormat.setStringValue(((VideoStream)currentStream).getPixelFormat());
            Height height = stream.addNewHeight();
            height.setBigIntegerValue(BigInteger.valueOf(((VideoStream)currentStream).getHeight()));
            Width width = stream.addNewWidth();
            width.setBigIntegerValue(BigInteger.valueOf(((VideoStream)currentStream).getWidth()));
            DisplayHeight displayHeight = stream.addNewDisplayHeight();
            displayHeight.setBigIntegerValue(BigInteger.valueOf(((VideoStream)currentStream).getDisplayHeight()));
            DisplayWidth displayWidth = stream.addNewDisplayWidth();
            displayWidth.setBigIntegerValue(BigInteger.valueOf(((VideoStream)currentStream).getDisplayWidth()));
            FrameRate frameRate = stream.addNewFrameRate();
            double frameRateValue = ((VideoStream)currentStream).getFrameRate().getFrameRateNumerator() / ((VideoStream)currentStream).getFrameRate().getFrameRateDenominator();
            frameRate.setDoubleValue((double)Math.round(frameRateValue * 100.0) / 100.0);
            Mpeg2FieldDominance fieldDominance = stream.addNewFieldDominance();
            fieldDominance.setStringValue(((VideoStream)currentStream).getFieldDominance());
            SampleAspectRatio sampleAspectRatio = stream.addNewSampleAspectRatio();
            sampleAspectRatio.setStringValue(String.format("%d-%d", ((VideoStream)currentStream).getSampleAspectRatio().getAspectRatioNumerator(), ((VideoStream)currentStream).getSampleAspectRatio().getAspectRatioDenominator()));
            String originalVideoFormatValue = ((VideoStream)currentStream).getVideoFormat();
            if (null != originalVideoFormatValue) {
                OriginalVideoFormat originalVideoFormat = stream.addNewOriginalVideoFormat();
                originalVideoFormat.setStringValue(originalVideoFormatValue);
            }
            DataRate dataRate = stream.addNewDataRate();
            dataRate.setUnits("Mbps");
            dataRate.setStringValue(Double.toString(((VideoStream)currentStream).getBitRate()));
            Duration duration = stream.addNewDuration();
            duration.setUnits("milliseconds");
            duration.setStringValue(String.valueOf(currentStream.getDuration()));
            duration.setMilliseconds(currentStream.getDuration());
            Mpeg2DataSize audioDataSize = stream.addNewDataSize();
            audioDataSize.setUnits("bytes");
            audioDataSize.setLongValue(currentStream.getDuration() / 1000L * (long)((VideoStream)currentStream).getBitRate() / 8L * 1000000L);
        }
        if (ctx.hasValidations(ValidationLevel.DEBUG)) {
            ctx.populateAlertList(container.addNewNotifications(), ValidationLevel.DEBUG);
        }
        SimpleContainerDescription containerDescription = new SimpleContainerDescription();
        containerDescription.setDescriptionDocument(containerDocument.getDomNode());
        return containerDescription;
    }
}

