/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.xml;

import com.apple.jingle.foghorn.media.FrameGeometry;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.MediaValueError;
import com.apple.jingle.leghorn.media.MediaValueImpl;
import com.apple.jingle.leghorn.media.beans.Dictionary;
import com.apple.jingle.leghorn.media.beans.DictionaryEntry;
import com.apple.jingle.leghorn.media.beans.Notification;
import com.apple.jingle.leghorn.media.beans.NotificationList;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.validator.SimpleDictionary;
import com.apple.jingle.leghorn.media.validator.ValidationLevel;
import com.apple.jingle.leghorn.media.validator.ValidationResult;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.leghorn.timecode.Rational;
import com.apple.jingle.leghorn.timecode.SampleRate;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import noNamespace.Duration;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlObjectMediaParser {
    @Nonnull
    protected final XmlObject xmlObject;
    @Nonnull
    protected final MediaFileContext metaFile;
    @Nonnull
    protected final String name;
    @Nonnull
    private final Map<String, String> mediaDataMap = new HashMap<String, String>();
    private static final String VALUE = "value";

    public XmlObjectMediaParser(@Nonnull MediaFileContext metaFile, @Nonnull String name, @Nonnull XmlObject xmlObject) {
        assert (null != name);
        assert (null != xmlObject);
        assert (null != metaFile);
        this.name = name;
        this.xmlObject = xmlObject;
        this.metaFile = metaFile;
    }

    public String toString() {
        return "Parser[" + this.xmlObject.xmlText() + "]";
    }

    @Nonnull
    public MediaFileContext mediaFileCtx() {
        return this.metaFile;
    }

    @Nonnull
    public XmlObjectMediaParser childParser(String childName) {
        return new XmlObjectMediaParser(this.metaFile, this.name + "#" + childName, this.xmlObject);
    }

    @Nullable
    public XmlObjectMediaParser child(String elementName) {
        XmlObject[] children = this.xmlObject.selectPath(elementName);
        if (null != children && children.length >= 1) {
            return new XmlObjectMediaParser(this.metaFile, this.name, children[0]);
        }
        return null;
    }

    @Nullable
    public Collection<XmlObjectMediaParser> children(String elementName) {
        XmlObject[] children = this.xmlObject.selectPath(elementName);
        if (null == children || children.length < 1) {
            return Collections.emptyList();
        }
        ArrayList<XmlObjectMediaParser> xmlChidren = new ArrayList<XmlObjectMediaParser>();
        for (XmlObject c : children) {
            xmlChidren.add(new XmlObjectMediaParser(this.metaFile, this.name, c));
        }
        return xmlChidren;
    }

    @Nonnull
    public final ValidationResult addIssue(@Nonnull MediaValidationCode code, @Nonnull SimpleDictionary parameters) {
        return this.metaFile.addIssue(code, this.name, parameters);
    }

    @Nonnull
    public final ValidationResult addIssue(@Nonnull MediaValidationCode code, @Nonnull ValidationLevel defaultLevel, @Nonnull SimpleDictionary parameters) {
        return this.metaFile.addIssue(code, defaultLevel, this.name, parameters);
    }

    @Nonnull
    public final XmlObject getXmlObject() {
        return this.xmlObject;
    }

    @Nonnull
    public final String getXmlDescription() {
        return this.xmlObject.xmlText();
    }

    @Nonnull
    public final Node getXmlDescriptionNode() {
        return this.xmlObject.getDomNode();
    }

    @Nonnull
    public final String getXmlDescription(@Nonnull XmlOptions xmlOptions) {
        return this.xmlObject.xmlText(xmlOptions);
    }

    @Nonnull
    public final <T> MediaValue<T> toMediaValue(@Nullable T object) {
        return new MediaValueImpl<T>(object);
    }

    @Nonnull
    public final <T> MediaValue<T> toMediaError(@Nullable MediaValidationCode validationCode, @Nonnull SimpleDictionary parms) {
        if (null == validationCode) {
            return this.toMediaValue(null);
        }
        ValidationResult vr = this.addIssue(validationCode, parms);
        return new MediaValueError(vr);
    }

    public static final int toXmlObjectCount(@Nonnull XmlObject xmlObject, @Nonnull String xmlPath) {
        return XmlObjectMediaParser.toXmlObjects(xmlObject, xmlPath).length;
    }

    @Nonnull
    public static final XmlObject[] toXmlObjects(@Nonnull XmlObject xmlObject, @Nonnull String xmlPath) {
        return xmlObject.selectPath(xmlPath);
    }

    @Nonnull
    public final XmlObject[] toXmlObjects(@Nonnull String xmlPath) {
        return XmlObjectMediaParser.toXmlObjects(this.xmlObject, xmlPath);
    }

    @Nullable
    public final XmlObject toXmlObject(@Nonnull String xmlPath) {
        return XmlObjectMediaParser.toXmlObject(this.xmlObject, xmlPath);
    }

    @Nullable
    public static final XmlObject toXmlObject(@Nonnull XmlObject xmlObject, @Nonnull String xmlPath) {
        XmlObject[] xmlObjects = xmlObject.selectPath(xmlPath);
        return xmlObjects.length > 0 ? xmlObjects[0] : null;
    }

    @Nonnull
    public static final String toXmlString(@Nonnull XmlObject xmlObject, @Nonnull String xmlPath) {
        XmlObject xml = XmlObjectMediaParser.toXmlObject(xmlObject, xmlPath);
        return xml != null ? xml.newCursor().getTextValue() : "";
    }

    @Nonnull
    public static final String toXmlAttrString(@Nonnull XmlObject xmlObject, @Nonnull String attribute) {
        XmlObject xmlAttr = xmlObject.selectAttribute(QName.valueOf(attribute));
        return xmlAttr != null ? xmlAttr.newCursor().getTextValue() : "";
    }

    @Nonnull
    public static final String toXmlAttrString(@Nonnull XmlObject xmlObject, @Nonnull String xmlPath, @Nonnull String attribute) {
        XmlObject xObj = XmlObjectMediaParser.toXmlObject(xmlObject, xmlPath);
        if (xObj != null) {
            return XmlObjectMediaParser.toXmlAttrString(xObj, attribute);
        }
        return "";
    }

    @Nullable
    public final String toXmlAttrString(@Nonnull String xmlPath, @Nonnull String attribute) {
        return this.toXmlString(xmlPath + "/@" + attribute);
    }

    @Nonnull
    public final List<String> toXmlStrings(@Nonnull String xmlPath) {
        ArrayList<String> values = new ArrayList<String>();
        for (XmlObject xml : this.xmlObject.selectPath(xmlPath)) {
            values.add(xml != null ? xml.newCursor().getTextValue() : "");
        }
        return values;
    }

    @Nonnull
    public static final List<String> toXmlStrings(@Nonnull XmlObject xmlObject, @Nonnull String xmlPath) {
        ArrayList values = Lists.newArrayList();
        for (XmlObject xml : xmlObject.selectPath(xmlPath)) {
            values.add(xml != null ? xml.newCursor().getTextValue() : "");
        }
        return values;
    }

    @Nonnull
    public String toXmlStringWithDefault(String xmlPath, String defaultValue) {
        String value = this.toXmlString(xmlPath);
        return value != null ? value : defaultValue;
    }

    @Nullable
    public String toXmlString(@Nonnull String xmlPath) {
        XmlObject[] results = this.xmlObject.selectPath(xmlPath);
        if (results.length > 0) {
            return results[0].newCursor().getTextValue();
        }
        return null;
    }

    @Nonnull
    public MediaValue<String> toMediaString(@Nonnull String xmlPath, @Nullable String featureValidationCodePrefix) {
        String value = this.toXmlString(xmlPath);
        if (null != value) {
            return this.toMediaValue(value);
        }
        MediaValidationCode missingCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".missing");
        return this.toMediaError(missingCode, MediaUtil.dictionary);
    }

    @Nonnull
    public final MediaValue<Boolean> toMediaBoolean(@Nonnull String xmlPath, @Nullable String featureValidationCodePrefix) {
        MediaValidationCode invalidCode;
        String value = this.toXmlString(xmlPath);
        if ("true".equalsIgnoreCase(value)) {
            return this.toMediaValue(Boolean.TRUE);
        }
        if ("false".equalsIgnoreCase(value)) {
            return this.toMediaValue(Boolean.FALSE);
        }
        if (null != value && null != (invalidCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".invalid"))) {
            return this.toMediaError(invalidCode, MediaUtil.dictionary.add(VALUE, value));
        }
        MediaValidationCode missingCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".missing");
        return this.toMediaError(missingCode, MediaUtil.dictionary);
    }

    @Nonnull
    public MediaValue<BigDecimal> toMediaDecimal(@Nonnull String xmlPath, @Nullable String featureValidationCodePrefix) {
        block3: {
            String value = this.toXmlString(xmlPath);
            if (null != value) {
                try {
                    return this.toMediaValue(new BigDecimal(value));
                }
                catch (NumberFormatException e) {
                    MediaValidationCode invalidCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".invalid");
                    if (null == invalidCode) break block3;
                    return this.toMediaError(invalidCode, MediaUtil.dictionary.add(VALUE, value));
                }
            }
        }
        MediaValidationCode missingCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".missing");
        return this.toMediaError(missingCode, MediaUtil.dictionary);
    }

    @Nonnull
    public MediaValue<List<BigDecimal>> toMediaDecimalList(@Nonnull String xmlPath, int minSize, int maxSize, @Nullable String featureValidationCodePrefix) {
        block6: {
            String value = this.toXmlString(xmlPath);
            if (null != value) {
                try {
                    String[] parts = value.split("\\s*[,;]\\s*");
                    ArrayList<BigDecimal> values = new ArrayList<BigDecimal>(parts.length);
                    for (String p : parts) {
                        values.add(new BigDecimal(p));
                    }
                    if (values.size() >= minSize && values.size() <= maxSize) {
                        return this.toMediaValue(Collections.unmodifiableList(values));
                    }
                    MediaValidationCode invalidCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".invalid");
                    if (null != invalidCode) {
                        return this.toMediaError(invalidCode, MediaUtil.dictionary.add(VALUE, value).add("minSize", Integer.toString(minSize)).add("maxSize", Integer.toString(maxSize)));
                    }
                }
                catch (Exception e) {
                    MediaValidationCode invalidCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".invalid");
                    if (null == invalidCode) break block6;
                    return this.toMediaError(invalidCode, MediaUtil.dictionary.add(VALUE, value).add("minSize", Integer.toString(minSize)).add("maxSize", Integer.toString(maxSize)).add("exception", e.toString()));
                }
            }
        }
        MediaValidationCode missingCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".missing");
        return this.toMediaError(missingCode, MediaUtil.dictionary);
    }

    @Nonnull
    public <T extends Enum<T>> MediaValue<T> toMediaEnum(@Nonnull Class<T> enumType, @Nonnull String xmlPath, @Nullable String featureValidationCodePrefix) {
        block3: {
            String str = this.toXmlString(xmlPath);
            if (null != str) {
                try {
                    return this.toMediaValue(Enum.valueOf(enumType, str.toUpperCase()));
                }
                catch (Exception e) {
                    MediaValidationCode invalidCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".invalid");
                    if (null == invalidCode) break block3;
                    return this.toMediaError(invalidCode, MediaUtil.dictionary.add(VALUE, str));
                }
            }
        }
        MediaValidationCode missingCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".missing");
        return this.toMediaError(missingCode, MediaUtil.dictionary);
    }

    @Nonnull
    public MediaValue<FrameGeometry.Dimensions> toMediaDim(@Nonnull String xXmlPath, @Nonnull String yXmlPath, @Nullable String featureValidationCodePrefix) {
        block3: {
            String x = this.toXmlString(xXmlPath);
            String y = this.toXmlString(yXmlPath);
            if (null != x && null != y) {
                try {
                    long xValue = Long.parseLong(x);
                    long yValue = Long.parseLong(y);
                    return this.toMediaValue(new FrameGeometry.Dimensions(xValue, yValue));
                }
                catch (Exception e) {
                    MediaValidationCode invalidCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".invalid");
                    if (null == invalidCode) break block3;
                    return this.toMediaError(invalidCode, MediaUtil.dictionary.add("dimensions", x + "x" + y));
                }
            }
        }
        MediaValidationCode missingCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".missing");
        return this.toMediaError(missingCode, MediaUtil.dictionary);
    }

    @Nonnull
    public MediaValue<BigDecimal> toMediaDataRate(@Nonnull String valueXmlPath, @Nonnull String unitsXmlPath, @Nullable String featureValidationCodePrefix) {
        MediaValidationCode missingCode;
        block5: {
            missingCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".missing");
            MediaValidationCode badValue = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".invalid");
            String dataRate = this.toXmlString(valueXmlPath);
            String units = this.toXmlString(unitsXmlPath);
            if (null != dataRate && null != units) {
                try {
                    BigDecimal value = new BigDecimal(dataRate);
                    long bitRateUnit = this.bitRateUnitValue(units);
                    if (bitRateUnit > 0L) {
                        return this.toMediaValue(value.multiply(BigDecimal.valueOf(bitRateUnit)));
                    }
                    if (null != badValue) {
                        return this.toMediaError(badValue, MediaUtil.dictionary.add(VALUE, dataRate + " " + units));
                    }
                }
                catch (NumberFormatException e) {
                    if (null == badValue) break block5;
                    return this.toMediaError(badValue, MediaUtil.dictionary.add(VALUE, dataRate + " " + units));
                }
            }
        }
        return this.toMediaError(missingCode, MediaUtil.dictionary);
    }

    @Nonnull
    public MediaValue<SampleRate> toMediaSampleRate(@Nonnull String nXmlPath, @Nonnull String dXmlPath, @Nullable String featureValidationCodePrefix) {
        block3: {
            String n = this.toXmlString(nXmlPath);
            String d = this.toXmlString(dXmlPath);
            if (null != n && null != d) {
                try {
                    long numerator = Long.parseLong(n);
                    long denominator = Long.parseLong(d);
                    return this.toMediaValue(new SampleRate(1L, new Rational(numerator, denominator)));
                }
                catch (Exception unused) {
                    MediaValidationCode invalidCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".invalid");
                    if (null == invalidCode) break block3;
                    return this.toMediaError(invalidCode, MediaUtil.dictionary.add("sampleRate", n + "/" + d));
                }
            }
        }
        MediaValidationCode missingCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".missing");
        return this.toMediaError(missingCode, MediaUtil.dictionary);
    }

    @Nonnull
    public MediaValue<BigDecimal> toMediaDataSize(@Nonnull String valueXmlPath, @Nonnull String unitsXmlPath, @Nullable String featureValidationCodePrefix) {
        MediaValidationCode missingCode;
        block5: {
            missingCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".missing");
            MediaValidationCode badValue = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".invalid");
            String dataRate = this.toXmlString(valueXmlPath);
            String units = this.toXmlString(unitsXmlPath);
            if (null != dataRate && null != units) {
                try {
                    BigDecimal value = new BigDecimal(dataRate);
                    long bitSizeUnit = this.bitSizeUnitValue(units);
                    if (bitSizeUnit > 0L) {
                        return this.toMediaValue(value.multiply(BigDecimal.valueOf(bitSizeUnit)));
                    }
                    if (null != badValue) {
                        return this.toMediaError(badValue, MediaUtil.dictionary.add(VALUE, dataRate + " " + units));
                    }
                }
                catch (Exception unused) {
                    if (null == badValue) break block5;
                    return this.toMediaError(badValue, MediaUtil.dictionary.add(VALUE, dataRate + " " + units));
                }
            }
        }
        return this.toMediaError(missingCode, MediaUtil.dictionary);
    }

    @Nonnull
    public MediaValue<MediaTime> toMediaDuration(@Nullable Duration duration, @Nullable String featureValidationCodePrefix) {
        if (null != duration) {
            if (duration.isSetMilliseconds()) {
                return this.toMediaValue(new MediaTime(duration.getMilliseconds(), 1000L));
            }
            MediaValue<MediaTime> mediaTimeMediaValue = this.getMediaTimeMediaValue(duration, featureValidationCodePrefix);
            if (mediaTimeMediaValue != null) {
                return mediaTimeMediaValue;
            }
        }
        MediaValidationCode missingCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".missing");
        return this.toMediaError(missingCode, MediaUtil.dictionary);
    }

    @Nonnull
    public MediaValue<MediaTime> toMediaDuration(@Nonnull String valueXmlPath, @Nonnull String unitsXmlPath, @Nullable String featureValidationCodePrefix) {
        MediaValidationCode missingCode;
        block6: {
            missingCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".missing");
            MediaValidationCode badValue = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".invalid");
            String duration = this.toXmlString(valueXmlPath);
            String units = this.toXmlString(unitsXmlPath);
            if (null != duration && null != units) {
                try {
                    double value = Double.parseDouble(duration);
                    if ("milliseconds".equalsIgnoreCase(units) || "ms".equalsIgnoreCase(units)) {
                        return this.toMediaValue(new MediaTime(Math.round(value), 1000L));
                    }
                    if ("seconds".equalsIgnoreCase(units) || "s".equalsIgnoreCase(units)) {
                        return this.toMediaValue(new MediaTime(Math.round(value * 1000.0), 1000L));
                    }
                    if (null != badValue) {
                        return this.toMediaError(badValue, MediaUtil.dictionary.add(VALUE, duration + " " + units));
                    }
                }
                catch (NumberFormatException e) {
                    if (null == badValue) break block6;
                    return this.toMediaError(badValue, MediaUtil.dictionary.add(VALUE, duration + " " + units));
                }
            }
        }
        return this.toMediaError(missingCode, MediaUtil.dictionary);
    }

    public boolean toXmlBoolean(@Nonnull String xmlPath) {
        String value = this.toXmlString(xmlPath);
        return "true".equalsIgnoreCase(value);
    }

    @Nullable
    public final String getNodeValue(@Nonnull String nodeName) {
        return this.getNodeValue(nodeName, 0);
    }

    @Nullable
    public final String getNodeValue(@Nonnull String nodeName, int index) {
        try {
            Node n = ((Element)this.xmlObject.getDomNode()).getElementsByTagNameNS("*", nodeName).item(index);
            return n.getChildNodes().item(0).getNodeValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void processNotificationList(@Nullable NotificationList notificationList, @Nonnull MediaValidationCode defaultCode) {
        if (notificationList == null) {
            return;
        }
        for (Notification item : notificationList.getNotificationArray()) {
            MediaValidationCode itemCode = MediaValidationCode.valueOfStringCode(item.getCode());
            MediaValidationCode validationCode = itemCode != null ? itemCode : defaultCode;
            ValidationLevel defaultLevel = itemCode != null ? validationCode.getDefaultLevel() : ValidationLevel.valueOfString(item.getLevel(), defaultCode.getDefaultLevel());
            Dictionary dictionary = item.getParameters();
            if (validationCode == MediaValidationCode.DATA_INFO) {
                for (DictionaryEntry entry : dictionary.getEntryArray()) {
                    this.mediaDataMap.put(entry.getKey(), entry.getStringValue());
                }
                return;
            }
            SimpleDictionary parameters = MediaUtil.dictionary;
            for (DictionaryEntry entry : dictionary.getEntryArray()) {
                parameters = parameters.add(entry.getKey(), entry.getStringValue());
            }
            this.addIssue(validationCode, defaultLevel, parameters);
        }
    }

    public static final double toXmlDuration(@Nullable XmlObject xmlObject, @Nonnull String xmlAttr) {
        if (xmlObject != null) {
            String durationMilliAttr = XmlObjectMediaParser.toXmlAttrString(xmlObject, xmlAttr);
            return StringUtils.isNotBlank((CharSequence)durationMilliAttr) ? Double.parseDouble(durationMilliAttr) : Double.parseDouble(xmlObject.newCursor().getTextValue());
        }
        return 0.0;
    }

    @Nonnull
    public MediaValue<BigDecimal> uuidToMediaDecimal(@Nonnull String xmlPath, @Nullable String featureValidationCodePrefix) {
        block3: {
            String strValue = this.toXmlString(xmlPath);
            if (!StringUtils.isEmpty((CharSequence)strValue)) {
                try {
                    String cleanStr = strValue.toLowerCase().replaceAll("-", "");
                    BigInteger hexStr = new BigInteger(cleanStr, 16);
                    return this.toMediaValue(new BigDecimal(hexStr));
                }
                catch (Exception e) {
                    MediaValidationCode invalidCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".invalid");
                    if (null == invalidCode) break block3;
                    return this.toMediaError(invalidCode, MediaUtil.dictionary.add(VALUE, strValue));
                }
            }
        }
        MediaValidationCode missingCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".missing");
        return this.toMediaError(missingCode, MediaUtil.dictionary);
    }

    private MediaValue<MediaTime> getMediaTimeMediaValue(@Nonnull Duration duration, @Nullable String featureValidationCodePrefix) {
        block5: {
            MediaValidationCode invalidCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".invalid");
            String durationValue = duration.getStringValue();
            String durationUnits = duration.getUnits();
            if (null != durationValue) {
                try {
                    long durationUnitInMilliseconds;
                    long l = durationUnitInMilliseconds = null == durationUnits ? 1L : this.timeUnitInMillisecondsValue(durationUnits);
                    if (durationUnitInMilliseconds > 0L) {
                        return this.toMediaValue(new MediaTime(new BigDecimal(durationValue).multiply(BigDecimal.valueOf(durationUnitInMilliseconds)).longValue(), 1000L));
                    }
                    if (null != invalidCode) {
                        return this.toMediaError(invalidCode, MediaUtil.dictionary.add(VALUE, durationValue + " " + durationUnits));
                    }
                }
                catch (Exception e) {
                    if (null == invalidCode) break block5;
                    return this.toMediaError(invalidCode, MediaUtil.dictionary.add(VALUE, durationValue));
                }
            }
        }
        return null;
    }

    private long bitRateUnitValue(@Nonnull String units) {
        switch (units.toLowerCase()) {
            case "bps": 
            case "b/s": {
                return 1L;
            }
            case "kbps": 
            case "kb/s": {
                return 1000L;
            }
            case "kibps": 
            case "kib/s": {
                return 1024L;
            }
            case "mbps": 
            case "mb/s": {
                return 1000000L;
            }
            case "mibps": 
            case "mib/s": {
                return 0x100000L;
            }
            case "gbps": 
            case "gb/s": {
                return 1000000000L;
            }
            case "gibps": 
            case "gib/s": {
                return 0x40000000L;
            }
            case "tbps": 
            case "tb/s": {
                return 1000000000000L;
            }
            case "tibps": 
            case "tib/s": {
                return 0x10000000000L;
            }
        }
        return 0L;
    }

    private long bitSizeUnitValue(@Nonnull String units) {
        switch (units.toLowerCase()) {
            case "b": 
            case "bytes": {
                return 1L;
            }
            case "kb": 
            case "kbytes": 
            case "kilobytes": {
                return 1000L;
            }
            case "kib": 
            case "kibytes": 
            case "kibibytes": {
                return 1024L;
            }
            case "mb": 
            case "mbytes": 
            case "megabytes": 
            case "megs": {
                return 1000000L;
            }
            case "mi": 
            case "mibytes": 
            case "mebibytes": {
                return 0x100000L;
            }
            case "gb": 
            case "gbytes": 
            case "gigabytes": 
            case "gigs": {
                return 1000000000L;
            }
            case "gib": 
            case "gibytes": 
            case "gibibytes": {
                return 0x40000000L;
            }
            case "tb": 
            case "tbytes": 
            case "terabytes": {
                return 1000000000000L;
            }
            case "pb": 
            case "pbytes": 
            case "petabytes": {
                return 1000000000000000L;
            }
        }
        return 0L;
    }

    private long timeUnitInMillisecondsValue(@Nonnull String units) {
        switch (units.toLowerCase()) {
            case "ms": 
            case "msec": 
            case "millisec": 
            case "milliseconds": {
                return 1L;
            }
            case "s": 
            case "sec": 
            case "seconds": {
                return 1000L;
            }
            case "m": 
            case "min": 
            case "minutes": {
                return 60000L;
            }
            case "h": 
            case "hr": 
            case "hours": {
                return 3600000L;
            }
            case "d": 
            case "days": {
                return 86400000L;
            }
        }
        return 0L;
    }
}

