/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.xml;

import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.MediaValueError;
import com.apple.jingle.leghorn.media.MediaValueImpl;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.validator.SimpleDictionary;
import com.apple.jingle.leghorn.media.validator.ValidationLevel;
import com.apple.jingle.leghorn.media.validator.ValidationResult;
import com.apple.jingle.leghorn.timecode.SampleRate;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

public class JsonMediaParser {
    @Nonnull
    protected final JsonObject xmlObject;
    @Nonnull
    protected final MediaFileContext metaFile;
    @Nonnull
    protected final String name;
    @Nonnull
    protected final Map<String, String> mediaDataMap = new HashMap<String, String>();

    public JsonMediaParser(@Nonnull MediaFileContext metaFile, @Nonnull String name, @Nonnull JsonObject xmlObject) {
        assert (null != name);
        assert (null != xmlObject);
        assert (null != metaFile);
        this.name = name;
        this.xmlObject = xmlObject;
        this.metaFile = metaFile;
    }

    @Nonnull
    public JsonMediaParser childParser(String childName) {
        return new JsonMediaParser(this.metaFile.child(childName), this.name + "#" + childName, this.xmlObject);
    }

    public String toString() {
        return "Parser[" + this.xmlObject + "]";
    }

    @Nullable
    public JsonMediaParser child(String elementName) {
        JsonArray a;
        JsonValue v = (JsonValue)this.xmlObject.get((Object)elementName);
        if (v instanceof JsonObject) {
            return new JsonMediaParser(this.metaFile, this.name, (JsonObject)v);
        }
        if (v instanceof JsonArray && (a = (JsonArray)v).size() >= 1 && (v = (JsonValue)a.get(0)) instanceof JsonObject) {
            return new JsonMediaParser(this.metaFile, this.name, (JsonObject)v);
        }
        return null;
    }

    @Nonnull
    public Collection<JsonMediaParser> children(String elementName) {
        JsonValue v = (JsonValue)this.xmlObject.get((Object)elementName);
        if (v instanceof JsonObject) {
            return Collections.singleton(new JsonMediaParser(this.metaFile, this.name, (JsonObject)v));
        }
        if (v instanceof JsonArray) {
            JsonArray a = (JsonArray)v;
            ArrayList<JsonMediaParser> children = new ArrayList<JsonMediaParser>(a.size());
            for (JsonValue v2 : a) {
                if (!(v2 instanceof JsonObject)) continue;
                children.add(new JsonMediaParser(this.metaFile, this.name, (JsonObject)v2));
            }
            return children;
        }
        return Collections.emptyList();
    }

    @Nonnull
    protected final ValidationResult addIssue(@Nonnull MediaValidationCode code, @Nonnull SimpleDictionary parameters) {
        return this.metaFile.addIssue(code, this.name, parameters);
    }

    @Nonnull
    protected final ValidationResult addIssue(@Nonnull MediaValidationCode code, @Nonnull ValidationLevel defaultLevel, @Nonnull SimpleDictionary parameters) {
        return this.metaFile.addIssue(code, defaultLevel, this.name, parameters);
    }

    @Nonnull
    public final <T> MediaValue<T> toMediaValue(@Nullable T object) {
        return new MediaValueImpl<T>(object);
    }

    @Nonnull
    public final <T> MediaValue<T> toMediaError(@Nullable MediaValidationCode validationCode, @Nonnull SimpleDictionary parms) {
        if (null == validationCode) {
            return this.toMediaValue(null);
        }
        ValidationResult vr = this.addIssue(validationCode, parms);
        return new MediaValueError(vr);
    }

    @Nullable
    public final JsonValue toJsonValue(@Nonnull String path) {
        return (JsonValue)this.xmlObject.get((Object)path);
    }

    public String toStringValue(@Nonnull String xmlPath, String defaultValue) {
        JsonValue value = this.toJsonValue(xmlPath);
        if (null != value) {
            switch (value.getValueType()) {
                case ARRAY: {
                    break;
                }
                case FALSE: {
                    return "false";
                }
                case NULL: {
                    return null;
                }
                case NUMBER: {
                    return ((JsonNumber)value).bigDecimalValue().toPlainString();
                }
                case OBJECT: {
                    break;
                }
                case STRING: {
                    return ((JsonString)value).getString();
                }
                case TRUE: {
                    return "true";
                }
            }
        }
        return defaultValue;
    }

    @Nonnull
    public MediaValue<String> toMediaString(@Nonnull String xmlPath, @Nullable String featureValidationCodePrefix) {
        JsonValue value = this.toJsonValue(xmlPath);
        if (null != value) {
            switch (value.getValueType()) {
                case ARRAY: {
                    break;
                }
                case FALSE: {
                    return this.toMediaValue("false");
                }
                case NULL: {
                    return this.toMediaValue(null);
                }
                case NUMBER: {
                    return this.toMediaValue(((JsonNumber)value).bigDecimalValue().toPlainString());
                }
                case OBJECT: {
                    break;
                }
                case STRING: {
                    return this.toMediaValue(((JsonString)value).getString());
                }
                case TRUE: {
                    return this.toMediaValue("true");
                }
            }
        }
        MediaValidationCode missingCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".missing");
        return this.toMediaError(missingCode, MediaUtil.dictionary);
    }

    @Nonnull
    protected final MediaValue<Boolean> toMediaBoolean(@Nonnull String xmlPath, @Nullable String featureValidationCodePrefix) {
        MediaValidationCode invalidCode;
        JsonValue value = this.toJsonValue(xmlPath);
        String strValue = null;
        if (null != value) {
            switch (value.getValueType()) {
                case ARRAY: {
                    break;
                }
                case FALSE: {
                    return this.toMediaValue(false);
                }
                case NULL: {
                    return this.toMediaValue(null);
                }
                case NUMBER: {
                    strValue = ((JsonNumber)value).bigDecimalValue().toPlainString();
                    break;
                }
                case OBJECT: {
                    break;
                }
                case STRING: {
                    strValue = ((JsonString)value).getString();
                    if ("true".equals(strValue)) {
                        return this.toMediaValue(true);
                    }
                    if (!"false".equals(strValue)) break;
                    return this.toMediaValue(false);
                }
                case TRUE: {
                    return this.toMediaValue(true);
                }
            }
        }
        if (null != strValue && null != (invalidCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".invalid"))) {
            return this.toMediaError(invalidCode, MediaUtil.dictionary.add("value", strValue));
        }
        MediaValidationCode missingCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".missing");
        return this.toMediaError(missingCode, MediaUtil.dictionary);
    }

    @Nonnull
    public MediaValue<BigDecimal> toMediaDecimal(@Nonnull String xmlPath, BigDecimal defaultValue, @Nullable String featureValidationCodePrefix) {
        JsonValue value = this.toJsonValue(xmlPath);
        String strValue = null;
        if (null != value) {
            switch (value.getValueType()) {
                case ARRAY: {
                    break;
                }
                case FALSE: {
                    strValue = "false";
                    break;
                }
                case NULL: {
                    return this.toMediaValue(null);
                }
                case NUMBER: {
                    return this.toMediaValue(((JsonNumber)value).bigDecimalValue());
                }
                case OBJECT: {
                    break;
                }
                case STRING: {
                    strValue = ((JsonString)value).getString();
                    try {
                        return this.toMediaValue(new BigDecimal(strValue));
                    }
                    catch (NumberFormatException e) {
                        MediaValidationCode invalidCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".invalid");
                        if (null != invalidCode) {
                            return this.toMediaError(invalidCode, MediaUtil.dictionary.add("value", strValue));
                        }
                        break;
                    }
                }
                case TRUE: {
                    strValue = "true";
                    break;
                }
            }
        } else if (null != defaultValue) {
            return this.toMediaValue(defaultValue);
        }
        MediaValidationCode missingCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".missing");
        return this.toMediaError(missingCode, MediaUtil.dictionary);
    }

    @Nonnull
    public MediaValue<List<BigDecimal>> toMediaDecimalList(@Nonnull String xmlPath, int minSize, int maxSize, @Nullable String featureValidationCodePrefix) {
        MediaValidationCode invalidCode;
        JsonValue value = this.toJsonValue(xmlPath);
        if (value instanceof JsonArray) {
            JsonValue v;
            JsonArray array = (JsonArray)value;
            ArrayList<BigDecimal> values = new ArrayList<BigDecimal>(array.size());
            Iterator i$ = array.iterator();
            while (i$.hasNext() && (v = (JsonValue)i$.next()) instanceof JsonNumber) {
                values.add(((JsonNumber)v).bigDecimalValue());
            }
            if (values.size() >= minSize && values.size() <= maxSize) {
                return this.toMediaValue(Collections.unmodifiableList(values));
            }
        }
        if (null != value && null != (invalidCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".invalid"))) {
            return this.toMediaError(invalidCode, MediaUtil.dictionary.add("value", value.toString()));
        }
        MediaValidationCode missingCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".missing");
        return this.toMediaError(missingCode, MediaUtil.dictionary);
    }

    @Nonnull
    public MediaValue<BigDecimal> uuidToMediaDecimal(@Nonnull String xmlPath, @Nullable String featureValidationCodePrefix) {
        MediaValidationCode invalidCode;
        JsonValue value = this.toJsonValue(xmlPath);
        String strValue = null;
        if (null != value) {
            switch (value.getValueType()) {
                case ARRAY: {
                    break;
                }
                case FALSE: {
                    strValue = "false";
                    break;
                }
                case NULL: {
                    return this.toMediaValue(null);
                }
                case NUMBER: {
                    return this.toMediaValue(((JsonNumber)value).bigDecimalValue());
                }
                case OBJECT: {
                    break;
                }
                case STRING: {
                    strValue = ((JsonString)value).getString();
                    String cleanStr = strValue.toLowerCase().replaceAll("-", "");
                    BigInteger hexStr = new BigInteger(cleanStr, 16);
                    try {
                        return this.toMediaValue(new BigDecimal(hexStr));
                    }
                    catch (NumberFormatException e) {
                        MediaValidationCode invalidCode2 = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".invalid");
                        if (null == invalidCode2) break;
                        return this.toMediaError(invalidCode2, MediaUtil.dictionary.add("value", strValue));
                    }
                }
                case TRUE: {
                    strValue = "true";
                    break;
                }
            }
        }
        if (null != strValue && null != (invalidCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".invalid"))) {
            return this.toMediaError(invalidCode, MediaUtil.dictionary.add("value", strValue));
        }
        MediaValidationCode missingCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".missing");
        return this.toMediaError(missingCode, MediaUtil.dictionary);
    }

    @Nonnull
    public MediaValue<SampleRate> toMediaSampleRate(@Nonnull String xmlPath, @Nullable String featureValidationCodePrefix) {
        MediaValue<SampleRate> rate;
        String xmlRate = this.toStringValue("rate", null);
        if (null == xmlRate) {
            return this.toMediaError(MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".missing"), MediaUtil.dictionary);
        }
        try {
            rate = new MediaValueImpl<SampleRate>(new SampleRate(xmlRate));
        }
        catch (Exception e) {
            rate = this.toMediaError(MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".invalid"), MediaUtil.dictionary.add("value", xmlRate));
        }
        return rate;
    }
}

