/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.validator.conformance;

import com.apple.jingle.leghorn.media.Media;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.feature.MediaFeature;
import com.apple.jingle.leghorn.media.file.MediaFile;
import com.apple.jingle.leghorn.media.file.MediaTrack;
import com.apple.jingle.leghorn.media.validator.ValidationResultSet;
import com.apple.jingle.leghorn.media.validator.conformance.MediaValidator;
import com.apple.jingle.leghorn.media.validator.conformance.PerformsValidation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class MediaValidatorSet {
    private final TreeMap<String, List<MediaValidator<?>>> validatorsByProfileName = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private final List<MediaValidator<?>> allValidators = new LinkedList();

    protected MediaValidatorSet() {
        for (Class<?> type = this.getClass(); type != null; type = type.getSuperclass()) {
            for (Method m : type.getDeclaredMethods()) {
                MediaValidator<?> validator = this.toMediaValidator(m);
                if (null == validator) continue;
                this.allValidators.add(validator);
                for (String profileName : validator.supportedProfileNames()) {
                    List<MediaValidator<?>> validators = this.validatorsByProfileName.get(profileName);
                    if (null == validators) {
                        validators = new LinkedList();
                        this.validatorsByProfileName.put(profileName, validators);
                    }
                    validators.add(validator);
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append(this.getClass().getSimpleName()).append('[');
        boolean first = true;
        for (MediaValidator<?> v : this.allValidators) {
            sb.append("\n").append(v.toString());
            first = false;
        }
        if (!first) {
            sb.append("\n");
        }
        return sb.append("]").toString();
    }

    @Nullable
    protected MediaValidator<?> toMediaValidator(final @Nonnull Method m) {
        PerformsValidation validation = m.getAnnotation(PerformsValidation.class);
        Class<?>[] parameters = m.getParameterTypes();
        if (null == validation) {
            return null;
        }
        if (parameters.length != 2) {
            System.err.println("Found @PerformsValidation annotation on method parameter count != 2: " + m);
            return null;
        }
        if (!Media.class.isAssignableFrom(parameters[0])) {
            System.err.println("Method with @PerformsValidation must take a Media as the first parameter: " + m);
            return null;
        }
        if (!parameters[1].isAssignableFrom(ValidationResultSet.class)) {
            System.err.println("Method with @PerformsValidation must take a ValidationResultSet as the second parameter: " + m);
            return null;
        }
        if (!m.isAccessible()) {
            m.setAccessible(true);
        }
        final TreeSet<String> profileNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        profileNames.addAll(Arrays.asList(validation.value()));
        final Class<?> mediaType = parameters[0];
        return new MediaValidator<Media>(){

            @Override
            public void validateMedia(@Nonnull Media media, @Nonnull ValidationResultSet validations) {
                try {
                    m.invoke((Object)MediaValidatorSet.this, media, validations);
                }
                catch (Exception e) {
                    validations.addResult(MediaValidationCode.ASSET_VALIDATOR_FAILURE, media.getMediaName(), MediaUtil.dictionary.add("errorMessage", e.toString()));
                }
            }

            @Override
            public Class<? extends Media> supportedMediaType() {
                return mediaType;
            }

            @Override
            public Set<String> supportedProfileNames() {
                return profileNames;
            }

            public String toString() {
                return m.getName() + "[" + this.supportedMediaType().getSimpleName() + " for " + profileNames + "]";
            }
        };
    }

    @Nonnull
    protected final Collection<MediaValidator<?>> getValidatorForProfiles(String ... profileNames) {
        LinkedHashSet validators = new LinkedHashSet();
        for (String profileName : profileNames) {
            Collection profileValidators = this.validatorsByProfileName.get(profileName);
            if (null == profileValidators) continue;
            validators.addAll(profileValidators);
        }
        return validators;
    }

    public void validate(@Nonnull MediaFile mediaFile, @Nonnull ValidationResultSet results, String ... profileNames) {
        Collection<MediaValidator<?>> validators = this.getValidatorForProfiles(profileNames);
        if (null == validators || validators.isEmpty()) {
            return;
        }
        for (MediaValidator<?> mediaValidator : validators) {
            if (!mediaValidator.supportedMediaType().isInstance(mediaFile)) continue;
            MediaValidator<?> fileValidator = mediaValidator;
            fileValidator.validateMedia(mediaFile, results);
        }
        for (MediaTrack mediaTrack : mediaFile.getTracks()) {
            for (MediaValidator<?> validator : validators) {
                if (!validator.supportedMediaType().isInstance(mediaTrack)) continue;
                MediaValidator<?> fileValidator = validator;
                fileValidator.validateMedia(mediaTrack, results);
            }
        }
    }

    public void validate(@Nonnull MediaTrack mediaTrack, @Nonnull ValidationResultSet results, @Nonnull String profileName) {
        Collection validators = this.validatorsByProfileName.get(profileName);
        if (null == validators) {
            return;
        }
        for (MediaValidator validator : validators) {
            if (!validator.supportedMediaType().isInstance(mediaTrack)) continue;
            MediaValidator fileValidator = validator;
            fileValidator.validateMedia(mediaTrack, results);
        }
    }

    public void validate(@Nonnull MediaFeature mediaFeature, @Nonnull ValidationResultSet results, @Nonnull String profileName) {
        Collection validators = this.validatorsByProfileName.get(profileName);
        if (null == validators) {
            return;
        }
        for (MediaValidator validator : validators) {
            if (!validator.supportedMediaType().isInstance(mediaFeature)) continue;
            MediaValidator fileValidator = validator;
            fileValidator.validateMedia(mediaFeature, results);
        }
    }
}

