/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.validator.conformance;

import com.apple.jingle.leghorn.media.MediaTrackCriteria;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.file.MediaFile;
import com.apple.jingle.leghorn.media.file.MediaSoundTrack;
import com.apple.jingle.leghorn.media.file.MediaTrackKind;
import com.apple.jingle.leghorn.media.file.quicktime.QtSubtitleTrack;
import com.apple.jingle.leghorn.media.file.quicktime.QtVideoTrack;
import com.apple.jingle.leghorn.media.file.quicktime.QuickTimeMediaFile;
import com.apple.jingle.leghorn.media.validator.ValidationResultSet;
import com.apple.jingle.leghorn.media.validator.conformance.MediaValidatorSet;
import com.apple.jingle.leghorn.media.validator.conformance.PerformsValidation;
import com.apple.jingle.locale.LocaleCode;
import java.util.HashMap;
import javax.annotation.Nonnull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IntermediateConformanceChecks
extends MediaValidatorSet {
    public static final IntermediateConformanceChecks singleton = new IntermediateConformanceChecks();

    private IntermediateConformanceChecks() {
    }

    @PerformsValidation(value={"All"})
    public void feature51SurroundAndLeftRightInOneOrTwoTracks(@Nonnull QtSubtitleTrack track, @Nonnull ValidationResultSet results) {
        for (Integer sampleNo : track.samplesWithMissingFontTable()) {
            results.addResult(MediaValidationCode.ITT_SAMPLE_MISSING_FTAB, track.getMediaName(), MediaUtil.dictionary.add("sampleNo", sampleNo.toString()));
        }
    }

    @PerformsValidation(value={"PostCombine", "PostBundle"})
    public void featureShouldOnlyHaveOneSampleDescriptor(@Nonnull QtVideoTrack track, @Nonnull ValidationResultSet results) {
        int outputVidInfoSampleDescriptionCount = track.getSampleDescriptionCount();
        if (outputVidInfoSampleDescriptionCount != 1) {
            results.addResult(MediaValidationCode.MOV_TOO_MANY_SAMPLE_DESCRIPTORS, track.getMediaName(), MediaUtil.dictionary.add("sampleDescriptors", Integer.toString(track.getSampleDescriptionCount())));
        }
    }

    @PerformsValidation(value={"PostBundle"})
    public void checkAudioOrder(@Nonnull MediaFile mediaFile, @Nonnull ValidationResultSet results) {
        HashMap<LocaleCode, MediaSoundTrack> firstSoundByLocale = new HashMap<LocaleCode, MediaSoundTrack>();
        for (MediaSoundTrack currentSoundTrack : mediaFile.getTracks(MediaSoundTrack.class, new MediaTrackCriteria[0])) {
            if (currentSoundTrack.getLocale() == null) continue;
            MediaSoundTrack firstSoundTrack = (MediaSoundTrack)firstSoundByLocale.get(currentSoundTrack.getLocale());
            if (null == firstSoundTrack) {
                firstSoundByLocale.put(currentSoundTrack.getLocale(), currentSoundTrack);
                continue;
            }
            if (currentSoundTrack.getMediaTrackKind() != MediaTrackKind.AUDIO) continue;
            if (firstSoundTrack.getMediaTrackKind() != MediaTrackKind.AUDIO) {
                results.addResult(MediaValidationCode.MOV_DEFAULT_AUDIO_TRACK_MUST_BE_FIRST, mediaFile.getMediaName(), MediaUtil.dictionary.add("localeCode", currentSoundTrack.getLocale().toString()).add("firstTrack", firstSoundTrack.toString()).add("currentTrack", currentSoundTrack.toString()));
                continue;
            }
            if (firstSoundTrack.channels().size() <= currentSoundTrack.channels().size()) continue;
            results.addResult(MediaValidationCode.MOV_DEFAULT_AUDIO_TRACK_MUST_BE_FIRST, mediaFile.getMediaName(), MediaUtil.dictionary.add("localeCode", currentSoundTrack.getLocale().toString()).add("firstTrack", firstSoundTrack.toString()).add("currentTrack", currentSoundTrack.toString()));
        }
    }

    @PerformsValidation(value={"PostBundle"})
    public void checkTgasAlternateGroups(@Nonnull MediaFile mediaFile, @Nonnull ValidationResultSet results) {
        if (mediaFile instanceof QuickTimeMediaFile) {
            Node xmlDescNode = ((QuickTimeMediaFile)mediaFile).getXmlDescriptionNode();
            Element xmlDescDoc = null;
            try {
                xmlDescDoc = (Element)xmlDescNode;
            }
            catch (ClassCastException ignored) {
                // empty catch block
            }
            this.performTgasAlternateGroupsValidation(mediaFile.getMediaName(), xmlDescDoc, results);
        }
    }

    public void performTgasAlternateGroupsValidation(String mediaName, Element xmlDescription, @Nonnull ValidationResultSet results) {
        if (xmlDescription != null) {
            NodeList webvttSubtitleNodes = xmlDescription.getElementsByTagName("webvtt_subtitle");
            HashMap<Integer, Integer> groupMap = new HashMap<Integer, Integer>();
            HashMap<Integer, String> typeMap = new HashMap<Integer, String>();
            for (int i = 0; i < webvttSubtitleNodes.getLength(); ++i) {
                Integer altGrp;
                Element webvttSubtitle = (Element)webvttSubtitleNodes.item(i);
                String type = webvttSubtitle.getAttribute("type").trim();
                Node altGrpNode = webvttSubtitle.getElementsByTagName("alternate_group").item(0);
                Node toAltGrpNode = webvttSubtitle.getElementsByTagName("to_alternate_group").item(0);
                if (altGrpNode == null) continue;
                String altGrpString = this.getTextContent(altGrpNode).trim();
                try {
                    altGrp = Integer.parseInt(altGrpString);
                    typeMap.put(altGrp, type);
                }
                catch (NumberFormatException nfe) {
                    results.addResult(MediaValidationCode.VTT_GROUPID_NONINTEGER, mediaName, MediaUtil.dictionary.add("groupType", "alternate_group").add("groupIdValue", altGrpString));
                    continue;
                }
                if (toAltGrpNode == null) continue;
                String toAltGrpString = this.getTextContent(toAltGrpNode).trim();
                try {
                    Integer toAltGrp = Integer.parseInt(toAltGrpString);
                    groupMap.put(altGrp, toAltGrp);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    results.addResult(MediaValidationCode.VTT_GROUPID_NONINTEGER, mediaName, MediaUtil.dictionary.add("groupType", "to_alternate_group").add("groupIdValue", toAltGrpString));
                }
            }
            for (Integer altGrp : groupMap.keySet()) {
                Integer toAltGrp = (Integer)groupMap.get(altGrp);
                if (!typeMap.containsKey(toAltGrp)) {
                    results.addResult(MediaValidationCode.VTT_ALTERNATE_GROUP_MISSING, mediaName, MediaUtil.dictionary.add("toAltGrp", toAltGrp.toString()));
                    continue;
                }
                if (!((String)typeMap.get(altGrp)).equals(typeMap.get(toAltGrp))) {
                    results.addResult(MediaValidationCode.VTT_ALTERNATE_GROUP_TYPE_MISMATCH, mediaName, MediaUtil.dictionary.add("altGrp", (String)typeMap.get(altGrp)).add("toAltGrp", (String)typeMap.get(toAltGrp)));
                }
                if (toAltGrp != 0) continue;
                results.addResult(MediaValidationCode.VTT_ALTERNATE_GROUP_INVALID, mediaName, MediaUtil.dictionary.add("toAltGrp", (String)typeMap.get(toAltGrp)));
            }
        }
    }

    private String getTextContent(Node n) {
        try {
            return n.getChildNodes().item(0).getNodeValue();
        }
        catch (Exception ignored) {
            return "";
        }
    }
}

