/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.validator.conformance;

import com.apple.jingle.foghorn.media.types.ColorSpace;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.feature.MediaAudioChannel;
import com.apple.jingle.leghorn.media.feature.extractor.AudioFeatureExtractor;
import com.apple.jingle.leghorn.media.file.MediaFile;
import com.apple.jingle.leghorn.media.file.MediaSoundTrack;
import com.apple.jingle.leghorn.media.file.MediaTrackKind;
import com.apple.jingle.leghorn.media.file.MediaVideoTrack;
import com.apple.jingle.leghorn.media.file.quicktime.QtVideoTrack;
import com.apple.jingle.leghorn.media.validator.ValidationResultSet;
import com.apple.jingle.leghorn.media.validator.conformance.MediaValidatorSet;
import com.apple.jingle.leghorn.media.validator.conformance.PerformsValidation;
import com.apple.jingle.leghorn.timecode.MediaTime;
import java.util.LinkedList;
import javax.annotation.Nonnull;

public class Feature51Verification
extends MediaValidatorSet {
    @PerformsValidation(value={"Feature.5.1.SurroundAndLeftRightInOneOrTwoTracks"})
    public void feature51SurroundAndLeftRightInOneOrTwoTracks(@Nonnull MediaFile mediaFile, @Nonnull ValidationResultSet results) {
        AudioFeatureExtractor audioFeatureExtractor = new AudioFeatureExtractor(mediaFile);
        if (!(audioFeatureExtractor.hasValidChannelMap() || mediaFile.hasTrack(MediaTrackKind.VIDEO) && audioFeatureExtractor.detectedFormats().isEmpty())) {
            results.addResult(MediaValidationCode.AUDIO_MISSING, mediaFile.getMediaName(), MediaUtil.dictionary);
        }
    }

    @PerformsValidation(value={"Feature.5.1.ValidChannelLabels"})
    public void feature51ValidChannelLabels(@Nonnull MediaFile mediaFile, @Nonnull ValidationResultSet results) {
        LinkedList<MediaAudioChannel> badChannels = new LinkedList<MediaAudioChannel>();
        for (MediaSoundTrack audioTrack : mediaFile.getTracks(MediaSoundTrack.class, MediaTrackKind.AUDIO)) {
            for (MediaAudioChannel ch : audioTrack.channels()) {
                if (AudioFeatureExtractor.surround71Channels.contains((Object)ch) || AudioFeatureExtractor.stereoVariants.contains((Object)ch)) continue;
                badChannels.add(ch);
            }
        }
        if (!badChannels.isEmpty()) {
            results.addResult(MediaValidationCode.AUDIO_CHLABEL_INVALID, mediaFile.getMediaName(), MediaUtil.dictionary.add("channelName", badChannels.toString()));
        }
    }

    @PerformsValidation(value={"Feature.7.1.ValidChannelLabels"})
    public void feature71ValidChannelLabels(@Nonnull MediaFile mediaFile, @Nonnull ValidationResultSet results) {
        LinkedList<MediaAudioChannel> badChannels = new LinkedList<MediaAudioChannel>();
        for (MediaSoundTrack audioTrack : mediaFile.getTracks(MediaSoundTrack.class, MediaTrackKind.AUDIO)) {
            for (MediaAudioChannel ch : audioTrack.channels()) {
                if (AudioFeatureExtractor.surround71Channels.contains((Object)ch) || AudioFeatureExtractor.stereoVariants.contains((Object)ch)) continue;
                badChannels.add(ch);
            }
        }
        if (!badChannels.isEmpty()) {
            results.addResult(MediaValidationCode.AUDIO_CHLABEL_INVALID, mediaFile.getMediaName(), MediaUtil.dictionary.add("channelName", badChannels.toString()));
        }
    }

    @PerformsValidation(value={"SupportedColorSpace", "SupportedColorSpace.SocialMedia"})
    public void blacklistVideoDuration(@Nonnull QtVideoTrack videoTrack, @Nonnull ValidationResultSet results) {
        MediaValue<ColorSpace> colorSpace = videoTrack.actualColorSpace();
        if (colorSpace.hasError()) {
            results.addResult(colorSpace.getError());
        } else if (colorSpace.hasNonNullValue()) {
            ColorSpace cs = colorSpace.get();
            if (cs == ColorSpace.BT601 || cs == ColorSpace.BT709) {
                return;
            }
            results.addResult(MediaValidationCode.VIDEO_COLORSPACE_INVALID, videoTrack.getMediaName(), MediaUtil.dictionary.add("colorSpace", cs.toString()));
        } else {
            results.addResult(MediaValidationCode.VIDEO_COLORSPACE_MISSING, videoTrack.getMediaName(), MediaUtil.dictionary.add("colorSpace", "unknown"));
        }
    }

    @PerformsValidation(value={"BlacklistVideoDuration"})
    public void blacklistVideoDuration(@Nonnull MediaVideoTrack videoTrack, @Nonnull ValidationResultSet results) {
        MediaTime duration = videoTrack.duration().get();
        if (duration.getTotalMilliseconds() < 2000L) {
            results.addResult(MediaValidationCode.MOV_DURATION_TOO_SHORT, videoTrack.getMediaName(), MediaUtil.dictionary.add("value", duration.toString()));
        }
    }
}

