/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.validator.conformance;

import com.apple.jingle.leghorn.media.MediaTrackCriteria;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.feature.AudioFormat;
import com.apple.jingle.leghorn.media.feature.MediaAudioChannel;
import com.apple.jingle.leghorn.media.feature.extractor.AudioFeatureExtractor;
import com.apple.jingle.leghorn.media.file.MediaFile;
import com.apple.jingle.leghorn.media.file.quicktime.QtSoundTrack;
import com.apple.jingle.leghorn.media.file.quicktime.QuickTimeMediaFile;
import com.apple.jingle.leghorn.media.validator.ValidationResultSet;
import com.apple.jingle.leghorn.media.validator.conformance.MediaValidatorSet;
import com.apple.jingle.leghorn.media.validator.conformance.PerformsValidation;
import java.math.BigDecimal;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class AudioConformanceChecks
extends MediaValidatorSet {
    @Nonnull
    private final MediaFile mediaFile;
    @Nonnull
    private final AudioFeatureExtractor audioFeatureExtractor;
    public static final Set<String> permittedStereoCodecs = MediaUtil.immutableSetOf(String.CASE_INSENSITIVE_ORDER, "twos", "sowt", "lpcm", "in24", "raw");

    public AudioConformanceChecks(MediaFile mediaFile) {
        this.mediaFile = mediaFile;
        this.audioFeatureExtractor = new AudioFeatureExtractor(mediaFile);
    }

    @PerformsValidation(value={"L/Lt and R/Rt in one or two tracks", "MuxedLPCMStereoForAudioDemuxerRunner", "MuxedLPCMStereo", "Feature.Stereo"})
    public void stereo(@Nonnull QuickTimeMediaFile mediaFile, @Nonnull ValidationResultSet results) {
        if (!this.audioFeatureExtractor.detectedFormats().contains((Object)AudioFormat.stereo)) {
            results.addResult(MediaValidationCode.AUDIO_MISSING, mediaFile.getMediaName(), MediaUtil.dictionary);
        }
    }

    @PerformsValidation(value={"Sample Rate >= 48khz", "MuxedLPCMCommon", "MuxedLPCMStereo", "Feature.Stereo", "MuxedLPCMSurround51", "Feature.5.1", "MuxedLPCMSurround71", "Feature.7.1"})
    public void sampleRateAtLeast48kHz(@Nonnull QtSoundTrack track, @Nonnull ValidationResultSet results) {
        BigDecimal sampleRateInHz = track.sampleRateInHz().tryGet();
        if (null != sampleRateInHz && sampleRateInHz.longValue() < 47900L) {
            results.addResult(MediaValidationCode.AUDIO_SAMPLERATE_TOOSMALL, this.mediaFile.getMediaName(), MediaUtil.dictionary.add("sampleRate", sampleRateInHz.toPlainString()).add("minSampleRate", "48,000"));
        }
    }

    @PerformsValidation(value={"Has only video, sound, and timecode tracks", "MuxedLPCMCommon", "MuxedLPCMStereoForAudioDemuxerRunner", "MuxedLPCMStereo", "Feature.Stereo", "MuxedLPCMSurround51", "Feature.5.1", "MuxedLPCMSurround71", "Feature.7.1"})
    public void hasOnlyVideoSoundAndTimeTracks(@Nonnull MediaFile mediaFile, @Nonnull ValidationResultSet results) {
    }

    @PerformsValidation(value={"Codec is LPCM", "MuxedLPCMCommon", "MuxedLPCMStereoForAudioDemuxerRunner", "MuxedLPCMStereo", "Feature.Stereo", "MuxedLPCMSurround51", "Feature.5.1", "MuxedLPCMSurround71", "Feature.7.1", "Feature.5.1OrStereo.CodecIsLPCM"})
    public void codecIsLPCM(@Nonnull QtSoundTrack qtTrack, @Nonnull ValidationResultSet results) {
        if (qtTrack.codec().hasNonNullValue()) {
            String codec = qtTrack.codec().tryGet();
            if (codec != null) {
                codec = codec.trim().toLowerCase();
            }
            if (codec != null && codec.length() > 0 && !permittedStereoCodecs.contains(qtTrack.codec().get())) {
                results.addResult(MediaValidationCode.AUDIO_CODEC_INVALID, this.mediaFile.getMediaName(), MediaUtil.dictionary.add("audioCodec", qtTrack.codec().get()).add("expectedAudioCodecs", permittedStereoCodecs.toString()));
            }
        } else {
            results.addResult(MediaValidationCode.AUDIO_CODEC_MISSING, this.mediaFile.getMediaName(), MediaUtil.dictionary);
        }
    }

    @PerformsValidation(value={"Bit Depth at least 16", "MuxedLPCMCommon", "MuxedLPCMStereoForAudioDemuxerRunner", "MuxedLPCMStereo", "Feature.Stereo", "MuxedLPCMSurround51", "Feature.5.1", "MuxedLPCMSurround71", "Feature.7.1"})
    public void bitDepthAtLeast16(@Nonnull QtSoundTrack qtTrack, @Nonnull ValidationResultSet results) {
        if (qtTrack.bitDepth().hasNonNullValue() && qtTrack.bitDepth().get().longValue() < 16L) {
            results.addResult(MediaValidationCode.AUDIO_BITDEPTH_TOOSMALL, this.mediaFile.getMediaName(), MediaUtil.dictionary.add("bitDepth", qtTrack.bitDepth().toString()).add("minBitDepth", "16"));
        }
    }

    @PerformsValidation(value={"All sound tracks are enabled", "MuxedLPCMCommon", "MuxedLPCMStereoForAudioDemuxerRunner", "MuxedLPCMStereo", "Feature.Stereo", "MuxedLPCMSurround51", "Feature.5.1", "MuxedLPCMSurround71", "Feature.7.1"})
    public void allSoundTracksEnabled(@Nonnull QtSoundTrack track, @Nonnull ValidationResultSet results) {
        if (!track.isTrackEnabled()) {
            results.addResult(MediaValidationCode.AUDIO_NOT_ENABLED, this.mediaFile.getMediaName(), MediaUtil.dictionary);
        }
    }

    @PerformsValidation(value={"valid channel labels", "MuxedLPCMSurround51", "Feature.5.1"})
    public void validChannelLabels(@Nonnull QtSoundTrack track, @Nonnull ValidationResultSet results) {
        for (MediaAudioChannel ch : track.channels()) {
            if (AudioFeatureExtractor.stereoVariants.contains((Object)ch) || AudioFeatureExtractor.surround51Channels.contains((Object)ch)) continue;
            results.addResult(MediaValidationCode.AUDIO_CHMAP_INVALID, this.mediaFile.getMediaName(), MediaUtil.dictionary.add("channelMap", track.channels().toString()));
        }
    }

    @PerformsValidation(value={"valid channel labels_71", "MuxedLPCMSurround71", "Feature.7.1"})
    public void validChannelLabels71(@Nonnull QtSoundTrack track, @Nonnull ValidationResultSet results) {
        for (MediaAudioChannel ch : track.channels()) {
            if (AudioFeatureExtractor.stereoVariants.contains((Object)ch) || AudioFeatureExtractor.surround71Channels.contains((Object)ch)) continue;
            results.addResult(MediaValidationCode.AUDIO_CHMAP_INVALID, this.mediaFile.getMediaName(), MediaUtil.dictionary.add("channelMap", track.channels().toString()));
        }
    }

    @PerformsValidation(value={"Surround51", "MuxedLPCMSurround51", "Feature.5.1"})
    public void surround51(@Nonnull QuickTimeMediaFile mediaFile, @Nonnull ValidationResultSet results) {
        if (this.audioFeatureExtractor.detectedFormats().contains((Object)AudioFormat.surround_5_1)) {
            return;
        }
        List<QtSoundTrack> soundTracks = mediaFile.getTracks(QtSoundTrack.class, new MediaTrackCriteria[0]);
        if (soundTracks.size() >= 1 && MediaUtil.sameContents(AudioFeatureExtractor.surround51Channels, soundTracks.get(0).channels())) {
            return;
        }
        if (soundTracks.size() >= 2 && MediaUtil.sameContents(AudioFeatureExtractor.surround51Channels, soundTracks.get(1).channels())) {
            return;
        }
        results.addResult(MediaValidationCode.AUDIO_MISSING, mediaFile.getMediaName(), MediaUtil.dictionary);
    }

    @PerformsValidation(value={"Surround71", "MuxedLPCMSurround71", "Feature.7.1"})
    public void surround71(@Nonnull QuickTimeMediaFile mediaFile, @Nonnull ValidationResultSet results) {
        if (!this.audioFeatureExtractor.detectedFormats().contains((Object)AudioFormat.surround_7_1)) {
            results.addResult(MediaValidationCode.AUDIO_MISSING, mediaFile.getMediaName(), MediaUtil.dictionary);
        }
    }
}

