/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.validator;

import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.notification.MediaNotificationCode;
import com.apple.jingle.leghorn.media.validator.MediaValidationException;
import com.apple.jingle.leghorn.media.validator.SimpleDictionary;
import com.apple.jingle.leghorn.media.validator.ValidationLevel;
import com.apple.jingle.leghorn.media.validator.ValidationLevelCalculator;
import com.apple.jingle.leghorn.media.validator.ValidationResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public class ValidationResultSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(ValidationResultSet.class);
    @Nonnull
    private final Set<ValidationResult> validations = new LinkedHashSet<ValidationResult>();
    @Nonnull
    private final ValidationLevelCalculator levelCalc;

    public ValidationResultSet() {
        this(ValidationLevelCalculator.Common.defaultImplementation);
    }

    public ValidationResultSet(@Nonnull ValidationLevelCalculator levelCalc) {
        this.levelCalc = levelCalc;
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.validations;
    }

    public void assertSuccess() throws MediaValidationException {
        if (this.hasValidations(ValidationLevel.ERROR)) {
            List<ValidationResult> failures = this.getValidations(ValidationLevel.ERROR);
            throw new MediaValidationException(failures);
        }
    }

    @Nonnull
    public Collection<ValidationResult> getValidations() {
        return Collections.unmodifiableSet(this.validations);
    }

    public boolean hasValidations(ValidationLevel minLevel) {
        for (ValidationResult v : this.validations) {
            if (!v.getValidationLevel().asSevereAs(minLevel)) continue;
            return true;
        }
        return false;
    }

    public boolean hasValidations(MediaNotificationCode<?> ... codes) {
        for (ValidationResult v : this.validations) {
            for (MediaNotificationCode<?> code : codes) {
                if (!code.equals(v.getMediaNotificationCode())) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnegative
    public int countValidations(ValidationLevel minLevel) {
        int count = 0;
        for (ValidationResult v : this.validations) {
            if (!v.getValidationLevel().asSevereAs(minLevel)) continue;
            ++count;
        }
        return count;
    }

    @Nonnull
    public List<ValidationResult> getValidations(ValidationLevel minLevel) {
        ArrayList<ValidationResult> found = new ArrayList<ValidationResult>(this.validations.size());
        for (ValidationResult v : this.validations) {
            if (!v.getValidationLevel().asSevereAs(minLevel)) continue;
            found.add(v);
        }
        return found;
    }

    @Nonnull
    public List<ValidationResult> getValidations(MediaValidationCode ... codes) {
        ArrayList<ValidationResult> found = new ArrayList<ValidationResult>(this.validations.size());
        for (ValidationResult v : this.validations) {
            for (MediaValidationCode code : codes) {
                if (!code.equals(v.getMediaNotificationCode())) continue;
                found.add(v);
            }
        }
        return found;
    }

    public void addAll(@Nonnull ValidationResultSet results) {
        for (ValidationResult v : results.validations) {
            if (null == v) continue;
            this.addResult(v);
        }
    }

    @Nonnull
    public ValidationResult addResult(@Nonnull ValidationResult validation) {
        assert (null != validation);
        if (!this.validations.contains(validation)) {
            this.validations.add(validation);
            String logMessage = "[" + validation.getValidationCode() + "]@" + validation.getValidatedResourceId() + ": " + validation.getValidationMessage();
            int level = validation.getValidationLevel().ordinal();
            if (level != Level.OFF.intValue()) {
                if (level >= Level.INFO.intValue()) {
                    log.info((Object)logMessage);
                } else {
                    log.debug((Object)logMessage);
                }
            }
        }
        return validation;
    }

    @Nonnull
    public final ValidationResult addResult(@Nonnull MediaValidationCode code, @Nonnull ValidationLevel defaultLevel, @Nonnull String assetId, @Nonnull SimpleDictionary properties) {
        return this.addResult(new ValidationResult(this.levelCalc.calcLevel(code, defaultLevel, assetId), code, assetId, properties));
    }

    @Nonnull
    public final ValidationResult addResult(@Nonnull MediaValidationCode code, @Nonnull String assetId, @Nonnull SimpleDictionary properties) {
        return this.addResult(new ValidationResult(this.levelCalc.calcLevel(code, code.getDefaultLevel(), assetId), code, assetId, properties));
    }
}

