/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.validator;

import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.notification.MediaNotification;
import com.apple.jingle.leghorn.media.validator.SimpleDictionary;
import com.apple.jingle.leghorn.media.validator.ValidationLevel;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ValidationResult
implements MediaNotification<ValidationLevel, MediaValidationCode>,
Serializable {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private final ValidationLevel level;
    @Nonnull
    private final MediaValidationCode errorCode;
    @Nonnull
    private final String resourceId;
    @Nonnull
    private final SimpleDictionary properties;
    @Nonnull
    private final String defaultMessageTemplate;
    @Nullable
    private final String providerMessageTemplate;

    public ValidationResult(@Nonnull ValidationLevel level, @Nonnull MediaValidationCode errorCode, @Nonnull String resourceId, @Nonnull SimpleDictionary properties) {
        this.level = level;
        this.errorCode = errorCode;
        this.resourceId = resourceId;
        this.properties = properties.readOnlyCopy();
        this.defaultMessageTemplate = this.errorCode.getDefaultMessageTemplate();
        this.providerMessageTemplate = this.errorCode.getProviderMessageTemplate();
    }

    public ValidationResult(@Nonnull ValidationLevel level, @Nonnull MediaValidationCode errorCode, @Nonnull String resourceId, @Nonnull String defaultMessageTemplate, @Nonnull SimpleDictionary properties) {
        this.level = level;
        this.errorCode = errorCode;
        this.resourceId = resourceId;
        this.properties = properties.readOnlyCopy();
        this.defaultMessageTemplate = defaultMessageTemplate;
        this.providerMessageTemplate = null;
    }

    public int hashCode() {
        return this.level.hashCode() * 13 + this.errorCode.hashCode() + this.resourceId.hashCode() * 3;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ValidationResult) {
            ValidationResult comp = (ValidationResult)obj;
            return this.level.equals(comp.level) && this.errorCode.equals(comp.errorCode) && this.resourceId.equals(comp.resourceId);
        }
        return false;
    }

    @Nonnull
    public MediaValidationCode getRegisteredValidationCode() {
        return this.errorCode;
    }

    @Override
    @Nonnull
    public MediaValidationCode getMediaNotificationCode() {
        return this.errorCode;
    }

    @Nonnull
    public String toString() {
        return this.getValidationCode();
    }

    @Nonnull
    public String getValidatedResourceId() {
        return this.resourceId;
    }

    @Override
    @Nonnull
    public String getMediaName() {
        return this.resourceId;
    }

    @Nonnull
    public ValidationLevel getValidationLevel() {
        return this.level;
    }

    @Override
    @Nonnull
    public ValidationLevel getMediaNotificationLevel() {
        return this.level;
    }

    @Nonnull
    private String expandTokensInTemplate(@Nonnull String messageTemplateToUse) {
        try {
            int endNextToken;
            int startNextToken;
            StringBuilder sb = new StringBuilder();
            int cursor = 0;
            while ((startNextToken = messageTemplateToUse.indexOf("${", cursor)) != -1 && (endNextToken = messageTemplateToUse.indexOf(125, startNextToken + 2)) != -1) {
                if (startNextToken > cursor) {
                    sb.append(messageTemplateToUse.substring(cursor, startNextToken));
                }
                cursor = endNextToken + 1;
                String key = messageTemplateToUse.substring(startNextToken + 2, endNextToken);
                if (this.properties.containsKey(key)) {
                    String value = this.properties.get(key);
                    if (null == value) continue;
                    sb.append(value);
                    continue;
                }
                throw new IllegalStateException("Unexpected parameter: '" + key + "'");
            }
            if (cursor < messageTemplateToUse.length()) {
                sb.append(messageTemplateToUse.substring(cursor));
            }
            if (sb.indexOf("%") != -1) {
                return String.format(sb.toString(), this.properties.getValues().toArray());
            }
            return sb.toString();
        }
        catch (Exception e) {
            String alternateMessage = this.properties.get("message");
            if (null != alternateMessage) {
                return alternateMessage;
            }
            return this.errorCode.getDefaultMessage() + this.properties;
        }
    }

    @Override
    @Nonnull
    public String getDefaultMessage() {
        return this.expandTokensInTemplate(this.defaultMessageTemplate);
    }

    @Nullable
    public String getProviderMessage() {
        return null != this.providerMessageTemplate ? this.expandTokensInTemplate(this.providerMessageTemplate) : null;
    }

    @Nonnull
    public String getValidationCode() {
        return this.errorCode.getValidationCode();
    }

    @Nonnull
    public String getValidationMessage() {
        return this.getDefaultMessage();
    }

    @Override
    @Nonnull
    public SimpleDictionary getMediaNotificationParameterMap() {
        return this.properties;
    }
}

