/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.validator;

import com.apple.jingle.leghorn.media.notification.MediaNotificationLevel;
import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ValidationLevel implements MediaNotificationLevel<ValidationLevel>,
Serializable
{
    FATAL(Level.INFO),
    ERROR(Level.INFO),
    WARNING(Level.INFO),
    INFO(Level.INFO),
    GRANDFATHERED(Level.INFO),
    DISABLED(Level.INFO),
    SHADOW(Level.INFO),
    DEBUG(Level.FINE),
    NONE(Level.OFF);

    @Nonnull
    private final Level loggingLevel;
    @Nonnull
    private static final Map<String, ValidationLevel> lookupMap;

    private ValidationLevel(Level loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    @Nonnull
    public Level getLoggingLevel() {
        return this.loggingLevel;
    }

    @Nonnull
    private static Map<String, ValidationLevel> createLookupMap() {
        TreeMap<String, ValidationLevel> lookupMap = new TreeMap<String, ValidationLevel>(String.CASE_INSENSITIVE_ORDER);
        for (ValidationLevel value : ValidationLevel.values()) {
            lookupMap.put(value.name(), value);
        }
        lookupMap.put("off", NONE);
        lookupMap.put("false", NONE);
        lookupMap.put("warn", WARNING);
        lookupMap.put("fail", ERROR);
        return lookupMap;
    }

    public final boolean asSevereAs(@Nonnull ValidationLevel level) {
        return this.compareTo(level) <= 0;
    }

    public static final ValidationLevel valueOfString(@Nullable String levelName) {
        if (null != levelName) {
            return lookupMap.get(levelName);
        }
        return null;
    }

    @Nonnull
    public static final ValidationLevel valueOfString(@Nullable String levelName, @Nonnull ValidationLevel defaultValue) {
        ValidationLevel level = ValidationLevel.valueOfString(levelName);
        if (null != level) {
            return level;
        }
        return defaultValue;
    }

    static {
        lookupMap = ValidationLevel.createLookupMap();
    }
}

