/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.validator;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface SimpleDictionary
extends Cloneable {
    @Nullable
    public String get(@Nonnull String var1);

    public boolean containsKey(@Nonnull String var1);

    public int size();

    @Nonnull
    public Collection<String> getValues();

    @Nonnull
    public SimpleDictionary readOnlyCopy();

    @Nonnull
    public Set<Map.Entry<String, String>> entrySet();

    @Nonnull
    public <M extends Map<String, String>> M toMap(@Nonnull M var1);

    @Nonnull
    public SimpleDictionary add(@Nonnull String var1, @Nullable String var2);

    public static class ImmutablePropertyMapImpl
    implements SimpleDictionary {
        @Nonnull
        private final Map<String, String> map;

        private ImmutablePropertyMapImpl(Map<String, String> map) {
            this.map = Collections.unmodifiableMap(new LinkedHashMap<String, String>(map));
        }

        @Override
        public SimpleDictionary add(String key, String value) {
            return new MutablePropertyMapImpl(this.map).add(key, value);
        }

        @Override
        public String get(String key) {
            return this.map.get(key);
        }

        @Override
        public boolean containsKey(String key) {
            return this.map.containsKey(key);
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return this.map.entrySet();
        }

        @Override
        public Collection<String> getValues() {
            return Collections.unmodifiableCollection(this.map.values());
        }

        public String toString() {
            return this.map.toString();
        }

        @Override
        public SimpleDictionary readOnlyCopy() {
            return this;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public <M extends Map<String, String>> M toMap(@Nonnull M map) {
            map.putAll(this.map);
            return map;
        }
    }

    public static class MutablePropertyMapImpl
    implements SimpleDictionary {
        @Nonnull
        private final LinkedHashMap<String, String> map;

        private MutablePropertyMapImpl() {
            this.map = new LinkedHashMap();
        }

        private MutablePropertyMapImpl(Map<String, String> map) {
            this.map = new LinkedHashMap<String, String>(map);
        }

        @Override
        public MutablePropertyMapImpl add(@Nonnull String key, @Nullable String value) {
            this.map.put(key, value);
            return this;
        }

        @Override
        public String get(String key) {
            return this.map.get(key);
        }

        @Override
        public boolean containsKey(String key) {
            return this.map.containsKey(key);
        }

        @Override
        public Collection<String> getValues() {
            return Collections.unmodifiableCollection(this.map.values());
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return Collections.unmodifiableMap(this.map).entrySet();
        }

        public String toString() {
            return this.map.toString();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public SimpleDictionary readOnlyCopy() {
            return new ImmutablePropertyMapImpl(this.map);
        }

        @Override
        public <M extends Map<String, String>> M toMap(@Nonnull M map) {
            map.putAll(this.map);
            return map;
        }
    }

    public static class EmptyMap
    implements SimpleDictionary {
        public static final EmptyMap singleton = new EmptyMap();

        private EmptyMap() {
        }

        @Override
        public SimpleDictionary add(String key, String value) {
            return new MutablePropertyMapImpl().add(key, value);
        }

        @Override
        public String get(String key) {
            return null;
        }

        @Override
        public boolean containsKey(String key) {
            return false;
        }

        @Override
        public Collection<String> getValues() {
            return Collections.emptyList();
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return Collections.emptySet();
        }

        public String toString() {
            return "[]";
        }

        @Override
        public EmptyMap readOnlyCopy() {
            return this;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public <M extends Map<String, String>> M toMap(@Nonnull M map) {
            return map;
        }
    }
}

