/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.notification;

import com.apple.jingle.leghorn.media.MediaDescriptionResult;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.validator.SimpleDictionary;
import com.apple.jingle.leghorn.media.validator.ValidationLevel;
import com.apple.jingle.leghorn.media.validator.ValidationResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MediaNotificationUtil {
    public static Collection<ValidationResult> getNotifications(Document XMLDescription) {
        ArrayList<ValidationResult> list = new ArrayList<ValidationResult>();
        if (XMLDescription == null) {
            return list;
        }
        Node notificationsNode = MediaNotificationUtil.getFirstNodeByTagName(XMLDescription, "notifications");
        if (notificationsNode == null) {
            return list;
        }
        for (Element notificationElement : MediaNotificationUtil.getChildElements(notificationsNode)) {
            String validationLevel = notificationElement.getAttribute("level");
            String validationCode = notificationElement.getAttribute("code");
            SimpleDictionary sd = MediaUtil.dictionary;
            for (Element entry : MediaNotificationUtil.getChildElements(MediaNotificationUtil.getFirstElementByTagName(notificationElement, "parameters"))) {
                if (!entry.getTagName().contains("entry")) continue;
                sd = sd.add(entry.getAttribute("key"), entry.getTextContent());
            }
            ValidationResult vr = new ValidationResult(ValidationLevel.valueOfString(validationLevel, ValidationLevel.NONE), MediaValidationCode.valueOfStringCode(validationCode, MediaValidationCode.FILE_FAILS_CONFORMANCE_CHECK), "", sd);
            list.add(vr);
        }
        return list;
    }

    public static Collection<ValidationResult> getNotifications(Document XMLDescription, ValidationLevel validationLevel) {
        ArrayList<ValidationResult> list = new ArrayList<ValidationResult>();
        for (ValidationResult n : MediaNotificationUtil.getNotifications(XMLDescription)) {
            if (!n.getValidationLevel().asSevereAs(validationLevel)) continue;
            list.add(n);
        }
        return list;
    }

    public static MediaDescriptionResult.Exception notificationToException(ValidationResult notification) {
        String message = notification.getMediaNotificationParameterMap().get("message");
        if (message == null) {
            message = notification.getMediaNotificationParameterMap().get("errorMessage");
        }
        if (message == null) {
            message = "Default Notification Message";
        }
        return new MediaDescriptionResult.Exception(message, "Not Applicable - See message", 0);
    }

    public static Collection<MediaDescriptionResult.Exception> notificationToException(Collection<ValidationResult> notifications) {
        ArrayList<MediaDescriptionResult.Exception> list = new ArrayList<MediaDescriptionResult.Exception>();
        for (ValidationResult n : notifications) {
            list.add(MediaNotificationUtil.notificationToException(n));
        }
        return list;
    }

    public static Node getFirstNodeByTagName(Document d, String nameSpace, String tagName) {
        if (d == null) {
            return null;
        }
        return d.getElementsByTagNameNS(nameSpace, tagName).item(0);
    }

    public static Node getFirstNodeByTagName(Document d, String tagName) {
        return MediaNotificationUtil.getFirstNodeByTagName(d, "*", tagName);
    }

    public static Node getFirstNodeByTagName(Element e, String nameSpace, String tagName) {
        if (e == null) {
            return null;
        }
        return e.getElementsByTagNameNS(nameSpace, tagName).item(0);
    }

    public static Node getFirstNodeByTagName(Element e, String tagName) {
        return MediaNotificationUtil.getFirstNodeByTagName(e, "*", tagName);
    }

    public static Element getFirstElementByTagName(Element e, String nameSpace, String tagName) {
        Node n = MediaNotificationUtil.getFirstNodeByTagName(e, nameSpace, tagName);
        if (n instanceof Element) {
            return (Element)n;
        }
        return null;
    }

    public static Element getFirstElementByTagName(Element e, String tagName) {
        return MediaNotificationUtil.getFirstElementByTagName(e, "*", tagName);
    }

    public static List<Node> getChildNodes(Node n) {
        NodeList childNodes = n.getChildNodes();
        ArrayList<Node> childNodeList = new ArrayList<Node>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            childNodeList.add(childNodes.item(i));
        }
        return childNodeList;
    }

    public static List<Element> getChildElements(Node n) {
        ArrayList<Element> childElements = new ArrayList<Element>();
        for (Node child : MediaNotificationUtil.getChildNodes(n)) {
            if (!(child instanceof Element)) continue;
            childElements.add((Element)child);
        }
        return childElements;
    }
}

