/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.index;

import com.apple.jingle.leghorn.media.index.IndexedMap;
import com.apple.jingle.leghorn.media.index.IndexedMapFilter;
import com.apple.jingle.leghorn.media.index.ValueSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ValueSetFilter<I> {
    public boolean meetsCriteria(@Nonnull I var1);

    public static final class OrSet<I>
    extends ValueSetFilterBase<I> {
        @Nullable
        private final Collection<? extends ValueSetFilter<? super I>> criteriaSet;

        @SafeVarargs
        public OrSet(ValueSetFilter<? super I> ... criteria) {
            this.criteriaSet = Arrays.asList(criteria);
        }

        public String toString() {
            return "or" + this.criteriaSet;
        }

        @Override
        public boolean meetsCriteria(@Nonnull I value) {
            if (this.criteriaSet.isEmpty()) {
                return true;
            }
            for (ValueSetFilter<I> c : this.criteriaSet) {
                if (c == null || !c.meetsCriteria(value)) continue;
                return true;
            }
            return false;
        }
    }

    public static final class AndSet<I>
    extends ValueSetFilterBase<I> {
        @Nullable
        private final Collection<? extends ValueSetFilter<? super I>> criteriaSet;

        @SafeVarargs
        public AndSet(ValueSetFilter<? super I> ... criteria) {
            this.criteriaSet = Arrays.asList(criteria);
        }

        public String toString() {
            return "and[" + this.criteriaSet;
        }

        @Override
        public boolean meetsCriteria(@Nonnull I value) {
            for (ValueSetFilter<I> c : this.criteriaSet) {
                if (c == null || c.meetsCriteria(value)) continue;
                return false;
            }
            return true;
        }
    }

    public static final class Not<I>
    extends ValueSetFilterBase<I> {
        @Nullable
        private final ValueSetFilter<I> criteria;

        public Not(ValueSetFilter<I> criteria) {
            this.criteria = criteria;
        }

        public String toString() {
            return "!" + this.criteria;
        }

        @Override
        public boolean meetsCriteria(@Nonnull I value) {
            return !this.criteria.meetsCriteria(value);
        }
    }

    public static abstract class ValueSetFilterBase<I>
    implements ValueSetFilter<I>,
    IndexedMapFilter<I> {
        @Override
        public final void filter(@Nonnull IndexedMap<? extends I> indexedMap, @Nonnull ValueSet<? extends I> values) {
            Iterator valueIterator = values.iterator();
            while (valueIterator.hasNext()) {
                if (this.meetsCriteria(valueIterator.next())) continue;
                valueIterator.remove();
            }
        }
    }
}

