/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.index;

import com.apple.jingle.leghorn.media.index.ValueSetFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ValueSet<I>
extends TreeSet<I>
implements Cloneable {
    private static final long serialVersionUID = 1L;

    public ValueSet() {
    }

    public ValueSet(@Nonnull Collection<? extends I> c) {
        super(c);
    }

    public ValueSet(@Nullable Comparator<? super I> comparator) {
        super(comparator);
    }

    public ValueSet(@Nullable Comparator<? super I> comparator, @Nonnull Collection<? extends I> c) {
        super(comparator);
        this.addAll(c);
    }

    public ValueSet(@Nonnull SortedSet<I> s) {
        super(s);
    }

    @Override
    public ValueSet<I> clone() {
        return (ValueSet)super.clone();
    }

    @Override
    public boolean addAll(@Nullable Collection<? extends I> values) {
        if (values != null) {
            return super.addAll(values);
        }
        return false;
    }

    private static final <I> boolean keepValue(@Nonnull I value, @Nonnull Collection<ValueSetFilter<? super I>> filters) {
        for (ValueSetFilter<I> filter : filters) {
            if (filter == null || filter.meetsCriteria(value)) continue;
            return false;
        }
        return true;
    }

    @SafeVarargs
    @Nonnull
    private static final <I> Collection<ValueSetFilter<? super I>> toCollection(ValueSetFilter<? super I> ... filters) {
        if (filters != null && filters.length != 0) {
            return Arrays.asList(filters);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> values) {
        if (values == null) {
            if (!this.isEmpty()) {
                this.clear();
                return true;
            }
            return false;
        }
        return super.retainAll(values);
    }

    public <S extends I> ValueSet<S> applyFilters(@Nonnull Class<S> type, @Nonnull Collection<ValueSetFilter<? super S>> filters) {
        Iterator valueIterator = this.iterator();
        while (valueIterator.hasNext()) {
            S typedValue;
            boolean keepValue = false;
            Object value = valueIterator.next();
            if (type.isInstance(value) && ValueSet.keepValue(typedValue = type.cast(value), filters)) {
                keepValue = true;
            }
            if (keepValue) continue;
            valueIterator.remove();
        }
        return this;
    }

    @Nonnull
    public final ValueSet<I> applyFilters(@Nonnull Collection<ValueSetFilter<? super I>> filters) {
        Iterator valueIterator = this.iterator();
        while (valueIterator.hasNext()) {
            if (ValueSet.keepValue(valueIterator.next(), filters)) continue;
            valueIterator.remove();
        }
        return this;
    }

    @Nonnull
    public final <S extends I> ValueSet<S> cast(@Nonnull Class<S> type) {
        ValueSet<S> filtered = new ValueSet<S>(this.comparator());
        for (Object value : this) {
            try {
                filtered.add(type.cast(value));
            }
            catch (ClassCastException e) {
                throw new ClassCastException("Cannot cast " + value.getClass().getName() + "[" + value + "] to " + type.getName());
            }
        }
        return filtered;
    }

    @Nonnull
    public final <S extends I> ValueSet<S> filter(@Nonnull Class<S> type) {
        ValueSet<S> filtered = new ValueSet<S>(this.comparator());
        for (Object value : this) {
            if (!type.isInstance(value)) continue;
            filtered.add(type.cast(value));
        }
        return filtered;
    }

    @Nullable
    public final I tryFirst() {
        if (!this.isEmpty()) {
            return (I)super.first();
        }
        return null;
    }

    @Override
    @Nonnull
    public final I first() {
        I first = this.tryFirst();
        if (first == null) {
            throw new NoSuchElementException();
        }
        return first;
    }

    @Nonnull
    public final I singleton() {
        if (this.size() > 1) {
            throw new NoSuchElementException("Too many values found");
        }
        return this.first();
    }

    @Nonnull
    public final <S extends I> S first(@Nonnull Class<S> type) {
        I value = this.first();
        try {
            return type.cast(value);
        }
        catch (ClassCastException e) {
            throw new ClassCastException("Cannot cast " + value.getClass().getName() + "[" + value + "] to " + type.getName());
        }
    }

    @Nullable
    public final <S extends I> S tryFirst(@Nonnull Class<S> type) {
        I value = this.tryFirst();
        if (value != null) {
            try {
                return type.cast(value);
            }
            catch (ClassCastException e) {
                throw new ClassCastException("Cannot cast " + value.getClass().getName() + "[" + value + "] to " + type.getName());
            }
        }
        return null;
    }
}

