/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.index;

import java.io.Serializable;
import java.util.Comparator;
import javax.annotation.Nonnull;

public class IndexedMapKeyType<K>
implements Comparable<IndexedMapKeyType<?>>,
Serializable {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private final String name;
    @Nonnull
    private final Class<K> keyType;
    @Nonnull
    private final Comparator<K> keyComparator;

    public IndexedMapKeyType(@Nonnull String name, @Nonnull Class<K> keyType, @Nonnull Comparator<K> keyComparator) {
        this.name = name;
        this.keyType = keyType;
        this.keyComparator = keyComparator;
    }

    @Nonnull
    public static final <J extends Comparable<J>> IndexedMapKeyType<J> of(@Nonnull String name, @Nonnull Class<J> keyType) {
        return new IndexedMapKeyType<Comparable<Object>>(name, keyType, NaturalOrderComparator.INSTANCE);
    }

    @Nonnull
    public static final <K> IndexedMapKeyType<K> of(@Nonnull String name, @Nonnull Class<K> keyType, @Nonnull Comparator<K> comparator) {
        return new IndexedMapKeyType<K>(name, keyType, comparator);
    }

    @Nonnull
    public Comparator<K> keyComparator() {
        return this.keyComparator;
    }

    @Nonnull
    public String name() {
        return this.name;
    }

    @Nonnull
    public Class<K> keyType() {
        return this.keyType;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode() * 13 + this.keyType.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IndexedMapKeyType) {
            IndexedMapKeyType comp = (IndexedMapKeyType)obj;
            return this.name.equals(comp.name) && this.keyType.equals(comp.keyType);
        }
        return false;
    }

    @Override
    public int compareTo(IndexedMapKeyType<?> o) {
        int diff = this.name.compareTo(o.name);
        if (diff == 0) {
            diff = this.keyType.getName().compareTo(o.keyType.getName());
        }
        return diff;
    }

    private static enum NaturalOrderComparator implements Comparator<Comparable<Object>>
    {
        INSTANCE;


        @Override
        public int compare(Comparable<Object> c1, Comparable<Object> c2) {
            return c1.compareTo(c2);
        }
    }
}

