/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.index;

import com.apple.jingle.leghorn.media.index.IndexedMapKey;
import com.apple.jingle.leghorn.media.index.IndexedMapKeyType;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IndexedMapKeySet
implements Iterable<IndexedMapKey<?>>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private final TreeMap<IndexedMapKeyType<?>, Set<? extends IndexedMapKey<?>>> map = new TreeMap();

    public IndexedMapKeySet() {
    }

    protected IndexedMapKeySet(@Nonnull IndexedMapKeySet clone) {
        this.map.putAll(clone.map);
    }

    @Nonnull
    public IndexedMapKeySet clone() {
        return new IndexedMapKeySet(this);
    }

    @Nonnull
    public <K extends Serializable> IndexedMapKeySet add(@Nonnull IndexedMapKey<K> key) {
        Set<IndexedMapKey<?>> keys = this.map.get(key.keyType());
        if (keys == null) {
            keys = new TreeSet();
            this.map.put(key.keyType(), keys);
        }
        keys.add(key);
        return this;
    }

    @Nonnull
    public <K extends Serializable> IndexedMapKeySet add(@Nonnull IndexedMapKeyType<K> keyType, @Nullable K keyValue) {
        return this.add(new IndexedMapKey<K>(keyType, keyValue));
    }

    public int size() {
        return this.map.size();
    }

    @Override
    public Iterator<IndexedMapKey<?>> iterator() {
        final Iterator<Set<? extends IndexedMapKey<?>>> sets = this.map.values().iterator();
        return new Iterator<IndexedMapKey<?>>(){
            private Iterator<? extends IndexedMapKey<?>> keyIterator;

            @Override
            public boolean hasNext() {
                if ((this.keyIterator == null || !this.keyIterator.hasNext()) && sets.hasNext()) {
                    this.keyIterator = ((Set)sets.next()).iterator();
                }
                return this.keyIterator != null && this.keyIterator.hasNext();
            }

            @Override
            public IndexedMapKey<?> next() {
                if (this.hasNext()) {
                    return this.keyIterator.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new IllegalStateException("Not supported");
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (IndexedMapKey<?> key : this) {
            sb.append('(').append(key.keyType().name()).append('=').append(String.valueOf(key.keyValue())).append(')');
        }
        return sb.toString();
    }
}

