/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.index;

import com.apple.jingle.leghorn.media.index.IndexedMapKeyType;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IndexedMapKey<K extends Serializable>
implements Comparable<IndexedMapKey<K>>,
Serializable {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private final IndexedMapKeyType<K> keyType;
    @Nullable
    private final K keyValue;

    public IndexedMapKey(@Nonnull IndexedMapKeyType<K> indexKeyType, @Nullable K indexKey) {
        this.keyType = indexKeyType;
        this.keyValue = indexKey;
    }

    @Nonnull
    public IndexedMapKeyType<K> keyType() {
        return this.keyType;
    }

    @Nullable
    public K keyValue() {
        return this.keyValue;
    }

    public String toString() {
        return this.keyType + "=" + this.keyValue;
    }

    public int hashCode() {
        return Objects.hash(this.keyType, this.keyValue);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IndexedMapKey) {
            IndexedMapKey comp = (IndexedMapKey)obj;
            return comp.keyType.equals(this.keyType) && Objects.equals(this.keyValue, comp.keyValue);
        }
        return false;
    }

    @Override
    public int compareTo(IndexedMapKey<K> o) {
        if (this.keyValue == o.keyValue) {
            return 0;
        }
        if (this.keyValue == null) {
            return -1;
        }
        if (o.keyValue == null) {
            return 1;
        }
        return this.keyType.keyComparator().compare(this.keyValue, o.keyValue);
    }
}

