/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.index;

import com.apple.jingle.leghorn.media.index.IndexedMap;
import com.apple.jingle.leghorn.media.index.IndexedMapKey;
import com.apple.jingle.leghorn.media.index.IndexedMapKeyType;
import com.apple.jingle.leghorn.media.index.ValueSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.NavigableSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IndexedMapFilter<I> {
    @Nonnull
    public void filter(@Nonnull IndexedMap<? extends I> var1, ValueSet<? extends I> var2);

    public static class KeyGreaterThanOrEqualsCriteria<K extends Serializable, I>
    implements IndexedMapFilter<I> {
        @Nonnull
        private final IndexedMapKeyType<K> keyType;
        @Nonnull
        private final IndexedMapKey<K> keyValue;

        public KeyGreaterThanOrEqualsCriteria(@Nonnull IndexedMapKeyType<K> keyType, @Nonnull K keyValue) {
            this.keyType = keyType;
            this.keyValue = new IndexedMapKey<K>(keyType, keyValue);
        }

        public String toString() {
            return this.keyType + ">='" + this.keyValue + "'";
        }

        @Override
        @Nonnull
        public void filter(@Nonnull IndexedMap<? extends I> indexedMap, ValueSet<? extends I> values) {
            NavigableSet<IndexedMapKey<K>> foundKeys = indexedMap.keysByType(this.keyType).tailSet(this.keyValue, true);
            values.retainAll(indexedMap.getValuesForKeys(foundKeys));
        }
    }

    public static class KeyGreaterThanCriteria<K extends Serializable, I>
    implements IndexedMapFilter<I> {
        @Nonnull
        private final IndexedMapKeyType<K> keyType;
        @Nonnull
        private final IndexedMapKey<K> keyValue;

        public KeyGreaterThanCriteria(@Nonnull IndexedMapKeyType<K> keyType, @Nonnull K keyValue) {
            this.keyType = keyType;
            this.keyValue = new IndexedMapKey<K>(keyType, keyValue);
        }

        public String toString() {
            return this.keyType + ">'" + this.keyValue + "'";
        }

        @Override
        @Nonnull
        public void filter(@Nonnull IndexedMap<? extends I> indexedMap, ValueSet<? extends I> values) {
            NavigableSet<IndexedMapKey<K>> foundKeys = indexedMap.keysByType(this.keyType).tailSet(this.keyValue, false);
            values.retainAll(indexedMap.getValuesForKeys(foundKeys));
        }
    }

    public static class KeyLessThanOrEqualsCriteria<K extends Serializable, I>
    implements IndexedMapFilter<I> {
        @Nonnull
        private final IndexedMapKeyType<K> keyType;
        @Nonnull
        private final IndexedMapKey<K> keyValue;

        public KeyLessThanOrEqualsCriteria(@Nonnull IndexedMapKeyType<K> keyType, @Nonnull K keyValue) {
            this.keyType = keyType;
            this.keyValue = new IndexedMapKey<K>(keyType, keyValue);
        }

        public String toString() {
            return this.keyType + "<='" + this.keyValue + "'";
        }

        @Override
        @Nonnull
        public void filter(@Nonnull IndexedMap<? extends I> indexedMap, ValueSet<? extends I> values) {
            NavigableSet<IndexedMapKey<K>> foundKeys = indexedMap.keysByType(this.keyType).headSet(this.keyValue, true);
            values.retainAll(indexedMap.getValuesForKeys(foundKeys));
        }
    }

    public static class KeyLessThanCriteria<K extends Serializable, I>
    implements IndexedMapFilter<I> {
        @Nonnull
        private final IndexedMapKeyType<K> keyType;
        @Nonnull
        private final IndexedMapKey<K> keyValue;

        public KeyLessThanCriteria(@Nonnull IndexedMapKeyType<K> keyType, @Nonnull K keyValue) {
            this.keyType = keyType;
            this.keyValue = new IndexedMapKey<K>(keyType, keyValue);
        }

        public String toString() {
            return this.keyType + "<'" + this.keyValue + "'";
        }

        @Override
        @Nonnull
        public void filter(@Nonnull IndexedMap<? extends I> indexedMap, ValueSet<? extends I> values) {
            NavigableSet<IndexedMapKey<K>> foundKeys = indexedMap.keysByType(this.keyType).headSet(this.keyValue, false);
            values.retainAll(indexedMap.getValuesForKeys(foundKeys));
        }
    }

    public static class KeyEqualsCriteria<K extends Serializable, I>
    implements IndexedMapFilter<I> {
        @Nonnull
        private final IndexedMapKeyType<K> keyType;
        @Nonnull
        private final IndexedMapKey<K> keyValue;

        public KeyEqualsCriteria(IndexedMapKeyType<K> keyType, K keyValue) {
            this.keyType = keyType;
            this.keyValue = new IndexedMapKey<K>(keyType, keyValue);
        }

        public String toString() {
            return this.keyType + "='" + this.keyValue + "'";
        }

        @Override
        @Nonnull
        public void filter(@Nonnull IndexedMap<? extends I> indexedMap, ValueSet<? extends I> values) {
            values.retainAll(indexedMap.getValuesForKey(this.keyValue));
        }
    }

    public static class KeyInCriteria<K extends Serializable, I>
    implements IndexedMapFilter<I> {
        @Nonnull
        private final IndexedMapKeyType<K> keyType;
        @Nonnull
        private final TreeSet<IndexedMapKey<K>> keyValue;

        public KeyInCriteria(@Nonnull IndexedMapKeyType<K> keyType, @Nonnull Collection<? extends K> keyValues) {
            this.keyType = keyType;
            this.keyValue = new TreeSet();
            for (Serializable key : keyValues) {
                this.keyValue.add(new IndexedMapKey<Serializable>(keyType, key));
            }
        }

        public boolean contains(@Nullable IndexedMapKey<K> key) {
            return this.keyValue.contains(key);
        }

        @SafeVarargs
        public KeyInCriteria(@Nonnull IndexedMapKeyType<K> keyType, K ... keyValues) {
            this.keyType = keyType;
            this.keyValue = new TreeSet();
            for (K key : keyValues) {
                this.keyValue.add(new IndexedMapKey<K>(keyType, key));
            }
        }

        public String toString() {
            return this.keyType + " in " + this.keyValue;
        }

        @Override
        @Nonnull
        public void filter(@Nonnull IndexedMap<? extends I> indexedMap, ValueSet<? extends I> values) {
            values.retainAll(indexedMap.getValuesForKeys(this.keyValue));
        }
    }

    public static class HasKeyCriteria<K extends Serializable, I>
    implements IndexedMapFilter<I> {
        @Nonnull
        private final IndexedMapKeyType<K> keyType;

        public HasKeyCriteria(IndexedMapKeyType<K> keyType) {
            this.keyType = keyType;
        }

        public String toString() {
            return this.keyType + " exists";
        }

        @Override
        @Nonnull
        public void filter(@Nonnull IndexedMap<? extends I> indexedMap, ValueSet<? extends I> values) {
            if (indexedMap.keysByType(this.keyType) == null) {
                values.clear();
            }
        }
    }
}

