/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.index;

import com.apple.jingle.leghorn.media.index.IndexedMapFilter;
import com.apple.jingle.leghorn.media.index.IndexedMapKey;
import com.apple.jingle.leghorn.media.index.IndexedMapKeySet;
import com.apple.jingle.leghorn.media.index.IndexedMapKeyType;
import com.apple.jingle.leghorn.media.index.ValueSet;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IndexedMap<I>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<I, IndexedMapKeySet> allValues = new HashMap<I, IndexedMapKeySet>();
    private final Map<IndexedMapKeyType<?>, KeyValuesMap<?>> keyValueMapMap = new HashMap();
    @Nonnull
    static IndexedMapKeyType<String> nameIdx = IndexedMapKeyType.of("name", String.class);
    @Nonnull
    static IndexedMapKeyType<Integer> valueIdx = IndexedMapKeyType.of("value", Integer.class);
    @Nonnull
    static IndexedMapKeyType<Boolean> oddIdx = IndexedMapKeyType.of("odd", Boolean.class);
    @Nonnull
    static IndexedMapKeyType<Boolean> evenIdx = IndexedMapKeyType.of("even", Boolean.class);
    @Nonnull
    static IndexedMapKeyType<Boolean> number = IndexedMapKeyType.of("isNumber", Boolean.class);

    public IndexedMap() {
    }

    private IndexedMap(@Nonnull IndexedMap<I> clone) {
        for (Map.Entry<I, IndexedMapKeySet> entry : clone.allValues.entrySet()) {
            this.allValues.put(entry.getKey(), entry.getValue().clone());
        }
        for (Map.Entry<Object, Cloneable> entry : clone.keyValueMapMap.entrySet()) {
            this.keyValueMapMap.put((IndexedMapKeyType<?>)entry.getKey(), (KeyValuesMap<?>)((KeyValuesMap)entry.getValue()).clone());
        }
    }

    @Nonnull
    public IndexedMap<I> clone() {
        return new IndexedMap<I>(this);
    }

    private void handleAdd(I value, @Nonnull IndexedMapKey<?> key) {
        IndexedMapKeySet indexKeySet = this.allValues.get(value);
        if (indexKeySet == null) {
            indexKeySet = new IndexedMapKeySet();
            this.allValues.put(value, indexKeySet);
        }
        indexKeySet.add(key);
    }

    public boolean remove(@Nonnull I value) {
        IndexedMapKeySet indexKeySet = this.allValues.remove(value);
        if (indexKeySet != null) {
            for (IndexedMapKey<?> key : indexKeySet) {
                KeyValuesMap.KeyValues keyValues;
                KeyValuesMap<?> keyValuesMap = this.getKeyValuesMap(key.keyType());
                if (keyValuesMap == null || (keyValues = (KeyValuesMap.KeyValues)((KeyValuesMap)keyValuesMap).map.get(key)) == null) continue;
                keyValues.values.remove(value);
            }
            return true;
        }
        return false;
    }

    @Nullable
    private <K extends Serializable> KeyValuesMap<K> getKeyValuesMap(@Nonnull IndexedMapKeyType<K> keyType) {
        return this.keyValueMapMap.get(keyType);
    }

    @Nonnull
    public <K extends Serializable> NavigableSet<IndexedMapKey<K>> keysByType(@Nonnull IndexedMapKeyType<K> keyType) {
        KeyValuesMap<K> map = this.getKeyValuesMap(keyType);
        if (map != null) {
            return ((KeyValuesMap)map).map.navigableKeySet();
        }
        return new ValueSet<IndexedMapKey<K>>();
    }

    @Nonnull
    public Set<I> getValuesForKeys(@Nonnull Collection<? extends IndexedMapKey<?>> keys) {
        ValueSet<I> values = new ValueSet<I>();
        for (IndexedMapKey<?> key : keys) {
            values.addAll((Collection<I>)this.getValuesForKey(key));
        }
        return Collections.unmodifiableSet(values);
    }

    @Nonnull
    public <K extends Serializable> Set<I> getValuesForKey(@Nullable IndexedMapKey<K> key) {
        KeyValuesMap.KeyValues keyValues;
        KeyValuesMap<K> keyValuesMap;
        if (key != null && (keyValuesMap = this.getKeyValuesMap(key.keyType())) != null && (keyValues = ((KeyValuesMap)keyValuesMap).getKeyValues(key)) != null) {
            return Collections.unmodifiableSet(keyValues.values);
        }
        return Collections.emptySet();
    }

    private <K extends Serializable> void addAll(@Nonnull KeyValuesMap<K> other) {
        this.getOrCreateKeyValuesMap(((KeyValuesMap)other).keyType).addAll(other);
    }

    public void addAll(@Nonnull IndexedMap<I> other) {
        for (KeyValuesMap<?> keyValuesMap : other.keyValueMapMap.values()) {
            this.addAll(keyValuesMap);
        }
    }

    @Nonnull
    private <K extends Serializable> KeyValuesMap<K> getOrCreateKeyValuesMap(@Nonnull IndexedMapKeyType<K> keyType) {
        KeyValuesMap<Object> map = this.keyValueMapMap.get(keyType);
        if (map == null) {
            map = new KeyValuesMap<K>(keyType);
            this.keyValueMapMap.put(keyType, map);
        }
        return map;
    }

    public void put(@Nullable IndexedMapKeySet keySet, @Nonnull I value) {
        if (keySet != null) {
            for (IndexedMapKey<?> indexKey : keySet) {
                this.put(indexKey, value);
            }
        }
    }

    public <K extends Serializable> void put(@Nonnull IndexedMapKey<K> key, @Nonnull I value) {
        this.getOrCreateKeyValuesMap(key.keyType()).put(key, value);
    }

    public <K extends Serializable> void put(@Nonnull IndexedMapKeyType<K> keyType, @Nonnull K key, @Nonnull I value) {
        this.put(new IndexedMapKey<K>(keyType, key), value);
    }

    public <K extends Comparable<K> & Serializable> void putAll(@Nonnull IndexedMapKeyType<K> keyType, @Nonnull K key, @Nonnull Collection<I> value) {
        this.getOrCreateKeyValuesMap(keyType).putAll(new IndexedMapKey<Serializable>(keyType, key), value);
    }

    public void dump() {
        for (KeyValuesMap<?> kvm : this.keyValueMapMap.values()) {
            kvm.dump();
        }
    }

    @Nonnull
    public final <K> IndexedMap<I> filter(@Nonnull ValueSet<I> valueSet, @Nullable IndexedMapFilter<? super I> filter) {
        if (filter != null) {
            filter.filter(this, valueSet);
        }
        return this;
    }

    @Nonnull
    public final ValueSet<I> find(@Nonnull Collection<? extends IndexedMapFilter<? super I>> filters) {
        ValueSet<I> valueSet = new ValueSet<I>(new TreeSet<I>(this.allValues.keySet()));
        for (IndexedMapFilter<I> filter : filters) {
            if (filter == null) continue;
            filter.filter(this, valueSet);
        }
        return valueSet;
    }

    private void test(int idx, I value) {
        this.put(nameIdx, "#" + idx, value);
        this.put(valueIdx, idx, value);
        this.put(oddIdx, idx % 2 == 1, value);
        if (idx % 2 == 0) {
            this.put(evenIdx, true, value);
        }
        this.put(number, true, value);
    }

    public static void main(String[] parms) {
        try {
            int idx;
            IndexedMap i1 = new IndexedMap();
            IndexedMap i2 = new IndexedMap();
            IndexedMap i3 = new IndexedMap();
            IndexedMap index = new IndexedMap();
            for (idx = 0; idx < 10; ++idx) {
                super.test(idx, String.format("%03d", idx));
            }
            for (idx = 10; idx < 20; ++idx) {
                super.test(idx, String.format("%03d", idx));
            }
            for (idx = 20; idx < 30; ++idx) {
                super.test(idx, String.format("%03d", idx));
            }
            index.addAll(i1);
            index.addAll(i2);
            index.addAll(i3);
            index.remove("004");
            index.dump();
            ValueSet found = index.find(Arrays.asList(new IndexedMapFilter.HasKeyCriteria(evenIdx), new IndexedMapFilter.KeyLessThanOrEqualsCriteria(valueIdx, 10), new IndexedMapFilter.KeyGreaterThanOrEqualsCriteria(valueIdx, 2), new IndexedMapFilter.KeyEqualsCriteria(oddIdx, false)));
            System.out.println("FOUND: " + found);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final class KeyValuesMap<K extends Serializable>
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 1L;
        @Nonnull
        private final IndexedMapKeyType<K> keyType;
        private final TreeMap<IndexedMapKey<K>, KeyValues> map = new TreeMap();

        KeyValuesMap(IndexedMapKeyType<K> keyType) {
            this.keyType = keyType;
        }

        KeyValuesMap(KeyValuesMap<K> clone) {
            this.keyType = clone.keyType;
            for (Map.Entry<IndexedMapKey<K>, KeyValues> entry : clone.map.entrySet()) {
                this.map.put(entry.getKey(), entry.getValue().clone());
            }
        }

        @Nonnull
        public KeyValuesMap<K> clone() {
            return new KeyValuesMap<K>(this);
        }

        @Nonnull
        TreeMap<IndexedMapKey<K>, KeyValues> cloneMap() {
            return (TreeMap)this.map.clone();
        }

        public void addAll(@Nonnull KeyValuesMap<K> other) {
            for (Map.Entry<IndexedMapKey<K>, KeyValues> entry : other.map.entrySet()) {
                this.getOrCreateKeyValues(entry.getKey()).addAll(entry.getValue());
            }
        }

        @Nullable
        private ValueSet<I> getValueSet(@Nonnull IndexedMapKey<K> key) {
            KeyValues keyValues = this.getKeyValues(key);
            if (keyValues != null) {
                return keyValues.values;
            }
            return null;
        }

        @Nullable
        private KeyValues getKeyValues(@Nonnull IndexedMapKey<K> key) {
            return this.map.get(key);
        }

        @Nonnull
        private KeyValues getOrCreateKeyValues(@Nonnull IndexedMapKey<K> key) {
            KeyValues values = this.map.get(key);
            if (values == null) {
                values = new KeyValues(key);
                this.map.put(key, values);
            }
            return values;
        }

        public void put(@Nonnull IndexedMapKey<K> key, @Nonnull I value) {
            this.getOrCreateKeyValues(key).add(value);
        }

        public void putAll(@Nonnull IndexedMapKey<K> key, @Nonnull Collection<I> value) {
            this.getOrCreateKeyValues(key).addAll(value);
        }

        public void dump() {
            for (KeyValues kv : this.map.values()) {
                kv.dump();
            }
        }

        public final class KeyValues
        implements Serializable,
        Cloneable {
            private static final long serialVersionUID = 1L;
            @Nonnull
            private final IndexedMapKey<K> key;
            @Nonnull
            private final ValueSet<I> values = new ValueSet();

            private KeyValues(IndexedMapKey<K> key) {
                this.key = key;
            }

            private KeyValues(KeyValues clone) {
                this.key = clone.key;
                this.values.addAll(clone.values);
            }

            public void add(@Nonnull I value) {
                this.values.add(value);
                IndexedMap.this.handleAdd(value, this.key);
            }

            public void addAll(@Nonnull Collection<I> values) {
                for (Object value : values) {
                    this.values.add(value);
                    IndexedMap.this.handleAdd(value, this.key);
                }
            }

            public void addAll(@Nonnull KeyValues other) {
                this.addAll(other.values);
            }

            public int size() {
                return this.values.size();
            }

            public String toString() {
                return this.key.keyType().toString() + "[" + this.key.keyValue() + "]";
            }

            @Nonnull
            public KeyValues clone() {
                return new KeyValues(this);
            }

            public void dump() {
                System.out.println(this.toString());
                for (Object value : this.values) {
                    System.out.println(" ... " + value);
                }
            }
        }
    }
}

