/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.file.quicktime;

import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.XmlObjectMediaBase;
import com.apple.jingle.leghorn.media.file.MediaTrack;
import com.apple.jingle.leghorn.media.file.quicktime.QtMetaData;
import com.apple.jingle.leghorn.media.file.quicktime.QuickTimeMediaFile;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.locale.BCP47Tag;
import com.apple.jingle.locale.BCP47TagParseException;
import com.apple.jingle.locale.BCP47TagSupport;
import com.apple.jingle.locale.ISO639_2Code;
import com.apple.jingle.locale.LocaleCode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import noNamespace.ExtendedLanguage;
import noNamespace.Language;
import noNamespace.MetadataAtoms;
import noNamespace.TaggedCharacteristics;
import noNamespace.Track;
import noNamespace.UserDataAtoms;

public abstract class QuickTimeTrack<XMLO extends Track>
extends XmlObjectMediaBase<XMLO>
implements MediaTrack {
    @Nonnull
    private final Set<String> taggedCharacteristics;
    @Nonnull
    protected final Map<String, QtMetaData> userDataMap = new TreeMap<String, QtMetaData>(String.CASE_INSENSITIVE_ORDER);
    @Nonnull
    protected final Map<String, QtMetaData> metaDataMap = new TreeMap<String, QtMetaData>(String.CASE_INSENSITIVE_ORDER);
    @Nonnull
    protected final QuickTimeMediaFile mediaFile;
    protected final boolean enabled;
    @Nullable
    private final BigInteger trackId;

    public QuickTimeTrack(@Nonnull QuickTimeMediaFile mediaFile, @Nonnull XMLO xmlObject) {
        super(mediaFile.getMediaFileMetaData(), mediaFile.getMediaName() + "#" + xmlObject.getTrackId().toString(), xmlObject);
        MetadataAtoms mdataAtom;
        this.mediaFile = mediaFile;
        this.trackId = xmlObject.getTrackId();
        this.enabled = xmlObject.getEnabled();
        TaggedCharacteristics tagged = xmlObject.getTaggedCharacteristics();
        this.taggedCharacteristics = null != tagged ? Collections.unmodifiableSet(new TreeSet<String>(Arrays.asList(tagged.getCharacteristicArray()))) : Collections.emptySet();
        UserDataAtoms userDataAtom = xmlObject.getUserDataAtoms();
        if (null != userDataAtom) {
            for (UserDataAtoms.UserData metaData : userDataAtom.getUserDataArray()) {
                QtMetaData data = new QtMetaData(metaData);
                this.userDataMap.put(data.getType(), data);
            }
        }
        if (null != (mdataAtom = xmlObject.getMetadataAtoms())) {
            for (MetadataAtoms.Metadata metaData : mdataAtom.getMetadataArray()) {
                QtMetaData data = new QtMetaData(metaData);
                this.metaDataMap.put(data.getType(), data);
            }
        }
    }

    @Nonnull
    public final QuickTimeMediaFile getMediaFile() {
        return this.mediaFile;
    }

    public boolean isTrackEnabled() {
        return this.enabled;
    }

    protected final boolean hasCharacteristic(@Nonnull String characteristic) {
        return this.taggedCharacteristics.contains(characteristic);
    }

    @Override
    @Nonnull
    public final BigInteger getTrackId() {
        if (this.trackId != null) {
            return this.trackId;
        }
        throw new IllegalStateException("Track id is null for " + this);
    }

    @Override
    @Nonnull
    public final String getMediaName() {
        return this.name;
    }

    @Nonnull
    protected static MediaValue<BigDecimal> calcAlternateGroup(@Nonnull XmlObjectMediaParser parser, @Nonnull Track track, @Nullable String validationCodePrefix) {
        return parser.toMediaDecimal("alternate_group", validationCodePrefix);
    }

    @Nonnull
    protected static MediaValue<Boolean> calcEnabled(@Nonnull XmlObjectMediaParser parser, @Nonnull Track track, @Nullable String validationCodePrefix) {
        return parser.toMediaBoolean("enabled", validationCodePrefix);
    }

    @Nonnull
    protected static MediaValue<MediaTime> calcDuration(@Nonnull XmlObjectMediaParser parser, @Nonnull Track xmlObject, @Nullable String validationCodePrefix) {
        return parser.toMediaDuration(xmlObject.getDuration(), validationCodePrefix);
    }

    @Nonnull
    protected static MediaValue<LocaleCode> calcLocale(@Nonnull XmlObjectMediaParser parser, @Nonnull Track xmlObject, @Nullable String featureValidationCodePrefix) {
        Language lang;
        String badLocale = null;
        ExtendedLanguage el = xmlObject.getExtendedLanguage();
        if (null != el && null != el.getStringValue()) {
            try {
                BCP47Tag code = BCP47TagSupport.createBCP47Tag((String)el.getStringValue());
                if (null != code) {
                    return parser.toMediaValue(code);
                }
            }
            catch (BCP47TagParseException e) {
                badLocale = el.getStringValue();
            }
        }
        if (null != (lang = xmlObject.getLanguage()) && null != lang.getStringValue()) {
            try {
                String langCode = lang.getStringValue();
                if (null != lang) {
                    BCP47Tag code;
                    if (langCode.startsWith(":")) {
                        langCode = langCode.substring(1);
                    }
                    if (null != (code = ISO639_2Code.getBCP47TagForISO639Tag((String)langCode))) {
                        return parser.toMediaValue(code);
                    }
                }
            }
            catch (Exception e) {
                badLocale = lang.getStringValue();
            }
        }
        MediaValidationCode invalidCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".invalid");
        MediaValidationCode missingCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".missing");
        if (null != badLocale && null != invalidCode) {
            return parser.toMediaError(invalidCode, MediaUtil.dictionary.add("localeCode", badLocale));
        }
        return parser.toMediaError(missingCode, MediaUtil.dictionary);
    }
}

