/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.file.quicktime;

import com.apple.jingle.leghorn.media.MediaFactory;
import com.apple.jingle.leghorn.media.MediaProperties;
import com.apple.jingle.leghorn.media.MediaPropertiesBase;
import com.apple.jingle.leghorn.media.MediaTrackCriteria;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.XmlObjectMediaBase;
import com.apple.jingle.leghorn.media.file.MediaFileBackedByXmlDescription;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.file.MediaFileType;
import com.apple.jingle.leghorn.media.file.MediaTrack;
import com.apple.jingle.leghorn.media.file.MediaTrackKind;
import com.apple.jingle.leghorn.media.file.quicktime.QtCaptionsTrack;
import com.apple.jingle.leghorn.media.file.quicktime.QtChapterImageTrack;
import com.apple.jingle.leghorn.media.file.quicktime.QtChapterTrack;
import com.apple.jingle.leghorn.media.file.quicktime.QtEditListEntry;
import com.apple.jingle.leghorn.media.file.quicktime.QtMetaData;
import com.apple.jingle.leghorn.media.file.quicktime.QtSoundTrack;
import com.apple.jingle.leghorn.media.file.quicktime.QtSubtitleTrack;
import com.apple.jingle.leghorn.media.file.quicktime.QtThumbnailTrack;
import com.apple.jingle.leghorn.media.file.quicktime.QtTimecodeTrack;
import com.apple.jingle.leghorn.media.file.quicktime.QtUnknownTrack;
import com.apple.jingle.leghorn.media.file.quicktime.QtVideoTrack;
import com.apple.jingle.leghorn.media.file.quicktime.QtWebVttTrack;
import com.apple.jingle.leghorn.media.file.quicktime.QuickTimeTrack;
import com.apple.jingle.leghorn.media.validator.SimpleDictionary;
import com.apple.jingle.leghorn.media.validator.ValidationLevel;
import com.apple.jingle.leghorn.media.validator.ValidationResult;
import com.apple.jingle.leghorn.media.validator.ValidationResultSet;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.media.foundation.types.UniformTypeIdentifier;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import noNamespace.AlertItemQT;
import noNamespace.AlertListQT;
import noNamespace.ChapterImageTrack;
import noNamespace.ChapterTrack;
import noNamespace.Clock;
import noNamespace.ItunesMetadataAtoms;
import noNamespace.Matrix;
import noNamespace.MetadataAtoms;
import noNamespace.MovieDocument;
import noNamespace.OnScreenDisplayTrack;
import noNamespace.SoundTrack;
import noNamespace.SubtitleTrack;
import noNamespace.TimecodeTrack;
import noNamespace.Track;
import noNamespace.UserDataAtoms;
import noNamespace.VideoTrack;
import noNamespace.VttTrack;
import org.apache.mahout.math.Arrays;
import org.apache.xmlbeans.XmlObject;

public class QuickTimeMediaFile
extends XmlObjectMediaBase<MovieDocument.Movie>
implements MediaFileBackedByXmlDescription {
    @Nonnull
    private final Map<Number, QuickTimeTrack<?>> trackById = new TreeMap();
    @Nonnull
    private final Map<MediaTrackKind, List<QuickTimeTrack<?>>> tracksByKind = new EnumMap(MediaTrackKind.class);
    @Nonnull
    private final List<QtVideoTrack> videoTracks;
    @Nonnull
    private final List<QtSoundTrack> audioTracks;
    @Nonnull
    private final List<QtSoundTrack> dvsTracks;
    @Nonnull
    private final List<QtSubtitleTrack> subtitleTracks;
    @Nonnull
    private final List<QtSubtitleTrack> sdhTracks;
    @Nonnull
    private final List<QtCaptionsTrack> captionsTracks;
    @Nonnull
    private final List<QtTimecodeTrack> timecodeTracks;
    @Nonnull
    private final List<QtWebVttTrack> webVttTracks;
    @Nonnull
    private final List<QtChapterTrack> chapterTracks;
    @Nonnull
    private final List<QtChapterImageTrack> chapterImageTracks;
    @Nonnull
    private final List<QtThumbnailTrack> thumbnailTracks;
    @Nonnull
    private final List<QtUnknownTrack> unknownTracks;
    @Nonnull
    private final Map<String, QtMetaData> userDataMap = new TreeMap<String, QtMetaData>(String.CASE_INSENSITIVE_ORDER);
    @Nonnull
    private final Map<String, QtMetaData> ittDataMap = new TreeMap<String, QtMetaData>(String.CASE_INSENSITIVE_ORDER);
    @Nonnull
    private final Map<String, QtMetaData> metaDataMap = new TreeMap<String, QtMetaData>(String.CASE_INSENSITIVE_ORDER);
    @Nullable
    private final String codecs;
    @Nullable
    private final String type;
    @Nullable
    private final MediaTime posterTime;
    @Nullable
    private final MediaTime totalDuration;
    @Nullable
    private final MediaTime previewTime;
    @Nullable
    private final MediaTime previewDuration;
    @Nonnull
    private final MediaValue<MediaTime> duration;
    private final boolean identityMatrix;
    private final boolean nonAvTracks;

    /*
     * WARNING - void declaration
     */
    public QuickTimeMediaFile(@Nonnull MediaFileContext metaFile, @Nonnull MovieDocument.Movie xmlObject) {
        super(metaFile, metaFile.getMediaName(), xmlObject);
        int n;
        MetadataAtoms mdataAtom;
        ItunesMetadataAtoms ittDataAtom;
        UserDataAtoms userDataAtom;
        QuickTimeTrack track;
        int len$;
        XmlObjectMediaParser parser = new XmlObjectMediaParser(metaFile, metaFile.getMediaName(), (XmlObject)xmlObject);
        parser.processNotificationList(xmlObject.getNotifications(), MediaValidationCode.FILE_ALERT_PASSTHROUGH);
        this.processAlertList(parser, xmlObject.getParseAlerts(), MediaValidationCode.FILE_ALERT_PASSTHROUGH);
        this.processAlertList(parser, xmlObject.getValidationAlerts(), MediaValidationCode.FILE_ALERT_PASSTHROUGH);
        MovieDocument.Movie.Tracks xmlTracks = xmlObject.getTracks();
        if (null != xmlTracks && null != xmlTracks.getVideoArray()) {
            this.videoTracks = new ArrayList<QtVideoTrack>(xmlTracks.getVideoArray().length);
            for (VideoTrack videoTrack : xmlTracks.getVideoArray()) {
                QtVideoTrack qtVideoTrack = new QtVideoTrack(this, videoTrack);
                this.addTrack(qtVideoTrack);
                this.videoTracks.add(qtVideoTrack);
            }
        } else {
            this.videoTracks = Collections.emptyList();
        }
        if (null != xmlTracks && null != xmlTracks.getSoundArray()) {
            void var8_26;
            SoundTrack[] soundTracks = xmlTracks.getSoundArray();
            this.audioTracks = new ArrayList<QtSoundTrack>(soundTracks.length);
            this.dvsTracks = new ArrayList<QtSoundTrack>(soundTracks.length);
            SoundTrack[] arr$ = soundTracks;
            len$ = arr$.length;
            boolean bl = false;
            while (var8_26 < len$) {
                SoundTrack soundTrack = arr$[var8_26];
                track = new QtSoundTrack(this, soundTrack);
                this.addTrack(track);
                switch (((QtSoundTrack)track).getMediaTrackKind()) {
                    case AUDIO: {
                        this.audioTracks.add((QtSoundTrack)track);
                        break;
                    }
                    case DVS: {
                        this.dvsTracks.add((QtSoundTrack)track);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Not expecting " + track);
                    }
                }
                ++var8_26;
            }
        } else {
            this.audioTracks = Collections.emptyList();
            this.dvsTracks = Collections.emptyList();
        }
        if (null != xmlTracks && null != xmlTracks.getSubtitleArray()) {
            void var8_28;
            SubtitleTrack[] subtitleTracks = xmlTracks.getSubtitleArray();
            this.subtitleTracks = new ArrayList<QtSubtitleTrack>(subtitleTracks.length);
            this.sdhTracks = new ArrayList<QtSubtitleTrack>(subtitleTracks.length);
            SubtitleTrack[] arr$ = subtitleTracks;
            len$ = arr$.length;
            boolean bl = false;
            while (var8_28 < len$) {
                SubtitleTrack subtitleTrack = arr$[var8_28];
                track = new QtSubtitleTrack(this, subtitleTrack);
                this.addTrack(track);
                if (!((QtSubtitleTrack)track).isSdh()) {
                    this.subtitleTracks.add((QtSubtitleTrack)track);
                } else {
                    this.sdhTracks.add((QtSubtitleTrack)track);
                }
                ++var8_28;
            }
        } else {
            this.subtitleTracks = Collections.emptyList();
            this.sdhTracks = Collections.emptyList();
        }
        if (null != xmlTracks && null != xmlTracks.getCaptionArray()) {
            void var8_30;
            OnScreenDisplayTrack[] captionsTracks = xmlTracks.getCaptionArray();
            this.captionsTracks = new ArrayList<QtCaptionsTrack>(captionsTracks.length);
            OnScreenDisplayTrack[] arr$ = captionsTracks;
            len$ = arr$.length;
            boolean bl = false;
            while (var8_30 < len$) {
                OnScreenDisplayTrack onScreenDisplayTrack = arr$[var8_30];
                track = new QtCaptionsTrack(this, onScreenDisplayTrack);
                this.addTrack(track);
                this.captionsTracks.add((QtCaptionsTrack)track);
                ++var8_30;
            }
        } else {
            this.captionsTracks = Collections.emptyList();
        }
        if (null != xmlTracks && null != xmlTracks.getTimecodeArray()) {
            void var8_32;
            TimecodeTrack[] timecodeTracks = xmlTracks.getTimecodeArray();
            this.timecodeTracks = new ArrayList<QtTimecodeTrack>(timecodeTracks.length);
            TimecodeTrack[] arr$ = timecodeTracks;
            len$ = arr$.length;
            boolean bl = false;
            while (var8_32 < len$) {
                TimecodeTrack timecodeTrack = arr$[var8_32];
                track = new QtTimecodeTrack(this, timecodeTrack);
                this.addTrack(track);
                this.timecodeTracks.add((QtTimecodeTrack)track);
                ++var8_32;
            }
        } else {
            this.timecodeTracks = Collections.emptyList();
        }
        if (null != xmlTracks && null != xmlTracks.getWebvttSubtitleArray()) {
            void var8_34;
            VttTrack[] vttTracks = xmlTracks.getWebvttSubtitleArray();
            this.webVttTracks = new ArrayList<QtWebVttTrack>(vttTracks.length);
            VttTrack[] arr$ = vttTracks;
            len$ = arr$.length;
            boolean bl = false;
            while (var8_34 < len$) {
                VttTrack vttTrack = arr$[var8_34];
                track = new QtWebVttTrack(this, vttTrack);
                this.addTrack(track);
                this.webVttTracks.add((QtWebVttTrack)track);
                ++var8_34;
            }
        } else {
            this.webVttTracks = Collections.emptyList();
        }
        if (null != xmlTracks && null != xmlTracks.getChapterArray()) {
            void var8_36;
            ChapterTrack[] chTracks = xmlTracks.getChapterArray();
            this.chapterTracks = new ArrayList<QtChapterTrack>(chTracks.length);
            ChapterTrack[] arr$ = chTracks;
            len$ = arr$.length;
            boolean bl = false;
            while (var8_36 < len$) {
                ChapterTrack chapterTrack = arr$[var8_36];
                track = new QtChapterTrack(this, chapterTrack);
                this.addTrack(track);
                this.chapterTracks.add((QtChapterTrack)track);
                ++var8_36;
            }
        } else {
            this.chapterTracks = Collections.emptyList();
        }
        if (null != xmlTracks && null != xmlTracks.getChapterImageArray()) {
            void var8_38;
            ChapterImageTrack[] chImgTracks = xmlTracks.getChapterImageArray();
            this.chapterImageTracks = new ArrayList<QtChapterImageTrack>(chImgTracks.length);
            ChapterImageTrack[] arr$ = chImgTracks;
            len$ = arr$.length;
            boolean bl = false;
            while (var8_38 < len$) {
                ChapterImageTrack chapterImageTrack = arr$[var8_38];
                track = new QtChapterImageTrack(this, chapterImageTrack);
                this.addTrack(track);
                this.chapterImageTracks.add((QtChapterImageTrack)track);
                ++var8_38;
            }
        } else {
            this.chapterImageTracks = Collections.emptyList();
        }
        if (null != xmlTracks && null != xmlTracks.getThumbnailArray()) {
            void var8_40;
            Track[] tnailTracks = xmlTracks.getThumbnailArray();
            this.thumbnailTracks = new ArrayList<QtThumbnailTrack>(tnailTracks.length);
            Track[] arr$ = tnailTracks;
            len$ = arr$.length;
            boolean bl = false;
            while (var8_40 < len$) {
                Track track2 = arr$[var8_40];
                track = new QtThumbnailTrack(this, track2);
                this.addTrack(track);
                this.thumbnailTracks.add((QtThumbnailTrack)track);
                ++var8_40;
            }
        } else {
            this.thumbnailTracks = Collections.emptyList();
        }
        if (null != xmlTracks && null != xmlTracks.getUnknownArray()) {
            void var8_42;
            Track[] unknownTracks = xmlTracks.getUnknownArray();
            this.unknownTracks = new ArrayList<QtUnknownTrack>(unknownTracks.length);
            Track[] arr$ = unknownTracks;
            len$ = arr$.length;
            boolean bl = false;
            while (var8_42 < len$) {
                Track track3 = arr$[var8_42];
                track = new QtUnknownTrack(this, MediaTrackKind.UNKNOWN, track3);
                this.addTrack(track);
                this.unknownTracks.add((QtUnknownTrack)track);
                ++var8_42;
            }
        } else {
            this.unknownTracks = Collections.emptyList();
        }
        if (null != xmlTracks && null != xmlTracks.getUserDataAtomsArray()) {
            for (VideoTrack videoTrack : xmlTracks.getUserDataAtomsArray()) {
                for (UserDataAtoms.UserData metaData : videoTrack.getUserDataArray()) {
                    QtMetaData data = new QtMetaData(metaData);
                    this.userDataMap.put(data.getType(), data);
                }
            }
        }
        if (null != (userDataAtom = xmlObject.getUserDataAtoms())) {
            void var8_45;
            UserDataAtoms.UserData[] arr$ = userDataAtom.getUserDataArray();
            len$ = arr$.length;
            boolean bl = false;
            while (var8_45 < len$) {
                UserDataAtoms.UserData userData = arr$[var8_45];
                QtMetaData data = new QtMetaData(userData);
                this.userDataMap.put(data.getType(), data);
                ++var8_45;
            }
        }
        if (null != xmlTracks && null != xmlTracks.getItunesMetadataAtomsArray()) {
            void var8_47;
            ItunesMetadataAtoms[] arr$ = xmlTracks.getItunesMetadataAtomsArray();
            len$ = arr$.length;
            boolean bl = false;
            while (var8_47 < len$) {
                ItunesMetadataAtoms itunesMetadataAtoms = arr$[var8_47];
                for (ItunesMetadataAtoms.ItunesMetadata metaData : itunesMetadataAtoms.getItunesMetadataArray()) {
                    QtMetaData data = new QtMetaData(metaData);
                    this.ittDataMap.put(data.getType(), data);
                }
                ++var8_47;
            }
        }
        if (null != (ittDataAtom = xmlObject.getItunesMetadataAtoms())) {
            void var9_78;
            ItunesMetadataAtoms.ItunesMetadata[] arr$ = ittDataAtom.getItunesMetadataArray();
            int n2 = arr$.length;
            boolean bl = false;
            while (var9_78 < n2) {
                ItunesMetadataAtoms.ItunesMetadata metaData = arr$[var9_78];
                QtMetaData data = new QtMetaData(metaData);
                this.ittDataMap.put(data.getType(), data);
                ++var9_78;
            }
        }
        if (null != xmlTracks && null != xmlTracks.getMetadataAtomsArray()) {
            void var9_80;
            MetadataAtoms[] arr$ = xmlTracks.getMetadataAtomsArray();
            int n3 = arr$.length;
            boolean bl = false;
            while (var9_80 < n3) {
                MetadataAtoms dataAtom = arr$[var9_80];
                for (MetadataAtoms.Metadata metaData : dataAtom.getMetadataArray()) {
                    QtMetaData data = new QtMetaData(metaData);
                    this.metaDataMap.put(data.getType(), data);
                }
                ++var9_80;
            }
        }
        if (null != (mdataAtom = xmlObject.getMetadataAtoms())) {
            for (MetadataAtoms.Metadata metaData : mdataAtom.getMetadataArray()) {
                QtMetaData data = new QtMetaData(metaData);
                this.metaDataMap.put(data.getType(), data);
            }
        }
        this.duration = QuickTimeMediaFile.calcDuation(parser, xmlObject);
        this.codecs = xmlObject.getCodecs();
        this.type = xmlObject.getType();
        Clock clock = xmlObject.getClock();
        if (null != clock && clock.isSetTimeScale()) {
            this.posterTime = clock.isSetPosterTime() ? new MediaTime(clock.getPosterTime(), clock.getTimeScale()) : null;
            this.totalDuration = clock.isSetTotalDuration() ? new MediaTime(clock.getTotalDuration(), clock.getTimeScale()) : null;
            this.previewTime = clock.isSetPreviewTime() ? new MediaTime(clock.getPreviewTime(), clock.getTimeScale()) : null;
            this.previewDuration = clock.isSetPreviewDuration() ? new MediaTime(clock.getPreviewDuration(), clock.getTimeScale()) : null;
        } else {
            this.posterTime = null;
            this.totalDuration = null;
            this.previewTime = null;
            this.previewDuration = null;
        }
        boolean bl = true;
        for (VideoTrack t : xmlObject.getTracks().getVideoArray()) {
            Matrix trackMatrixNode = t.getMatrix();
            if (trackMatrixNode == null) continue;
            n &= trackMatrixNode.getIdentity();
        }
        this.identityMatrix = n;
        MovieDocument.Movie.Tracks ts = xmlObject.getTracks();
        this.nonAvTracks = 0 < ts.sizeOfCaptionArray() + ts.sizeOfChapterArray() + ts.sizeOfChapterImageArray() + ts.sizeOfSubtitleArray() + ts.sizeOfThumbnailArray() + ts.sizeOfUnknownArray();
    }

    @Nonnull
    public Map<String, String> getTrackDataMap(@Nonnull int trackId) {
        String prefix = "moov.trak." + trackId + ".";
        HashMap<String, String> subMap = new HashMap<String, String>(this.mediaDataMap.size());
        for (Map.Entry entry : this.mediaDataMap.entrySet()) {
            if (!((String)entry.getKey()).startsWith(prefix)) continue;
            subMap.put(((String)entry.getKey()).substring(prefix.length()), (String)entry.getValue());
        }
        return subMap;
    }

    @Nonnull
    MediaFileContext getMediaFileMetaData() {
        return this.metaFile;
    }

    protected void processAlertList(@Nonnull XmlObjectMediaParser parser, @Nullable AlertListQT alertList, @Nonnull MediaValidationCode code) {
        if (null != alertList) {
            for (AlertItemQT item : alertList.getAlertArray()) {
                String message = item.getMessage();
                if (message.toLowerCase().contains("Atom size extends beyond the end of the file".toLowerCase())) {
                    parser.addIssue(MediaValidationCode.QT_ATOM_EXTENDS_BEYOND_FILE, MediaUtil.dictionary.add("message", message));
                    continue;
                }
                if (message.toLowerCase().contains("Zero length input file cannot be described".toLowerCase())) {
                    parser.addIssue(MediaValidationCode.FILE_EMPTY, MediaUtil.dictionary.add("message", message));
                    continue;
                }
                if (message.toLowerCase().contains("There is more than one metadata header (moov atom) in the file".toLowerCase()) || message.toLowerCase().contains("There is more that one metadata header (moov atom) in the file".toLowerCase())) {
                    parser.addIssue(MediaValidationCode.MOV_CONTAINER_TWO_OR_MORE_MOOVS, MediaUtil.dictionary.add("message", message));
                    continue;
                }
                parser.addIssue(code, MediaUtil.dictionary.add("message", message));
            }
        }
    }

    @Nullable
    public String getCodecs() {
        return this.codecs;
    }

    @Nonnull
    protected static MediaValue<MediaTime> calcDuation(@Nonnull XmlObjectMediaParser parser, @Nonnull MovieDocument.Movie xmlObject) {
        Clock clock = xmlObject.getClock();
        if (null != clock) {
            return parser.toMediaValue(new MediaTime(clock.getTotalDuration(), clock.getTimeScale()));
        }
        return parser.toMediaDuration(xmlObject.getDuration(), null);
    }

    @Override
    @Nonnull
    public MediaValue<MediaTime> duration() {
        return this.duration;
    }

    private final void addTrack(@Nonnull QuickTimeTrack<?> track) {
        this.trackById.put(track.getTrackId(), track);
        List<QuickTimeTrack<?>> tracks = this.tracksByKind.get(track.getMediaTrackKind());
        if (null == tracks) {
            tracks = new LinkedList();
            this.tracksByKind.put(track.getMediaTrackKind(), tracks);
        }
        tracks.add(track);
    }

    @Override
    public MediaFileType getMediaFileType() {
        return MediaFileType.quickTime;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "name=" + this.getMediaName() + ", " + "type=" + this.type + ", " + "codecs=\"" + this.codecs + "\", " + "dur=" + this.duration + ", " + "posterTime=" + this.posterTime + ", " + "previewTime=" + this.previewTime + ", " + "previewDur=" + this.previewDuration + ", " + "totalDur=" + this.totalDuration + "]";
    }

    @Override
    @Nonnull
    public String getMediaName() {
        return this.name;
    }

    public List<? extends QuickTimeTrack<?>> getTracks() {
        return new ArrayList(this.trackById.values());
    }

    @Override
    @Nonnull
    public QuickTimeTrack<?> getTrackById(@Nullable BigInteger mediaTrackId) throws NoSuchElementException {
        QuickTimeTrack<?> track = this.trackById.get(mediaTrackId);
        if (null != track) {
            return track;
        }
        throw new NoSuchElementException(this.name + "#" + mediaTrackId);
    }

    @Override
    @Nonnull
    public <T extends MediaTrack> T getFirstTrack(@Nonnull Class<T> trackType, MediaTrackCriteria ... criteria) throws NoSuchElementException {
        for (MediaTrack mediaTrack : this.trackById.values()) {
            MediaTrack track;
            if (!trackType.isInstance(mediaTrack) || !MediaUtil.meetsCriteria(track = (MediaTrack)trackType.cast(mediaTrack), criteria)) continue;
            return (T)track;
        }
        throw new NoSuchElementException(trackType.getName() + Arrays.toString((Object[])criteria));
    }

    @Override
    public boolean hasTrack(MediaTrackCriteria ... criteria) {
        for (MediaTrack mediaTrack : this.trackById.values()) {
            if (!MediaUtil.meetsCriteria(mediaTrack, criteria)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public <T extends MediaTrack> List<T> getTracks(@Nonnull Class<T> trackType, MediaTrackCriteria ... criteria) {
        ArrayList<MediaTrack> tracks = new ArrayList<MediaTrack>(this.trackById.size());
        for (MediaTrack mediaTrack : this.trackById.values()) {
            MediaTrack track;
            if (!trackType.isInstance(mediaTrack) || !MediaUtil.meetsCriteria(track = (MediaTrack)trackType.cast(mediaTrack), criteria)) continue;
            tracks.add(track);
        }
        return Collections.unmodifiableList(tracks);
    }

    public boolean movieHasNonAVTracks() {
        return this.nonAvTracks;
    }

    public boolean matrixIsIdentity() {
        return this.identityMatrix;
    }

    public Map<String, String> getMediaDataMap() {
        return this.mediaDataMap;
    }

    public static void main(String[] parms) {
        try {
            final File file = new File(parms[0]);
            final MediaProperties properties = MediaPropertiesBase.nullProperties;
            final ValidationResultSet issues = new ValidationResultSet();
            MediaFileContext ctx = new MediaFileContext(){

                @Override
                public UniformTypeIdentifier getUniformTypeIdentifier() {
                    return UniformTypeIdentifier.byFileName((String)file.getName());
                }

                @Override
                public MediaProperties getMediaProperties() {
                    return properties;
                }

                @Override
                public String getMediaName() {
                    return file.getName();
                }

                @Override
                public String getMediaLocale() {
                    return null;
                }

                @Override
                public Map<String, String> getMediaAttributes() {
                    return Collections.emptyMap();
                }

                @Override
                public String getDescriptionToolVersion() {
                    return "1.0";
                }

                @Override
                public String getDescriptionToolName() {
                    return "cli";
                }

                @Override
                public MediaFileContext child(String childLabel) {
                    return this;
                }

                @Override
                public Set<MediaValidationCode> getSkipValidations() {
                    return null;
                }

                @Override
                public ValidationResult addIssue(MediaValidationCode code, ValidationLevel defaultLevel, String assetId, SimpleDictionary parameters) {
                    return issues.addResult(code, defaultLevel, assetId, parameters);
                }

                @Override
                public ValidationResult addIssue(MediaValidationCode code, String assetId, SimpleDictionary parameters) {
                    return issues.addResult(code, assetId, parameters);
                }
            };
            QuickTimeMediaFile mediaFile = (QuickTimeMediaFile)MediaFactory.newMediaFile(ctx, file);
            if (!issues.getValidations().isEmpty()) {
                System.out.println("Issues:");
                for (ValidationResult validationResult : issues.getValidations()) {
                    System.out.println(validationResult);
                }
                System.out.println();
            }
            System.out.println();
            System.out.println(mediaFile);
            for (QuickTimeTrack quickTimeTrack : mediaFile.getTracks()) {
                System.out.println("  " + quickTimeTrack);
                if (quickTimeTrack instanceof QtVideoTrack) {
                    for (QtEditListEntry entry : ((QtVideoTrack)quickTimeTrack).getEditListEntries()) {
                        if (!entry.isEmptyEdit()) continue;
                        System.out.println("--- EmptyEdit on " + quickTimeTrack + " / " + entry);
                    }
                }
                if (!(quickTimeTrack instanceof QtSoundTrack)) continue;
                for (QtEditListEntry entry : ((QtSoundTrack)quickTimeTrack).getEditListEntries()) {
                    if (!entry.isEmptyEdit()) continue;
                    System.out.println("--- EmptyEdit on " + quickTimeTrack + " / " + entry);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

