/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.file.quicktime;

import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.XmlObjectMediaBase;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import com.apple.jingle.leghorn.timecode.SampleRate;
import com.apple.jingle.locale.BCP47Tag;
import com.apple.jingle.locale.BCP47TagMediator;
import com.apple.jingle.locale.BCP47TagParseException;
import com.apple.jingle.locale.LocaleCode;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class QuickTimeFinalMediaFile
extends XmlObjectMediaBase<XmlObject> {
    @Nonnull
    private final SampleRate sampleRate;
    @Nonnull
    private final Integer displayHeight;
    @Nonnull
    private final Integer displayWidth;
    @Nonnull
    private final Integer encodeHeight;
    @Nonnull
    private final Integer encodeWidth;
    @Nonnull
    private final List<QuickTimeSoundTrackInfo> soundTracks;
    @Nonnull
    private final List<QuickTimeSubtitleTrackInfo> subtitleTracks;
    @Nonnull
    private final MediaValue<BigDecimal> trackId;
    private final double durationMillis;
    @Nonnull
    private final QuickTimeChaptersInfo chapterInfo;
    @Nonnull
    private final QuickTimeCaptionInfo captionInfo;

    public QuickTimeFinalMediaFile(@Nonnull MediaFileContext metaFile, @Nonnull XmlObject xmlObject) throws XmlException {
        super(metaFile, metaFile.getMediaName(), xmlObject);
        XmlObjectMediaParser parser = new XmlObjectMediaParser(metaFile, metaFile.getMediaName(), xmlObject);
        this.sampleRate = SampleRate.parseDecimalString(parser.toXmlStringWithDefault("//movie/tracks/video/frame_rate", "0"));
        this.displayHeight = Integer.parseInt(parser.toXmlStringWithDefault("//movie/tracks/video/display_dimensions/height", "0"));
        this.displayWidth = Integer.parseInt(parser.toXmlStringWithDefault("//movie/tracks/video/display_dimensions/width", "0"));
        this.encodeHeight = Integer.parseInt(parser.toXmlStringWithDefault("//movie/tracks/video/encoded_dimensions/height", "0"));
        this.encodeWidth = Integer.parseInt(parser.toXmlStringWithDefault("//movie/tracks/video/encoded_dimensions/width", "0"));
        this.trackId = parser.toMediaDecimal("track_id", null);
        double durationMillis = 0.0;
        for (XmlObject xml : parser.toXmlObjects("//movie/tracks/*/duration")) {
            if (!"milliseconds".equalsIgnoreCase(XmlObjectMediaParser.toXmlAttrString(xml, "units"))) {
                throw new RuntimeException("Cannot generate duration for movie with tracks that use units other than milliseconds");
            }
            double milliSeconds = XmlObjectMediaParser.toXmlDuration(xml, "milliseconds");
            if (!(durationMillis < milliSeconds)) continue;
            durationMillis = milliSeconds;
        }
        this.durationMillis = durationMillis;
        XmlObject[] soundTrackNodes = parser.toXmlObjects("//movie/tracks/sound");
        if (soundTrackNodes != null && soundTrackNodes.length > 0) {
            ArrayList<QuickTimeSoundTrackInfo> soundTracks = new ArrayList<QuickTimeSoundTrackInfo>(soundTrackNodes.length);
            for (XmlObject soundTrackNode : soundTrackNodes) {
                int numChannels = XmlObjectMediaParser.toXmlObjectCount(soundTrackNode, "channel_layout/channel");
                LocaleCode languageCode = this.getLocaleCode(soundTrackNode);
                String channelLayoutName = XmlObjectMediaParser.toXmlString(soundTrackNode, "channel_layout/@name");
                boolean isDVS = false;
                boolean voiceOver = false;
                for (String characteristic : XmlObjectMediaParser.toXmlStrings(soundTrackNode, "tagged_characteristics/characteristic")) {
                    isDVS = characteristic.compareTo("public.accessibility.describes-video") == 0 || isDVS;
                    voiceOver = characteristic.compareTo("public.translation.voice-over") == 0 || voiceOver;
                }
                String enabledAttr = XmlObjectMediaParser.toXmlAttrString(soundTrackNode, "enabled");
                String codec = XmlObjectMediaParser.toXmlAttrString(soundTrackNode, "codec", "name");
                soundTracks.add(new QuickTimeSoundTrackInfo(this.getTrackId(soundTrackNode), channelLayoutName, StringUtils.isNotBlank((CharSequence)enabledAttr) && enabledAttr.equalsIgnoreCase("true"), codec.equals("ac-3"), codec.equals("ec-3"), isDVS, voiceOver, numChannels, languageCode));
            }
            this.soundTracks = Collections.unmodifiableList(soundTracks);
        } else {
            this.soundTracks = Collections.emptyList();
        }
        XmlObject[] subtitleTrackNodes = parser.toXmlObjects("//movie/tracks/subtitle");
        if (subtitleTrackNodes != null && subtitleTrackNodes.length > 0) {
            QuickTimeSubtitleForcedType forcedType;
            ArrayList<QuickTimeSubtitleTrackInfo> subtitleTracks = new ArrayList<QuickTimeSubtitleTrackInfo>(subtitleTrackNodes.length);
            for (XmlObject subtitleTrackNode : subtitleTrackNodes) {
                forcedType = QuickTimeSubtitleForcedType.None;
                String forcedSubtitle = XmlObjectMediaParser.toXmlString(subtitleTrackNode, "sample_description/forced_subtitle");
                if ("all".equalsIgnoreCase(forcedSubtitle)) {
                    forcedType = QuickTimeSubtitleForcedType.All;
                } else if ("some".equalsIgnoreCase(forcedSubtitle)) {
                    forcedType = QuickTimeSubtitleForcedType.Some;
                }
                boolean isSDH = false;
                List<String> charList = XmlObjectMediaParser.toXmlStrings(subtitleTrackNode, "tagged_characteristics/characteristic");
                if (charList.contains("public.accessibility.describes-music-and-sound") && charList.contains("public.accessibility.transcribes-spoken-dialog")) {
                    isSDH = true;
                }
                subtitleTracks.add(new QuickTimeSubtitleTrackInfo(this.getTrackId(subtitleTrackNode), forcedType, this.getLocaleCode(subtitleTrackNode), isSDH, QuickTimeFinalMediaFile.getDuration(subtitleTrackNode), false));
            }
            for (XmlObject subtitleTrackNode : parser.toXmlObjects("//movie/tracks/webvtt_subtitle")) {
                forcedType = QuickTimeSubtitleForcedType.None;
                List<String> charList = XmlObjectMediaParser.toXmlStrings(subtitleTrackNode, "tagged_characteristics/characteristic");
                if (charList.contains("public.subtitles.forced-only")) {
                    forcedType = QuickTimeSubtitleForcedType.All;
                }
                subtitleTracks.add(new QuickTimeSubtitleTrackInfo(this.getTrackId(subtitleTrackNode), forcedType, this.getLocaleCode(subtitleTrackNode), false, QuickTimeFinalMediaFile.getDuration(subtitleTrackNode), true));
            }
            this.subtitleTracks = Collections.unmodifiableList(subtitleTracks);
        } else {
            this.subtitleTracks = Collections.emptyList();
        }
        boolean isChaptered = parser.toXmlObjects("//movie/tracks/chapter").length > 0;
        boolean isChapteredWithImages = parser.toXmlObjects("//movie/tracks/chapter_image[@enabled='true']").length > 0;
        this.chapterInfo = new QuickTimeChaptersInfo(isChaptered, isChapteredWithImages);
        boolean isClosedCaptioned = parser.toXmlObjects("//movie/tracks/caption").length > 0;
        LocaleCode closedCaptionLocaleCode = null;
        if (isClosedCaptioned) {
            XmlObject enabledCCTrack = parser.toXmlObject("//movie/tracks/caption[@enabled='true']");
            if (enabledCCTrack == null) {
                throw new RuntimeException("Expected 1 enabled CC track in movie, found none.");
            }
            try {
                closedCaptionLocaleCode = QuickTimeFinalMediaFile.normalizedBCP47LanguageForTrack(enabledCCTrack);
            }
            catch (BCP47TagParseException parseException) {
                throw new NoSuchElementException(parseException.getMessage());
            }
        }
        this.captionInfo = new QuickTimeCaptionInfo(isClosedCaptioned, closedCaptionLocaleCode);
        this.shouldBeValidMovieDocumentWithEnabledVideoTrack(parser);
    }

    private void shouldBeValidMovieDocumentWithEnabledVideoTrack(XmlObjectMediaParser parser) throws XmlException {
        XmlObject movieDocument = parser.toXmlObject("//movie");
        if (movieDocument == null) {
            throw new XmlException("Element container is not a valid movie document or a valid substitution.");
        }
        XmlObject enabledVideoTrack = parser.toXmlObject("//movie/tracks/video[@enabled='true']");
        if (enabledVideoTrack == null) {
            throw new RuntimeException("Expected 1 enabled video track in movie, found 0");
        }
    }

    @Nonnegative
    public double getDuration() {
        return this.durationMillis;
    }

    @Nonnull
    public QuickTimeChaptersInfo getChapterInfo() {
        return this.chapterInfo;
    }

    @Nonnull
    public QuickTimeCaptionInfo getCaptionInfo() {
        return this.captionInfo;
    }

    @Nonnull
    public SampleRate getFrameRate() {
        return this.sampleRate;
    }

    public int getDisplayHeight() {
        return this.displayHeight;
    }

    public int getDisplayWidth() {
        return this.displayWidth;
    }

    public int getEncodedHeight() {
        return this.encodeHeight;
    }

    public int getEncodedWidth() {
        return this.encodeWidth;
    }

    @Nonnull
    public List<QuickTimeSoundTrackInfo> getSoundTracks() {
        return this.soundTracks;
    }

    @Nonnegative
    private int getTrackId(@Nonnull XmlObject trackNode) {
        return this.trackId.get().intValue();
    }

    private static double getDuration(@Nonnull XmlObject trackNode) {
        return XmlObjectMediaParser.toXmlDuration(XmlObjectMediaParser.toXmlObject(trackNode, "duration"), "milliseconds");
    }

    @Nonnull
    public List<QuickTimeSubtitleTrackInfo> getSubtitleTracks() {
        return this.subtitleTracks;
    }

    @Nullable
    private LocaleCode getLocaleCode(@Nonnull XmlObject trackNode) {
        try {
            return QuickTimeFinalMediaFile.normalizedBCP47LanguageForTrack(trackNode);
        }
        catch (BCP47TagParseException parseException) {
            throw new NoSuchElementException(parseException.getMessage());
        }
    }

    @Nullable
    private static LocaleCode normalizedBCP47LanguageForTrack(XmlObject trackNode) throws BCP47TagParseException {
        String languageCodeISO6392Language2A;
        String languageCodeISO6392TLanguage3A;
        String trackNodeLanguage;
        String tagString = null;
        BCP47Tag languageCode = null;
        String extendedLanguage = XmlObjectMediaParser.toXmlString(trackNode, "extended_language");
        if (StringUtils.isNotBlank((CharSequence)extendedLanguage)) {
            tagString = extendedLanguage;
            languageCode = BCP47TagMediator.createBCP47Tag((String)extendedLanguage);
        }
        if (languageCode == null && StringUtils.isNotBlank((CharSequence)(trackNodeLanguage = XmlObjectMediaParser.toXmlString(trackNode, "language")))) {
            tagString = trackNodeLanguage;
            languageCode = BCP47TagMediator.createBCP47Tag((String)trackNodeLanguage);
        }
        if (tagString != null && languageCode != null && (tagString.equalsIgnoreCase(languageCodeISO6392TLanguage3A = languageCode.getISO6392TLanguage3A()) || languageCode.getRFC4646Language().equalsIgnoreCase(languageCodeISO6392TLanguage3A)) && (languageCodeISO6392Language2A = languageCode.getISO6392Language2A()) != null) {
            languageCode = BCP47TagMediator.createBCP47Tag((String)languageCodeISO6392Language2A);
        }
        return languageCode;
    }

    public static final class QuickTimeSubtitleTrackInfo {
        private final int trackId;
        private final QuickTimeSubtitleForcedType forcedType;
        private final LocaleCode localeCode;
        private final boolean isSDH;
        private final double duration;
        private final boolean isWebVTT;

        public QuickTimeSubtitleTrackInfo(int trackId, QuickTimeSubtitleForcedType forcedType, LocaleCode localeCode, boolean isSDH, double duration, boolean isWebVTT) {
            this.trackId = trackId;
            this.forcedType = forcedType;
            this.localeCode = localeCode;
            this.isSDH = isSDH;
            this.duration = duration;
            this.isWebVTT = isWebVTT;
        }

        public int getTrackId() {
            return this.trackId;
        }

        public double getDuration() {
            return this.duration;
        }

        public LocaleCode getLocaleCode() {
            return this.localeCode;
        }

        public boolean isSDH() {
            return this.isSDH;
        }

        public QuickTimeSubtitleForcedType getForcedType() {
            return this.forcedType;
        }

        public boolean isWebVTT() {
            return this.isWebVTT;
        }
    }

    public static final class QuickTimeSoundTrackInfo {
        private final int trackId;
        private final String channelLayoutName;
        private final boolean enabled;
        private final boolean isAC3;
        private final boolean isEC3;
        private final boolean isDVS;
        private final boolean voiceOver;
        private final int numChannels;
        private final LocaleCode localeCode;

        public QuickTimeSoundTrackInfo(int trackId, String channelLayoutName, boolean enabled, boolean isAC3, boolean isEC3, boolean isDVS, boolean voiceOver, int numChannels, LocaleCode localeCode) {
            this.trackId = trackId;
            this.channelLayoutName = channelLayoutName;
            this.enabled = enabled;
            this.isAC3 = isAC3;
            this.isEC3 = isEC3;
            this.numChannels = numChannels;
            this.isDVS = isDVS;
            this.voiceOver = voiceOver;
            this.localeCode = localeCode;
        }

        public int getTrackId() {
            return this.trackId;
        }

        public int getNumChannels() {
            return this.numChannels;
        }

        public LocaleCode getLocaleCode() {
            return this.localeCode;
        }

        public boolean isEC3() {
            return this.isEC3;
        }

        public boolean isAC3() {
            return this.isAC3;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getChannelLayoutName() {
            return this.channelLayoutName;
        }

        public boolean isDVS() {
            return this.isDVS;
        }

        public boolean isVoiceOver() {
            return this.voiceOver;
        }
    }

    public static final class QuickTimeCaptionInfo {
        private final boolean isClosedCaptioned;
        private final LocaleCode localeCode;

        public QuickTimeCaptionInfo(boolean isClosedCaptioned, LocaleCode localeCode) {
            this.isClosedCaptioned = isClosedCaptioned;
            this.localeCode = localeCode;
        }

        public boolean isClosedCaptioned() {
            return this.isClosedCaptioned;
        }

        public LocaleCode getLocaleCode() {
            return this.localeCode;
        }
    }

    public static final class QuickTimeChaptersInfo {
        private final boolean isChaptered;
        private final boolean isChapteredWithImages;

        public QuickTimeChaptersInfo(boolean isChaptered, boolean isChapteredWithImages) {
            this.isChaptered = isChaptered;
            this.isChapteredWithImages = isChapteredWithImages;
        }

        public boolean isChaptered() {
            return this.isChaptered;
        }

        public boolean isChapteredWithImages() {
            return this.isChapteredWithImages;
        }
    }

    public static enum QuickTimeSubtitleForcedType {
        None,
        Some,
        All;

    }
}

