/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.file.quicktime;

import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.file.MediaSubtitleTrack;
import com.apple.jingle.leghorn.media.file.MediaTrackKind;
import com.apple.jingle.leghorn.media.file.quicktime.QuickTimeMediaFile;
import com.apple.jingle.leghorn.media.file.quicktime.QuickTimeTrack;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.locale.LocaleCode;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import noNamespace.Track;
import noNamespace.VttTrack;
import org.apache.xmlbeans.XmlObject;

public class QtWebVttTrack
extends QuickTimeTrack<VttTrack>
implements MediaSubtitleTrack {
    @Nonnull
    private final MediaValue<LocaleCode> locale;
    @Nonnull
    private final MediaValue<MediaTime> duration;
    @Nonnull
    private final MediaTrackKind trackKind = MediaTrackKind.WEBVTT;

    public QtWebVttTrack(@Nonnull QuickTimeMediaFile mediaFile, @Nonnull VttTrack track) {
        super(mediaFile, track);
        XmlObjectMediaParser parser = new XmlObjectMediaParser(mediaFile.getMediaFileMetaData(), this.getMediaName(), (XmlObject)track);
        this.duration = QtWebVttTrack.calcDuration(parser, (Track)track, MediaValidationCode.AUDIO_DURATION_MISSING.getBaseCode());
        this.locale = QtWebVttTrack.calcLocale(parser, (Track)track, MediaValidationCode.AUDIO_LOCALE_MISSING.getBaseCode());
    }

    public MediaValue<MediaTime> duration() {
        return this.duration;
    }

    @Override
    @Nullable
    public LocaleCode getLocale() {
        return this.locale.tryGet();
    }

    public String toString() {
        return this.getMediaName() + "[" + "lang=" + this.locale + ", " + "dur=" + this.duration + "]";
    }

    @Override
    public MediaTrackKind getMediaTrackKind() {
        return this.trackKind;
    }
}

