/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.file.quicktime;

import com.apple.jingle.foghorn.media.FrameGeometry;
import com.apple.jingle.foghorn.media.types.ColorSpace;
import com.apple.jingle.foghorn.media.types.FieldOrdering;
import com.apple.jingle.foghorn.media.types.HDR10Metadata;
import com.apple.jingle.g5.util.DataDump;
import com.apple.jingle.g5.util.DataDumpable;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.MediaValueImpl;
import com.apple.jingle.leghorn.media.file.MediaTrackKind;
import com.apple.jingle.leghorn.media.file.MediaVideoTrack;
import com.apple.jingle.leghorn.media.file.quicktime.QtDataContentTrack;
import com.apple.jingle.leghorn.media.file.quicktime.QtEditListEntry;
import com.apple.jingle.leghorn.media.file.quicktime.QuickTimeMediaFile;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import com.apple.jingle.leghorn.quicktime.GraphicsMode;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.leghorn.timecode.Rational;
import com.apple.jingle.leghorn.timecode.SampleRate;
import com.apple.jingle.locale.LocaleCode;
import com.google.common.base.Throwables;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import noNamespace.AvcC;
import noNamespace.Clli;
import noNamespace.Colr;
import noNamespace.DataContentTrack;
import noNamespace.Dimensions;
import noNamespace.DurationStatistics;
import noNamespace.EditList;
import noNamespace.Fiel;
import noNamespace.Matrix;
import noNamespace.Mdcv;
import noNamespace.Pasp;
import noNamespace.SampleDescription;
import noNamespace.Track;
import noNamespace.VideoTrack;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.xmlbeans.XmlObject;

public class QtVideoTrack
extends QtDataContentTrack<VideoTrack>
implements MediaVideoTrack,
DataDumpable {
    @Nullable
    private final SampleDescription sampleDescription;
    @Nonnull
    private final MediaValue<MediaTime> duration;
    @Nonnull
    private final MediaValue<String> codecName;
    @Nonnull
    private final MediaValue<String> codecType;
    @Nonnull
    private final MediaValue<String> frameRateMode;
    @Nonnull
    private final MediaValue<FrameGeometry.Dimensions> displayDim;
    @Nonnull
    private final MediaValue<FrameGeometry.Dimensions> encodedDim;
    @Nonnull
    private final MediaValue<FrameGeometry.Dimensions> trackDim;
    @Nonnull
    private final MediaValue<SampleRate> nominalFrameRate;
    @Nonnull
    private final MediaValue<BigDecimal> timeScale;
    @Nonnull
    private final MediaValue<BigDecimal> gamma;
    @Nonnull
    private final MediaValue<GraphicsMode> graphicsMode;
    @Nonnull
    private final MediaValue<BigDecimal> sampleDescriptionCount;
    @Nonnull
    private final MediaValue<ColorSpace> colorSpace;
    @Nonnull
    private final MediaValue<FrameGeometry> frameGeometry;
    @Nonnull
    private static final MediaTrackKind trackKind = MediaTrackKind.VIDEO;
    @Nonnull
    private final MediaValue<BigDecimal> maximumSampleSize;
    @Nonnull
    private final MediaValue<BigDecimal> dataRateInBps;
    @Nonnull
    private final MediaValue<QtVideoMatrix> matrix;
    @Nonnull
    private final MediaValue<Boolean> uniformSamples;
    @Nonnull
    private final MediaValue<BigDecimal> editListEntryCount;
    @Nonnull
    private final MediaValue<ColorSpace> computedColorSpace;
    private final boolean enabled;
    @Nonnull
    private final MediaValue<Long> durationInTimeScale;
    @Nonnull
    private final MediaValue<Long> sampleCount;
    @Nonnull
    private final MediaValue<HDR10Metadata> hdr10Metadata;
    @Nonnull
    private final List<QtEditListEntry> editListEntries;

    public QtVideoTrack(@Nonnull QuickTimeMediaFile mediaFile, @Nonnull VideoTrack track) {
        super(mediaFile, track);
        XmlObjectMediaParser parser = new XmlObjectMediaParser(mediaFile.getMediaFileMetaData(), this.getMediaName(), (XmlObject)track);
        this.sampleDescription = track.getSampleDescription();
        this.duration = QtVideoTrack.calcDuration(parser, (Track)track, MediaValidationCode.VIDEO_DURATION_MISSING.getBaseCode());
        this.codecName = parser.toMediaString("codec", MediaValidationCode.VIDEO_CODEC_MISSING.getBaseCode());
        this.codecType = parser.toMediaString("codec/@type", null);
        this.graphicsMode = parser.toMediaEnum(GraphicsMode.class, "graphics_mode", null);
        this.sampleDescriptionCount = parser.toMediaDecimal("sample_description_count", null);
        this.maximumSampleSize = parser.toMediaDecimal("maximum_sample_size", null);
        this.frameRateMode = parser.toMediaString("frame_rate_mode", null);
        this.dataRateInBps = QtVideoTrack.calcDataRate(parser, (DataContentTrack)track, null);
        this.displayDim = parser.toMediaDim("display_dimensions/width", "display_dimensions/height", MediaValidationCode.VIDEO_DISPDIM_MISSING.getBaseCode());
        this.encodedDim = parser.toMediaDim("encoded_dimensions/width", "encoded_dimensions/height", MediaValidationCode.VIDEO_ENCDIM_MISSING.getBaseCode());
        this.trackDim = parser.toMediaDim("track_dimensions/width", "track_dimensions/height", null);
        this.frameGeometry = this.calcFrameGeometry(parser, track);
        this.nominalFrameRate = QtVideoTrack.calcNominalFrameRate(parser, track);
        this.uniformSamples = QtVideoTrack.calcUniformSamples(parser, track);
        this.timeScale = parser.toMediaDecimal("duration_statistics/@time_scale", MediaValidationCode.VIDEO_TIMESCALE_MISSING.getBaseCode());
        this.gamma = parser.toMediaDecimal("duration_statistics/@gama", MediaValidationCode.VIDEO_GAMMA_INVALID.getBaseCode());
        this.colorSpace = this.calcActualColorSpace(parser, track);
        this.editListEntryCount = parser.toMediaDecimal("edit_list/@count", null);
        this.computedColorSpace = this.computeColorSpace(parser, track);
        DurationStatistics durationStatistics = track.getDurationStatistics();
        this.durationInTimeScale = durationStatistics != null && durationStatistics.getTotalDuration() != null ? parser.toMediaValue(durationStatistics.getTotalDuration().longValue()) : parser.toMediaValue(null);
        this.sampleCount = durationStatistics != null && durationStatistics.getTotalDuration() != null ? parser.toMediaValue((long)((double)durationStatistics.getTotalDuration().longValue() / durationStatistics.getMeanDuration())) : parser.toMediaValue(null);
        this.hdr10Metadata = this.calculateHDR10Metadata(parser, track);
        this.enabled = track.getEnabled();
        this.matrix = null != track.getMatrix() ? new MediaValueImpl<QtVideoMatrix>(new QtVideoMatrix(track.getMatrix())) : new MediaValueImpl<Object>(null);
        this.editListEntries = new LinkedList<QtEditListEntry>();
        if (track.getEditList() != null) {
            for (EditList.EditListEntry e : track.getEditList().getEditListEntryArray()) {
                QtEditListEntry t = new QtEditListEntry(e.getMediaTime(), e.getTrackDuration(), e.getMediaRate());
                this.editListEntries.add(t);
            }
        }
    }

    @Nullable
    public String getTrackData(String key) {
        return (String)this.trackDataMap.get(key);
    }

    public int getTrackData(String key, int defaultValue) {
        String str = (String)this.trackDataMap.get(key);
        try {
            if (null != str) {
                return Integer.parseInt(str);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return defaultValue;
    }

    @Nonnull
    public MediaValue<GraphicsMode> graphicsMode() {
        return this.graphicsMode;
    }

    @Override
    @Nonnull
    public MediaValue<String> codecName() {
        return this.codecName;
    }

    @Nonnull
    public MediaValue<BigDecimal> dataRateInBps() {
        return this.dataRateInBps;
    }

    @Override
    @Nullable
    public LocaleCode getLocale() {
        return null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Nonnull
    public MediaValue<BigDecimal> gamma() {
        return this.gamma;
    }

    @Override
    @Nullable
    public BigDecimal getGamma() {
        return this.gamma.tryGet();
    }

    @Nonnull
    public MediaValue<QtVideoMatrix> matrix() {
        return this.matrix;
    }

    @Nullable
    public QtVideoMatrix getMatrix() {
        return this.matrix.tryGet();
    }

    @Override
    @Nonnull
    public MediaValue<SampleRate> nominalFrameRate() {
        return this.nominalFrameRate;
    }

    @Override
    @Nonnull
    public MediaValue<Boolean> uniformFrameRate() {
        return this.uniformSamples;
    }

    @Override
    @Nonnull
    public MediaValue<FrameGeometry.Dimensions> encodedDimensions() {
        return this.encodedDim;
    }

    @Override
    @Nonnull
    public MediaValue<FrameGeometry.Dimensions> displayDimensions() {
        return this.displayDim;
    }

    @Nonnull
    public MediaValue<BigDecimal> timeScale() {
        return this.timeScale;
    }

    @Override
    public boolean hasTimeScale() {
        return this.timeScale().hasNonNullValue();
    }

    @Override
    public long getTimeScale() {
        return this.timeScale().get().longValue();
    }

    @Nonnull
    public MediaValue<String> codecType() {
        return this.codecType;
    }

    public String toString() {
        return this.getMediaName() + "[" + "dur=" + this.duration + ", " + "codecName=" + this.codecName + ", " + "codecType=" + this.codecType + ", " + "eDim=" + this.encodedDim + ", " + "dDim=" + this.displayDim + ", " + "timeScale=" + this.timeScale + ", " + "mode=" + this.graphicsMode + "]";
    }

    @Override
    @Nonnull
    public MediaValue<MediaTime> duration() {
        return this.duration;
    }

    @Nullable
    public FrameGeometry.Pasp getPasp() {
        Pasp pasp;
        if (this.sampleDescription != null && (pasp = this.sampleDescription.getPasp()) != null) {
            return new FrameGeometry.Pasp(pasp.getHorizontalSpacing().intValue(), pasp.getVerticalSpacing().intValue());
        }
        return null;
    }

    public byte[] getAvcc() {
        String avcCString;
        AvcC avcC;
        if (this.sampleDescription != null && (avcC = this.sampleDescription.getAvcC()) != null && (avcCString = avcC.getRawAvcc()) != null) {
            try {
                return Hex.decodeHex((char[])avcCString.toCharArray());
            }
            catch (DecoderException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return null;
    }

    public int getAVC1Profile() {
        AvcC avcC;
        int ret = 0;
        if ("avc1".equals(this.codecName.get()) && this.sampleDescription != null && (avcC = this.sampleDescription.getAvcC()) != null) {
            int profile = avcC.getProfile().intValue();
            if (profile == AvcC.Profile.BASELINE.intValue()) {
                ret = 66;
            } else if (profile == AvcC.Profile.MAIN.intValue()) {
                ret = 77;
            } else if (profile == AvcC.Profile.EXTENDED.intValue()) {
                ret = 88;
            } else if (profile == AvcC.Profile.HIGH.intValue()) {
                ret = 100;
            }
        }
        return ret;
    }

    public int getAVC1Level() {
        AvcC avcC;
        if ("avc1".equals(this.codecName.get()) && this.sampleDescription != null && (avcC = this.sampleDescription.getAvcC()) != null) {
            return (int)(avcC.getLevel() * 10.0f);
        }
        return 0;
    }

    public long getFieldCount() {
        Fiel fiel;
        if (this.sampleDescription != null && null != (fiel = this.sampleDescription.getFiel())) {
            return fiel.getFieldCount();
        }
        return 1L;
    }

    @Nonnull
    public FieldOrdering getEffectiveFieldOrdering() {
        FieldOrdering actualFieldOrdering = this.getActualFieldOrdering();
        return actualFieldOrdering != null ? actualFieldOrdering : FieldOrdering.PROGRESSIVE;
    }

    @Nullable
    public FieldOrdering getActualFieldOrdering() {
        Fiel fiel;
        if (this.sampleDescription != null && (fiel = this.sampleDescription.getFiel()) != null) {
            return FieldOrdering.valueOf(fiel);
        }
        return null;
    }

    @Override
    @Nonnull
    public MediaValue<HDR10Metadata> hdr10Metadata() {
        return this.hdr10Metadata;
    }

    @Nonnull
    public MediaValue<ColorSpace> actualColorSpace() {
        return this.colorSpace;
    }

    @Nonnull
    private MediaValue<ColorSpace> calcActualColorSpace(@Nonnull XmlObjectMediaParser parser, @Nonnull VideoTrack xmlObject) {
        Colr colr;
        if (this.sampleDescription != null && (colr = this.sampleDescription.getColr()) != null) {
            ColorSpace colorSpace = ColorSpace.valueOf(colr);
            if (colorSpace != null) {
                return parser.toMediaValue(colorSpace);
            }
            return parser.toMediaError(MediaValidationCode.VIDEO_COLORSPACE_MISSING, MediaUtil.dictionary);
        }
        return parser.toMediaValue(null);
    }

    @Nonnull
    public MediaValue<HDR10Metadata> calculateHDR10Metadata(@Nonnull XmlObjectMediaParser parser, @Nonnull VideoTrack xmlObject) {
        if (this.sampleDescription != null) {
            Mdcv mdcv = this.sampleDescription.getMdcv();
            Clli clli = this.sampleDescription.getClli();
            if (mdcv != null && clli != null) {
                HDR10Metadata hdr10Metadata = new HDR10Metadata(mdcv.getRed().getX().intValue(), mdcv.getRed().getY().intValue(), mdcv.getGreen().getX().intValue(), mdcv.getGreen().getY().intValue(), mdcv.getBlue().getX().intValue(), mdcv.getBlue().getY().intValue(), mdcv.getWhitePoint().getX().intValue(), mdcv.getWhitePoint().getY().intValue(), mdcv.getMaxDisplayLuminance().intValue(), mdcv.getMinDisplayLuminance().intValue(), clli.getMaxContentLightLevel().intValue(), clli.getMaxFrameAverageLightLevel().intValue());
                return parser.toMediaValue(hdr10Metadata);
            }
        }
        return parser.toMediaValue(null);
    }

    @Override
    public boolean isProgressive() {
        FieldOrdering effectiveFieldOrdering = this.getEffectiveFieldOrdering();
        return effectiveFieldOrdering.isProgressive();
    }

    public long getDurationInTimeScale() {
        return this.durationInTimeScale.get();
    }

    @Override
    public Long getSampleCount() {
        return this.sampleCount.get();
    }

    public int getSampleDescriptionCount() {
        return this.sampleDescriptionCount.get(BigDecimal.ZERO).intValue();
    }

    @Nonnull
    protected static MediaValue<SampleRate> calcNominalFrameRate(@Nonnull XmlObjectMediaParser parser, @Nonnull VideoTrack xmlObject) {
        DurationStatistics durationStatistics = xmlObject.getDurationStatistics();
        if (null != durationStatistics) {
            try {
                return parser.toMediaValue(new SampleRate(durationStatistics.getTimeScale().longValue(), new Rational(1L, (long)durationStatistics.getMeanDuration())));
            }
            catch (Exception e) {
                return parser.toMediaError(MediaValidationCode.VIDEO_FRAMERATE_INVALID, MediaUtil.dictionary.add("frameRate", durationStatistics.getMeanDuration() + "/" + durationStatistics.getTimeScale()));
            }
        }
        return parser.toMediaError(MediaValidationCode.VIDEO_FRAMERATE_MISSING, MediaUtil.dictionary);
    }

    @Nonnull
    protected static MediaValue<Boolean> calcUniformSamples(@Nonnull XmlObjectMediaParser parser, @Nonnull VideoTrack xmlObject) {
        DurationStatistics durationStatistics = xmlObject.getDurationStatistics();
        if (null != durationStatistics) {
            try {
                return parser.toMediaValue(durationStatistics.getUniform());
            }
            catch (Exception e) {
                return parser.toMediaError(MediaValidationCode.VIDEO_FRAMERATE_UNIFORM_INVALID, MediaUtil.dictionary);
            }
        }
        return parser.toMediaError(MediaValidationCode.VIDEO_FRAMERATE_MISSING, MediaUtil.dictionary);
    }

    @Nonnull
    protected MediaValue<FrameGeometry> calcFrameGeometry(@Nonnull XmlObjectMediaParser parser, @Nonnull VideoTrack xmlObject) {
        try {
            FrameGeometry.Pasp pasp = this.getPasp();
            if (null == pasp) {
                pasp = FrameGeometry.Pasp.identity();
            }
            Dimensions encodedDimensions = xmlObject.getEncodedDimensions();
            FrameGeometry.Dimensions vidEncDim = new FrameGeometry.Dimensions(encodedDimensions.getWidth().longValue(), encodedDimensions.getHeight().longValue());
            return parser.toMediaValue(new FrameGeometry(new FrameGeometry.Dimensions(vidEncDim.getWidth(), vidEncDim.getHeight()), pasp));
        }
        catch (Exception e) {
            return parser.toMediaValue(null);
        }
    }

    @Override
    @Nonnull
    public MediaTrackKind getMediaTrackKind() {
        return trackKind;
    }

    @Override
    @Nonnull
    public MediaValue<BigDecimal> sampleDescriptionCount() {
        return this.sampleDescriptionCount;
    }

    @Override
    @Nonnull
    public MediaValue<FrameGeometry> frameGeometry() {
        return this.frameGeometry;
    }

    @Override
    @Nonnull
    public MediaValue<ColorSpace> colorSpace() {
        return this.colorSpace;
    }

    @Nonnull
    private MediaValue<ColorSpace> computeColorSpace(@Nonnull XmlObjectMediaParser parser, @Nonnull VideoTrack xmlObject) {
        ColorSpace colorSpace = this.actualColorSpace().tryGet();
        if (null == colorSpace) {
            int colorPrimaries = this.getTrackData("mdia.minf.stbl.stsd.0.avcC.0.sps.0.vui.videoSignalType.colorDescription.colorPrimaries", 0);
            int matrixCoefficient = this.getTrackData("mdia.minf.stbl.stsd.0.avcC.0.sps.0.vui.videoSignalType.colorDescription.matrixCoefficients", 0);
            int transferCharacteristics = this.getTrackData("mdia.minf.stbl.stsd.0.avcC.0.sps.0.vui.videoSignalType.colorDescription.transferCharacteristics", 0);
            colorSpace = ColorSpace.guess(colorPrimaries, matrixCoefficient, transferCharacteristics);
        }
        if (null == colorSpace) {
            colorSpace = ColorSpace.BT601;
        }
        return parser.toMediaValue(colorSpace);
    }

    @Override
    @Nonnull
    public MediaValue<ColorSpace> computeColorSpace() {
        return this.computedColorSpace;
    }

    @Nonnull
    public MediaValue<BigDecimal> maximumSampleSize() {
        return this.maximumSampleSize;
    }

    @Nonnull
    public MediaValue<String> frameRateMode() {
        return this.frameRateMode;
    }

    @Override
    public void dumpData(DataDump dump) {
        dump.write("fieldOrdering", (Object)this.getEffectiveFieldOrdering()).write("sampleDescriptionCount", this.sampleDescriptionCount).write("frameGeometry", this.frameGeometry).write("frameRateMode", this.frameRateMode).write("colorSpace", this.colorSpace).write("hdr10Metadata", this.hdr10Metadata);
    }

    @Nonnull
    public MediaValue<BigDecimal> getEditListEntryCount() {
        return this.editListEntryCount;
    }

    @Nonnull
    public List<QtEditListEntry> getEditListEntries() {
        return this.editListEntries;
    }

    @Immutable
    public static class QtVideoMatrix
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @Nonnull
        public final BigDecimal a;
        @Nonnull
        public final BigDecimal b;
        @Nonnull
        public final BigDecimal u;
        @Nonnull
        public final BigDecimal c;
        @Nonnull
        public final BigDecimal d;
        @Nonnull
        public final BigDecimal v;
        @Nonnull
        public final BigDecimal tx;
        @Nonnull
        public final BigDecimal ty;
        @Nonnull
        public final BigDecimal w;
        public final boolean identity;

        public QtVideoMatrix(Matrix xmlBean) {
            if (xmlBean.getIdentity()) {
                this.identity = true;
                this.a = BigDecimal.ONE;
                this.b = BigDecimal.ZERO;
                this.u = BigDecimal.ZERO;
                this.c = BigDecimal.ZERO;
                this.d = BigDecimal.ONE;
                this.v = BigDecimal.ZERO;
                this.tx = BigDecimal.ZERO;
                this.ty = BigDecimal.ZERO;
                this.w = BigDecimal.ONE;
            } else {
                this.identity = false;
                this.a = BigDecimal.valueOf(xmlBean.getA());
                this.b = BigDecimal.valueOf(xmlBean.getB());
                this.u = BigDecimal.valueOf(xmlBean.getU());
                this.c = BigDecimal.valueOf(xmlBean.getC());
                this.d = BigDecimal.valueOf(xmlBean.getD());
                this.v = BigDecimal.valueOf(xmlBean.getV());
                this.tx = BigDecimal.valueOf(xmlBean.getTx());
                this.ty = BigDecimal.valueOf(xmlBean.getTy());
                this.w = BigDecimal.valueOf(xmlBean.getW());
            }
        }

        public String toString() {
            return "Matrix[" + this.a + "," + this.b + "," + this.u + "," + this.c + "," + this.d + "," + this.v + "," + this.tx + "," + this.ty + "," + this.w + "]";
        }

        public boolean isIdentity() {
            return this.identity;
        }

        public double getA() {
            return this.a.doubleValue();
        }

        public double getB() {
            return this.b.doubleValue();
        }

        public double getU() {
            return this.u.doubleValue();
        }

        public double getC() {
            return this.c.doubleValue();
        }

        public double getD() {
            return this.d.doubleValue();
        }

        public double getV() {
            return this.v.doubleValue();
        }

        public double getTx() {
            return this.tx.doubleValue();
        }

        public double getTy() {
            return this.ty.doubleValue();
        }

        public double getW() {
            return this.w.doubleValue();
        }
    }
}

