/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.file.quicktime;

import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.file.MediaCaptionsTrack;
import com.apple.jingle.leghorn.media.file.MediaTrackKind;
import com.apple.jingle.leghorn.media.file.quicktime.QtDataContentTrack;
import com.apple.jingle.leghorn.media.file.quicktime.QuickTimeMediaFile;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.locale.LocaleCode;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import noNamespace.TimecodeTrack;
import noNamespace.Track;
import org.apache.xmlbeans.XmlObject;

public class QtTimecodeTrack
extends QtDataContentTrack<TimecodeTrack>
implements MediaCaptionsTrack {
    @Nonnull
    private static final MediaTrackKind trackKind = MediaTrackKind.TIME_CODE;
    @Nonnull
    private final MediaValue<MediaTime> duration;
    @Nonnull
    private final MediaValue<String> timeCodeFormat;

    public QtTimecodeTrack(@Nonnull QuickTimeMediaFile mediaFile, @Nonnull TimecodeTrack track) {
        super(mediaFile, track);
        XmlObjectMediaParser parser = new XmlObjectMediaParser(mediaFile.getMediaFileMetaData(), this.getMediaName(), (XmlObject)track);
        this.duration = QtTimecodeTrack.calcDuration(parser, (Track)track, MediaValidationCode.AUDIO_DURATION_MISSING.getBaseCode());
        this.timeCodeFormat = parser.toMediaString("times/@format", null);
    }

    public MediaValue<MediaTime> duration() {
        return this.duration;
    }

    @Nullable
    public String getTimeCodeFormat() {
        return this.timeCodeFormat.tryGet();
    }

    @Override
    @Nullable
    public LocaleCode getLocale() {
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "name=" + this.getMediaName() + ", " + "dur=" + this.duration + "]";
    }

    @Override
    @Nonnull
    public MediaTrackKind getMediaTrackKind() {
        return trackKind;
    }
}

