/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.file.quicktime;

import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.file.MediaSubtitleTrack;
import com.apple.jingle.leghorn.media.file.MediaTrackKind;
import com.apple.jingle.leghorn.media.file.quicktime.QtOnScreenDisplayTrack;
import com.apple.jingle.leghorn.media.file.quicktime.QuickTimeMediaFile;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.locale.LocaleCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import noNamespace.SampleDescription;
import noNamespace.SubtitleTrack;
import noNamespace.Track;
import org.apache.xmlbeans.XmlObject;

public class QtSubtitleTrack
extends QtOnScreenDisplayTrack<SubtitleTrack>
implements MediaSubtitleTrack {
    @Nonnull
    private final MediaValue<LocaleCode> locale;
    @Nonnull
    private final MediaValue<MediaTime> duration;
    @Nonnull
    private final MediaTrackKind trackKind;
    @Nonnull
    private final List<Integer> samplesWithMissingFontTable;
    private final boolean isSetDisplayFlagObeyFormating;
    private final long TEXTDISPLAYFLAG_OBEY_SUBTITLE_FORMATTING = 0x20000000L;

    public QtSubtitleTrack(@Nonnull QuickTimeMediaFile mediaFile, @Nonnull SubtitleTrack track) {
        super(mediaFile, track);
        XmlObjectMediaParser parser = new XmlObjectMediaParser(mediaFile.getMediaFileMetaData(), this.getMediaName(), (XmlObject)track);
        this.duration = QtSubtitleTrack.calcDuration(parser, (Track)track, MediaValidationCode.AUDIO_DURATION_MISSING.getBaseCode());
        this.locale = QtSubtitleTrack.calcLocale(parser, (Track)track, MediaValidationCode.AUDIO_LOCALE_MISSING.getBaseCode());
        this.trackKind = this.hasCharacteristic("public.accessibility.describes-music-and-sound") && this.hasCharacteristic("public.accessibility.transcribes-spoken-dialog") ? MediaTrackKind.SDH : MediaTrackKind.SUBTITLES;
        SampleDescription[] stsd = track.getSampleDescriptionArray();
        if (stsd != null && stsd.length != 0) {
            long displayFlags;
            ArrayList<Integer> samplesWithMissingFontTable = new ArrayList<Integer>();
            int sampleNo = 0;
            for (SampleDescription sampleDescription : stsd) {
                ++sampleNo;
                if (sampleDescription.getFtab() != null && sampleDescription.getFtab().getFontArray().length != 0) continue;
                samplesWithMissingFontTable.add(sampleNo);
            }
            this.samplesWithMissingFontTable = Collections.unmodifiableList(samplesWithMissingFontTable);
            this.isSetDisplayFlagObeyFormating = !stsd[0].isSetDisplayFlags() ? false : ((displayFlags = Long.parseLong(stsd[0].getDisplayFlags(), 16)) & 0x20000000L) != 0L;
        } else {
            this.samplesWithMissingFontTable = Collections.emptyList();
            this.isSetDisplayFlagObeyFormating = false;
        }
    }

    public MediaValue<MediaTime> duration() {
        return this.duration;
    }

    public boolean isSdh() {
        return this.trackKind == MediaTrackKind.SDH;
    }

    public List<Integer> samplesWithMissingFontTable() {
        return this.samplesWithMissingFontTable;
    }

    public boolean isSetDisplayFlagObeyFormating() {
        return this.isSetDisplayFlagObeyFormating;
    }

    @Override
    @Nullable
    public LocaleCode getLocale() {
        return this.locale.tryGet();
    }

    public String toString() {
        return this.getMediaName() + "[" + "type=" + this.trackKind + ", " + "lang=" + this.locale + ", " + "dur=" + this.duration + "]";
    }

    @Override
    @Nonnull
    public MediaTrackKind getMediaTrackKind() {
        return this.trackKind;
    }
}

