/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.file.quicktime;

import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.feature.MediaAudioChannel;
import com.apple.jingle.leghorn.media.file.MediaSoundTrack;
import com.apple.jingle.leghorn.media.file.MediaTrackKind;
import com.apple.jingle.leghorn.media.file.quicktime.QtDataContentTrack;
import com.apple.jingle.leghorn.media.file.quicktime.QtEditListEntry;
import com.apple.jingle.leghorn.media.file.quicktime.QuickTimeMediaFile;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.locale.LocaleCode;
import com.sshtools.j2ssh.util.InvalidStateException;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import noNamespace.Channel;
import noNamespace.DataContentTrack;
import noNamespace.SampleRate;
import noNamespace.SoundTrack;
import noNamespace.Track;
import org.apache.xmlbeans.XmlObject;

public class QtSoundTrack
extends QtDataContentTrack<SoundTrack>
implements MediaSoundTrack {
    private final EnumMap<MediaAudioChannel, Channel> channelMap = new EnumMap(MediaAudioChannel.class);
    @Nonnull
    private final List<MediaAudioChannel> channels = new LinkedList<MediaAudioChannel>();
    @Nonnull
    private final MediaValue<MediaTime> duration;
    @Nonnull
    private final MediaValue<String> codec;
    @Nonnull
    private final MediaValue<BigDecimal> dataRateInBps;
    @Nonnull
    private final MediaValue<BigDecimal> sampleRateInHz;
    @Nonnull
    private final MediaValue<LocaleCode> locale;
    @Nonnull
    private final MediaValue<BigDecimal> bitDepth;
    @Nonnull
    private final MediaTrackKind trackKind;
    @Nonnull
    private final String channelLayoutName;
    @Nonnull
    private final MediaValue<Map<String, Double>> loudness;
    @Nonnull
    private final List<QtEditListEntry> editListEntries;

    public QtSoundTrack(@Nonnull QuickTimeMediaFile mediaFile, @Nonnull SoundTrack track) {
        super(mediaFile, track);
        XmlObjectMediaParser parser = new XmlObjectMediaParser(mediaFile.getMediaFileMetaData(), this.getMediaName(), (XmlObject)track);
        this.dataRateInBps = QtSoundTrack.calcDataRate(parser, (DataContentTrack)track, MediaValidationCode.AUDIO_DATARATE_MISSING.getBaseCode());
        this.sampleRateInHz = QtSoundTrack.calcSampleRate(parser, track, MediaValidationCode.AUDIO_SAMPLERATE_MISSING.getBaseCode());
        this.duration = QtSoundTrack.calcDuration(parser, (Track)track, MediaValidationCode.AUDIO_DURATION_MISSING.getBaseCode());
        this.locale = QtSoundTrack.calcLocale(parser, (Track)track, MediaValidationCode.AUDIO_LOCALE_MISSING.getBaseCode());
        this.codec = track.getCodec() != null && null != track.getCodec().getStringValue() ? parser.toMediaValue(track.getCodec().getStringValue().trim()) : parser.toMediaValue(null);
        this.bitDepth = parser.toMediaDecimal("bit_depth", null);
        this.loudness = parser.toMediaValue(Collections.emptyMap());
        Set<Object> skipValidatons = this.metaFile.getSkipValidations() != null ? this.metaFile.getSkipValidations() : new HashSet();
        this.channelLayoutName = track.getChannelLayout().getName();
        for (Channel channel : track.getChannelLayout().getChannelArray()) {
            MediaAudioChannel chType = MediaAudioChannel.get(channel.getName(), MediaAudioChannel.Unknown);
            if (chType == MediaAudioChannel.Unknown && !skipValidatons.contains(MediaValidationCode.AUDIO_CHLABEL_INVALID)) {
                parser.addIssue(MediaValidationCode.AUDIO_CHLABEL_INVALID, MediaUtil.dictionary.add("channelName", channel.getName()));
            }
            this.channels.add(chType);
            this.channelMap.put(chType, channel);
        }
        this.trackKind = this.hasCharacteristic("public.accessibility.describes-video") ? MediaTrackKind.DVS : MediaTrackKind.AUDIO;
        this.editListEntries = new LinkedList<QtEditListEntry>();
        if (track.getEditList() != null) {
            for (Channel channel : track.getEditList().getEditListEntryArray()) {
                QtEditListEntry t = new QtEditListEntry(channel.getMediaTime(), channel.getTrackDuration(), channel.getMediaRate());
                this.editListEntries.add(t);
            }
        }
    }

    @Nullable
    public String getChannelLayoutName() {
        return this.channelLayoutName;
    }

    @Nonnull
    protected static MediaValue<BigDecimal> calcSampleRate(@Nonnull XmlObjectMediaParser parser, @Nonnull SoundTrack xmlObject, @Nullable String featureValidationCodePrefix) {
        MediaValidationCode missingCode;
        block6: {
            missingCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".missing");
            MediaValidationCode badValue = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".invalid");
            SampleRate sampleRate = xmlObject.getSampleRate();
            if (null != sampleRate) {
                String units = sampleRate.getUnits().toLowerCase();
                try {
                    BigDecimal value = new BigDecimal(sampleRate.getStringValue());
                    if ("kilohertz".equals(units) || "khz".equals(units)) {
                        return parser.toMediaValue(value.multiply(BigDecimal.valueOf(1000L)));
                    }
                    if ("hertz".equals(units) || "hz".equals(units)) {
                        return parser.toMediaValue(value);
                    }
                    if (null != badValue) {
                        return parser.toMediaError(badValue, MediaUtil.dictionary.add("value", units));
                    }
                }
                catch (NumberFormatException e) {
                    if (null == badValue) break block6;
                    return parser.toMediaError(badValue, MediaUtil.dictionary.add("value", sampleRate.getStringValue()));
                }
            }
        }
        return parser.toMediaError(missingCode, MediaUtil.dictionary);
    }

    public String toString() {
        return this.getMediaName() + "[" + "type=" + this.trackKind + ", " + "bits=" + this.bitDepth + ", " + "lang=" + this.locale + ", " + "dur=" + this.duration + ", " + "ch=" + this.channelMap.keySet() + "]";
    }

    @Override
    @Nonnull
    public MediaValue<MediaTime> duration() {
        return this.duration;
    }

    @Override
    @Nonnull
    public MediaValue<String> codec() {
        return this.codec;
    }

    @Override
    @Nonnull
    public List<MediaAudioChannel> channels() {
        return this.channels;
    }

    public long getDataRateInBps() {
        return this.dataRateInBps.get().longValue();
    }

    @Override
    @Nonnull
    public MediaValue<BigDecimal> dataRateInBps() {
        return this.dataRateInBps;
    }

    @Override
    @Nonnull
    public MediaValue<BigDecimal> bitDepth() {
        return this.bitDepth;
    }

    @Nonnull
    public MediaValue<BigDecimal> sampleRateInHz() {
        return this.sampleRateInHz;
    }

    @Override
    public BigDecimal getSampleRate() throws InvalidStateException {
        return this.sampleRateInHz.get();
    }

    @Override
    @Nullable
    public LocaleCode getLocale() {
        return this.locale.tryGet();
    }

    @Override
    public MediaTrackKind getMediaTrackKind() {
        return this.trackKind;
    }

    @Nonnull
    public List<QtEditListEntry> getEditListEntries() {
        return this.editListEntries;
    }

    @Override
    public MediaValue<Map<String, Double>> loudness() {
        return this.loudness;
    }
}

