/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.file.quicktime;

import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.file.quicktime.QuickTimeMediaFile;
import com.apple.jingle.leghorn.media.file.quicktime.QuickTimeTrack;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import java.math.BigDecimal;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import noNamespace.DataContentTrack;
import noNamespace.DataRate;

public abstract class QtDataContentTrack<XMLO extends DataContentTrack>
extends QuickTimeTrack<XMLO> {
    @Nonnull
    protected final Map<String, String> trackDataMap;

    public QtDataContentTrack(@Nonnull QuickTimeMediaFile mediaFile, @Nonnull XMLO xmlObject) {
        super(mediaFile, xmlObject);
        this.trackDataMap = mediaFile.getTrackDataMap(xmlObject.getTrackId().intValue());
    }

    @Nonnull
    protected static MediaValue<BigDecimal> calcDataRate(@Nonnull XmlObjectMediaParser parser, @Nonnull DataContentTrack xmlObject, @Nullable String featureValidationCodePrefix) {
        MediaValidationCode missingCode;
        block10: {
            missingCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".missing");
            MediaValidationCode badValue = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".invalid");
            DataRate dataRate = xmlObject.getDataRate();
            if (null != dataRate) {
                String units = dataRate.getUnits().toLowerCase();
                try {
                    if ("INF".equalsIgnoreCase(dataRate.getStringValue())) {
                        return parser.toMediaValue(null);
                    }
                    BigDecimal value = new BigDecimal(dataRate.getStringValue());
                    if ("kbps".equals(units) || "kb/s".equals(units)) {
                        return parser.toMediaValue(value.multiply(BigDecimal.valueOf(1000L)));
                    }
                    if ("kibps".equals(units) || "kib/s".equals(units)) {
                        return parser.toMediaValue(value.multiply(BigDecimal.valueOf(1024L)));
                    }
                    if ("bps".equals(units) || "b/s".equals(units)) {
                        return parser.toMediaValue(value);
                    }
                    if ("mbps".equals(units) || "mb/s".equals(units)) {
                        return parser.toMediaValue(value.multiply(BigDecimal.valueOf(1000000L)));
                    }
                    if ("mibps".equals(units) || "mib/s".equals(units)) {
                        return parser.toMediaValue(value.multiply(BigDecimal.valueOf(0x100000L)));
                    }
                    if (null != badValue) {
                        return parser.toMediaError(badValue, MediaUtil.dictionary.add("value", units));
                    }
                }
                catch (NumberFormatException e) {
                    if (null == badValue) break block10;
                    return parser.toMediaError(badValue, MediaUtil.dictionary.add("value", dataRate.getStringValue()));
                }
            }
        }
        return parser.toMediaError(missingCode, MediaUtil.dictionary);
    }
}

