/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.file.quicktime;

import com.apple.jingle.foghorn.media.FrameGeometry;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.file.MediaCaptionsTrack;
import com.apple.jingle.leghorn.media.file.MediaTrackKind;
import com.apple.jingle.leghorn.media.file.quicktime.QtOnScreenDisplayTrack;
import com.apple.jingle.leghorn.media.file.quicktime.QuickTimeMediaFile;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.locale.LocaleCode;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import noNamespace.OnScreenDisplayTrack;
import noNamespace.Track;
import org.apache.xmlbeans.XmlObject;

public class QtCaptionsTrack
extends QtOnScreenDisplayTrack<OnScreenDisplayTrack>
implements MediaCaptionsTrack {
    @Nonnull
    private final MediaValue<LocaleCode> locale;
    @Nonnull
    private final MediaValue<MediaTime> duration;
    @Nonnull
    private final MediaValue<FrameGeometry.Dimensions> trackDim;
    @Nonnull
    private final MediaTrackKind trackKind = MediaTrackKind.CAPTIONS;

    public QtCaptionsTrack(@Nonnull QuickTimeMediaFile mediaFile, @Nonnull OnScreenDisplayTrack track) {
        super(mediaFile, track);
        XmlObjectMediaParser parser = new XmlObjectMediaParser(mediaFile.getMediaFileMetaData(), this.getMediaName(), (XmlObject)track);
        this.duration = QtCaptionsTrack.calcDuration(parser, (Track)track, MediaValidationCode.CAPTIONS_DURATION_MISSING.getBaseCode());
        this.locale = QtCaptionsTrack.calcLocale(parser, (Track)track, MediaValidationCode.CAPTIONS_LOCALE_MISSING.getBaseCode());
        this.trackDim = QtCaptionsTrack.calcTrackDimensions(parser, MediaValidationCode.CAPTIONS_TRACKDIM_MISSING.getBaseCode());
    }

    public MediaValue<MediaTime> duration() {
        return this.duration;
    }

    @Override
    @Nullable
    public LocaleCode getLocale() {
        return this.locale.tryGet();
    }

    public String toString() {
        return this.getMediaName() + "[" + "lang=" + this.locale + ", " + "dur=" + this.duration + ", " + "trkDim=" + this.trackDim + "]";
    }

    @Override
    public MediaTrackKind getMediaTrackKind() {
        return this.trackKind;
    }
}

