/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.file.mpeg2ps;

import com.apple.jingle.foghorn.media.FrameGeometry;
import com.apple.jingle.foghorn.media.types.ColorSpace;
import com.apple.jingle.foghorn.media.types.FieldOrdering;
import com.apple.jingle.foghorn.media.types.HDR10Metadata;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.MediaValueImpl;
import com.apple.jingle.leghorn.media.file.MediaTrackKind;
import com.apple.jingle.leghorn.media.file.MediaVideoTrack;
import com.apple.jingle.leghorn.media.file.mpeg2ps.Mpeg2psMediaFile;
import com.apple.jingle.leghorn.media.file.mpeg2ps.Mpeg2psTrack;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.leghorn.timecode.Rational;
import com.apple.jingle.leghorn.timecode.SampleRate;
import com.apple.jingle.locale.LocaleCode;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import noNamespace.FrameRate;
import noNamespace.Stream;
import org.apache.xmlbeans.XmlObject;

public class Mpeg2psVideoTrack
extends Mpeg2psTrack
implements MediaVideoTrack {
    @Nonnull
    private final MediaValue<String> originalVideoFormat;
    @Nonnull
    private final MediaValue<String> pixelFormat;
    @Nonnull
    private final MediaValue<String> aspectRatio;
    @Nonnull
    private final MediaValue<FrameGeometry.Dimensions> encodedDim;
    @Nonnull
    private final MediaValue<FrameGeometry.Dimensions> displayDim;
    @Nonnull
    private final MediaValue<FrameGeometry> frameGeometry;
    @Nullable
    private final Boolean cabacEnabled;
    @Nullable
    private final String chromaFormat;
    @Nullable
    private final String videoFormat;
    @Nonnull
    private final MediaValue<SampleRate> frameRate;
    @Nonnull
    private final MediaValue<Long> timeScale;
    @Nonnull
    private final MediaValue<FieldOrdering> fieldOrdering;
    @Nonnull
    private final MediaValue<BigDecimal> sampleDescriptionCount;
    @Nonnull
    private final MediaValue<String> fieldDom;
    @Nonnull
    private final MediaValue<HDR10Metadata> hdr10Metadata;

    public Mpeg2psVideoTrack(@Nonnull Mpeg2psMediaFile mediaFile, @Nonnull Stream xmlObject) {
        super(mediaFile, xmlObject);
        XmlObjectMediaParser parser = new XmlObjectMediaParser(mediaFile.getMediaFileMetaData(), this.getMediaName(), (XmlObject)xmlObject);
        this.originalVideoFormat = parser.toMediaString("original_video_format", null);
        this.pixelFormat = parser.toMediaString("pixel_format", null);
        this.encodedDim = parser.toMediaDim("width", "height", null);
        this.displayDim = parser.toMediaDim("display_width", "display_height", null);
        this.aspectRatio = parser.toMediaString("sample_aspect_ratio", null);
        this.fieldOrdering = Mpeg2psVideoTrack.calcFieldOrdering(parser);
        this.frameGeometry = Mpeg2psVideoTrack.calcFrameGeometry(parser, xmlObject);
        this.videoFormat = parser.toXmlString("video_format");
        this.chromaFormat = parser.toXmlString("chroma_format");
        this.fieldDom = parser.toMediaString("field_dominance", null);
        String cabacEnabled = parser.toXmlString("cabac_enabled");
        this.cabacEnabled = null != cabacEnabled ? Boolean.valueOf(cabacEnabled) : null;
        FrameRate xmlFrameRate = xmlObject.getFrameRate();
        if (null != xmlFrameRate) {
            double frameRateTimesThousand = xmlFrameRate.getDoubleValue() * 1000.0;
            Rational simplestR = new Rational(Math.round(frameRateTimesThousand), 1000L).reduce();
            SampleRate frameRate = new SampleRate(simplestR.numerator(), new Rational(1L, simplestR.denominator()));
            this.frameRate = new MediaValueImpl<SampleRate>(frameRate);
            this.timeScale = new MediaValueImpl<Long>(simplestR.denominator());
        } else {
            this.frameRate = parser.toMediaError(MediaValidationCode.VIDEO_FRAMERATE_MISSING, MediaUtil.dictionary);
            this.timeScale = parser.toMediaError(MediaValidationCode.VIDEO_FRAMERATE_MISSING, MediaUtil.dictionary);
        }
        this.sampleDescriptionCount = parser.toMediaValue(null);
        this.hdr10Metadata = parser.toMediaValue(null);
    }

    @Nonnull
    protected static MediaValue<FieldOrdering> calcFieldOrdering(@Nonnull XmlObjectMediaParser parser) {
        String fieldDom = parser.toXmlString("field_dominance");
        if (null == fieldDom) {
            return parser.toMediaError(MediaValidationCode.VIDEO_FIELDORDERING_MISSING, MediaUtil.dictionary);
        }
        if ("progressive".equals(fieldDom)) {
            return new MediaValueImpl<FieldOrdering>(FieldOrdering.PROGRESSIVE);
        }
        if ("Top Field First".equalsIgnoreCase(fieldDom)) {
            return new MediaValueImpl<FieldOrdering>(FieldOrdering.TOP_FIELD_FIRST);
        }
        if ("Bottom Field First".equalsIgnoreCase(fieldDom)) {
            return new MediaValueImpl<FieldOrdering>(FieldOrdering.BOTTOM_FIELD_FIRST);
        }
        return new MediaValueImpl<FieldOrdering>(FieldOrdering.UNKNOWN);
    }

    @Override
    @Nonnull
    public MediaValue<FrameGeometry.Dimensions> displayDimensions() {
        return this.displayDim;
    }

    @Override
    @Nonnull
    public MediaValue<FrameGeometry.Dimensions> encodedDimensions() {
        return this.encodedDim;
    }

    @Nonnull
    public MediaValue<FieldOrdering> fieldOrdering() {
        return this.fieldOrdering;
    }

    @Override
    @Nonnull
    public MediaValue<MediaTime> duration() {
        return this.duration;
    }

    @Nonnull
    public MediaValue<SampleRate> frameRate() {
        return this.frameRate;
    }

    @Nonnull
    public MediaValue<Long> timeScale() {
        return this.timeScale;
    }

    @Override
    public boolean hasTimeScale() {
        return this.timeScale().hasNonNullValue();
    }

    @Override
    public long getTimeScale() {
        return this.timeScale().get();
    }

    @Nonnull
    public MediaValue<String> pixelFormat() {
        return this.pixelFormat;
    }

    @Override
    @Nonnull
    public MediaValue<String> codecName() {
        return this.codecName;
    }

    @Override
    @Nullable
    public BigDecimal getGamma() {
        return null;
    }

    @Override
    public Long getSampleCount() {
        if (this.duration.hasNonNullValue() && this.frameRate.hasNonNullValue()) {
            return (long)Math.ceil(((MediaTime)this.duration.get()).getSeconds() * this.frameRate.get().exactSampleRate());
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + "name=" + this.getMediaName() + ", " + "type=" + this.type + ", " + "track=" + this.trackId.toString(16) + ", " + "enabled=" + this.enabled + ", " + "codecId=" + this.codecId + ", " + "codec=" + this.codecName + ", " + "dataSize=" + this.dataSize + ", " + "dataRate=" + this.dataRate + ", " + "videoFormat=" + this.originalVideoFormat + ", " + "pixelFormat=" + this.pixelFormat + ", " + "encDim=" + this.encodedDim + ", " + "dispDim=" + this.displayDim + ", " + "dur=" + this.duration + ", " + "frameRate=" + this.frameRate + ", " + "avgFrameCount=" + this.getSampleCount() + ", " + "fields=" + this.fieldOrdering + ", " + "aspectRatio=" + this.aspectRatio + "]";
    }

    @Override
    @Nonnull
    public MediaTrackKind getMediaTrackKind() {
        return MediaTrackKind.VIDEO;
    }

    @Override
    @Nullable
    public LocaleCode getLocale() {
        return null;
    }

    @Override
    public boolean isProgressive() {
        String fieldDom = this.fieldDom.tryGet();
        if (fieldDom != null) {
            if ("Top Field First".equalsIgnoreCase(fieldDom) || "Bottom Field First".equalsIgnoreCase(fieldDom)) {
                return false;
            }
            if ("progressive".equals(fieldDom)) {
                return true;
            }
        }
        return false;
    }

    @Override
    @Nonnull
    public MediaValue<SampleRate> nominalFrameRate() {
        return this.frameRate;
    }

    @Override
    @Nonnull
    public MediaValue<Boolean> uniformFrameRate() {
        return new MediaValueImpl<Boolean>(true);
    }

    @Override
    @Nonnull
    public MediaValue<BigDecimal> sampleDescriptionCount() {
        return this.sampleDescriptionCount;
    }

    @Override
    @Nonnull
    public MediaValue<FrameGeometry> frameGeometry() {
        return this.frameGeometry;
    }

    @Nonnull
    protected static MediaValue<FrameGeometry> calcFrameGeometry(@Nonnull XmlObjectMediaParser parser, @Nonnull Stream xmlObject) {
        try {
            long encodedWidth = xmlObject.getWidth().getBigIntegerValue().longValue();
            long encodedHeight = xmlObject.getHeight().getBigIntegerValue().longValue();
            FrameGeometry.Dimensions encodedDims = new FrameGeometry.Dimensions(encodedWidth, encodedHeight);
            if (null != xmlObject.getDisplayHeight() && null != xmlObject.getDisplayHeight()) {
                long displayWidth = xmlObject.getDisplayWidth().getLongValue();
                long displayHeight = xmlObject.getDisplayHeight().getLongValue();
                FrameGeometry.Dimensions displayDims = new FrameGeometry.Dimensions(displayWidth, displayHeight);
                FrameGeometry.Pasp pasp = new FrameGeometry.Pasp(encodedDims, displayDims).reduce();
                return parser.toMediaValue(new FrameGeometry(encodedDims, pasp));
            }
            return parser.toMediaValue(new FrameGeometry(encodedDims));
        }
        catch (Exception e) {
            return parser.toMediaValue(null);
        }
    }

    @Override
    @Nonnull
    public MediaValue<ColorSpace> colorSpace() {
        return new MediaValueImpl<Object>(null);
    }

    @Override
    @Nonnull
    public MediaValue<ColorSpace> computeColorSpace() {
        return new MediaValueImpl<Object>(null);
    }

    @Override
    @Nonnull
    public MediaValue<HDR10Metadata> hdr10Metadata() {
        return this.hdr10Metadata;
    }
}

