/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.file.mpeg2ps;

import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.XmlObjectMediaBase;
import com.apple.jingle.leghorn.media.file.MediaTrack;
import com.apple.jingle.leghorn.media.file.MediaTrackKind;
import com.apple.jingle.leghorn.media.file.mpeg2ps.Mpeg2psMediaFile;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.locale.LocaleCode;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import noNamespace.Stream;
import org.apache.xmlbeans.XmlObject;

public class Mpeg2psTrack
extends XmlObjectMediaBase<Stream>
implements MediaTrack {
    @Nonnull
    protected final Mpeg2psMediaFile mediaFile;
    @Nonnull
    protected final BigInteger trackId;
    @Nonnull
    protected final MediaValue<String> type;
    @Nonnull
    protected final MediaValue<Boolean> enabled;
    @Nonnull
    protected final MediaValue<String> codecName;
    @Nonnull
    protected final MediaValue<BigDecimal> codecId;
    @Nonnull
    protected final MediaValue<BigDecimal> dataSize;
    @Nonnull
    protected final MediaValue<BigDecimal> dataRate;
    @Nonnull
    protected final MediaValue<MediaTime> duration;

    public Mpeg2psTrack(@Nonnull Mpeg2psMediaFile mediaFile, @Nonnull Stream xmlObject) {
        super(mediaFile.getMediaFileMetaData(), mediaFile.getMediaName() + "#" + xmlObject.getIndex(), xmlObject);
        XmlObjectMediaParser parser = new XmlObjectMediaParser(mediaFile.getMediaFileMetaData(), mediaFile.getMediaName() + "#" + xmlObject.getIndex(), (XmlObject)xmlObject);
        this.mediaFile = mediaFile;
        this.type = parser.toMediaString("@type", null);
        this.codecId = parser.toMediaDecimal("@codec_id", null);
        this.enabled = parser.toMediaBoolean("@enabled", null);
        this.codecName = parser.toMediaString("codec_name", MediaValidationCode.MPEG2_STREAM_CODECNAME_MISSING.getBaseCode());
        this.dataSize = parser.toMediaDataSize("data_size", "data_size/@units", null);
        this.dataRate = parser.toMediaDataRate("data_rate", "data_rate/@units", null);
        this.duration = parser.toMediaDuration(xmlObject.getDuration(), null);
        String trackId = parser.toXmlString("track_id");
        this.trackId = null != trackId && trackId.startsWith("0x") ? BigInteger.valueOf(Integer.parseInt(trackId.substring(2), 16)) : BigInteger.valueOf(xmlObject.getIndex());
    }

    @Nonnull
    public MediaValue<MediaTime> duration() {
        return this.duration;
    }

    @Nonnull
    public final Mpeg2psMediaFile getMediaFile() {
        return this.mediaFile;
    }

    @Override
    @Nonnull
    public final BigInteger getTrackId() {
        return this.trackId;
    }

    @Override
    @Nonnull
    public final String getMediaName() {
        return this.name;
    }

    @Nonnull
    public final MediaValue<BigDecimal> dataRateInBps() {
        return this.dataRate;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "name=" + this.getMediaName() + ", " + "type=" + this.type + ", " + "track=" + this.trackId.toString(16) + ", " + "enabled=" + this.enabled + ", " + "codecId=" + this.codecId + ", " + "codec=" + this.codecName + ", " + "dataSize=" + this.dataSize + ", " + "dataRate=" + this.dataRate + ", " + "dur=" + this.duration + "]";
    }

    @Override
    public MediaTrackKind getMediaTrackKind() {
        return MediaTrackKind.UNKNOWN;
    }

    @Override
    @Nullable
    public LocaleCode getLocale() {
        return null;
    }
}

