/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.file.mpeg2ps;

import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.feature.MediaAudioChannel;
import com.apple.jingle.leghorn.media.file.MediaSoundTrack;
import com.apple.jingle.leghorn.media.file.MediaTrackKind;
import com.apple.jingle.leghorn.media.file.mpeg2ps.Mpeg2psMediaFile;
import com.apple.jingle.leghorn.media.file.mpeg2ps.Mpeg2psTrack;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import com.apple.jingle.locale.LocaleCode;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import noNamespace.SampleRate;
import noNamespace.Stream;
import org.apache.xmlbeans.XmlObject;

public class Mpeg2psSoundTrack
extends Mpeg2psTrack
implements MediaSoundTrack {
    private final List<MediaAudioChannel> channels;
    @Nonnull
    private final MediaValue<BigDecimal> sampleRateInHz;
    @Nonnull
    private final MediaValue<BigDecimal> bitDepth;
    @Nonnull
    private final MediaValue<Map<String, Double>> loudness;
    @Nonnull
    private final List<MediaAudioChannel> stereoChannelMap = Arrays.asList(MediaAudioChannel.L, MediaAudioChannel.R);
    @Nonnull
    private final List<MediaAudioChannel> surroundChannelMap = Arrays.asList(MediaAudioChannel.L, MediaAudioChannel.R, MediaAudioChannel.C, MediaAudioChannel.LFE, MediaAudioChannel.Ls, MediaAudioChannel.Rs);

    public Mpeg2psSoundTrack(@Nonnull Mpeg2psMediaFile mediaFile, @Nonnull Stream xmlObject) {
        super(mediaFile, xmlObject);
        XmlObjectMediaParser parser = new XmlObjectMediaParser(mediaFile.getMediaFileMetaData(), this.getMediaName(), (XmlObject)xmlObject);
        this.sampleRateInHz = Mpeg2psSoundTrack.calcSampleRate(parser, xmlObject, MediaValidationCode.AUDIO_SAMPLERATE_MISSING.getBaseCode());
        String channels = parser.toXmlString("channels");
        this.channels = "2".equals(channels) ? this.stereoChannelMap : ("6".equals(channels) ? this.surroundChannelMap : Collections.emptyList());
        this.bitDepth = parser.toMediaValue(BigDecimal.ZERO);
        this.loudness = parser.toMediaValue(Collections.emptyMap());
    }

    @Override
    public MediaTrackKind getMediaTrackKind() {
        return MediaTrackKind.AUDIO;
    }

    @Override
    @Nullable
    public LocaleCode getLocale() {
        return null;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + "name=" + this.getMediaName() + ", " + "type=" + this.type + ", " + "track=" + this.trackId.toString(16) + ", " + "enabled=" + this.enabled + ", " + "codecId=" + this.codecId + ", " + "codec=" + this.codecName + ", " + "dataSize=" + this.dataSize + ", " + "dataRate=" + this.dataRate + ", " + "dur=" + this.duration + "]";
    }

    @Override
    public List<MediaAudioChannel> channels() {
        return this.channels;
    }

    @Override
    public BigDecimal getSampleRate() {
        return this.sampleRateInHz.get();
    }

    @Nonnull
    protected static MediaValue<BigDecimal> calcSampleRate(@Nonnull XmlObjectMediaParser parser, @Nonnull Stream xmlObject, @Nullable String featureValidationCodePrefix) {
        MediaValidationCode missingCode;
        block6: {
            missingCode = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".missing");
            MediaValidationCode badValue = MediaValidationCode.valueOfStringCodeWithPrefix(featureValidationCodePrefix, ".invalid");
            SampleRate sampleRate = xmlObject.getSampleRate();
            if (null != sampleRate) {
                String units = sampleRate.getUnits().toLowerCase();
                try {
                    BigDecimal value = new BigDecimal(sampleRate.getStringValue());
                    if ("kilohertz".equals(units) || "khz".equals(units)) {
                        return parser.toMediaValue(value.multiply(BigDecimal.valueOf(1000L)));
                    }
                    if ("hertz".equals(units) || "hz".equals(units)) {
                        return parser.toMediaValue(value);
                    }
                    if (null != badValue) {
                        return parser.toMediaError(badValue, MediaUtil.dictionary.add("value", sampleRate.getStringValue()));
                    }
                }
                catch (NumberFormatException e) {
                    if (null == badValue) break block6;
                    return parser.toMediaError(badValue, MediaUtil.dictionary.add("value", sampleRate.getStringValue()));
                }
            }
        }
        return parser.toMediaError(missingCode, MediaUtil.dictionary);
    }

    @Override
    @Nonnull
    public MediaValue<BigDecimal> bitDepth() {
        return this.bitDepth;
    }

    @Override
    public MediaValue<String> codec() {
        return this.codecName;
    }

    @Override
    @Nonnull
    public MediaValue<Map<String, Double>> loudness() {
        return this.loudness;
    }

    @Override
    public boolean isTrackEnabled() {
        return true;
    }
}

