/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.file.mpeg2ps;

import com.apple.jingle.leghorn.media.MediaFactory;
import com.apple.jingle.leghorn.media.MediaProperties;
import com.apple.jingle.leghorn.media.MediaPropertiesBase;
import com.apple.jingle.leghorn.media.MediaTrackCriteria;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.XmlObjectMediaBase;
import com.apple.jingle.leghorn.media.file.MediaFileBackedByXmlDescription;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.file.MediaFileType;
import com.apple.jingle.leghorn.media.file.MediaTrack;
import com.apple.jingle.leghorn.media.file.mpeg2ps.Mpeg2psSoundTrack;
import com.apple.jingle.leghorn.media.file.mpeg2ps.Mpeg2psTrack;
import com.apple.jingle.leghorn.media.file.mpeg2ps.Mpeg2psVideoTrack;
import com.apple.jingle.leghorn.media.validator.SimpleDictionary;
import com.apple.jingle.leghorn.media.validator.ValidationLevel;
import com.apple.jingle.leghorn.media.validator.ValidationResult;
import com.apple.jingle.leghorn.media.validator.ValidationResultSet;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.media.foundation.types.UniformTypeIdentifier;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import noNamespace.AlertItem;
import noNamespace.AlertList;
import noNamespace.ContainerDocument;
import noNamespace.Stream;
import org.apache.mahout.math.Arrays;
import org.apache.xmlbeans.XmlObject;

public class Mpeg2psMediaFile
extends XmlObjectMediaBase<ContainerDocument.Container>
implements MediaFileBackedByXmlDescription {
    @Nonnull
    private final MediaValue<BigDecimal> dataRate;
    @Nonnull
    private final MediaValue<BigDecimal> dataSize;
    @Nonnull
    private final List<Mpeg2psTrack> tracks;
    @Nonnull
    private final Map<Number, Mpeg2psTrack> trackById = new TreeMap<Number, Mpeg2psTrack>();
    @Nonnull
    private final MediaValue<MediaTime> maxDuration;

    public Mpeg2psMediaFile(@Nonnull MediaFileContext metaFile, @Nonnull ContainerDocument.Container xmlObject) {
        super(metaFile, metaFile.getMediaName(), xmlObject);
        XmlObjectMediaParser parser = new XmlObjectMediaParser(metaFile, this.getMediaName(), (XmlObject)xmlObject);
        this.dataRate = parser.toMediaDataRate("mux_rate", "mux_rate/@units", MediaValidationCode.MPEG2_DATARATE_MISSING.getBaseCode());
        this.dataSize = parser.toMediaDataSize("data_size", "data_size/@units", MediaValidationCode.MPEG2_DATARATE_MISSING.getBaseCode());
        parser.processNotificationList(xmlObject.getNotifications(), MediaValidationCode.MPEG2_ITEM_CHECK);
        this.processAlertList(parser, xmlObject.getCheckAlerts(), MediaValidationCode.MPEG2_ITEM_CHECK);
        this.processAlertList(parser, xmlObject.getFatalAlerts(), MediaValidationCode.MPEG2_ITEM_FATAL);
        ArrayList<Mpeg2psVideoTrack> tracks = new ArrayList<Mpeg2psVideoTrack>(xmlObject.getStreams().getStreamArray().length);
        for (Stream stream : xmlObject.getStreams().getStreamArray()) {
            Mpeg2psTrack track = "video".equals(stream.getType()) ? new Mpeg2psVideoTrack(this, stream) : ("audio".equals(stream.getType()) ? new Mpeg2psSoundTrack(this, stream) : new Mpeg2psTrack(this, stream));
            tracks.add((Mpeg2psVideoTrack)track);
            this.trackById.put(track.getTrackId(), track);
        }
        this.tracks = Collections.unmodifiableList(tracks);
        this.maxDuration = parser.toMediaValue(this.getMaximumTrackDuration());
    }

    @Override
    @Nonnull
    public MediaValue<MediaTime> duration() {
        return this.maxDuration;
    }

    @Nonnull
    MediaFileContext getMediaFileMetaData() {
        return this.metaFile;
    }

    protected void processAlertList(@Nonnull XmlObjectMediaParser parser, @Nullable AlertList alertList, @Nonnull MediaValidationCode defaultCode) {
        if (null != alertList) {
            for (AlertItem item : alertList.getAlertArray()) {
                int itemCode = item.getCode();
                long offset = item.getOffset();
                String message = item.getMessage();
                if (message.toLowerCase().contains("Atom size extends beyond the end of the file".toLowerCase())) {
                    parser.addIssue(MediaValidationCode.MOV_ATOM_EXTENDS_BEYOND_FILE_END, MediaUtil.dictionary);
                    continue;
                }
                MediaValidationCode code = MediaValidationCode.valueOfIntegerCode(itemCode, defaultCode);
                parser.addIssue(code, MediaUtil.dictionary.add("message", message).add("code", Integer.toString(itemCode)).add("offset", Long.toString(offset)));
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "fn=" + this.name + ", " + "bps=" + this.dataRate + ", " + "size=" + this.dataSize + "]";
    }

    @Nonnull
    public MediaTime getMaximumTrackDuration() {
        MediaTime max = null;
        for (Mpeg2psTrack track : this.getTracks()) {
            MediaTime duration = track.duration.get();
            if (null != max && max.getTotalMilliseconds() >= duration.getTotalMilliseconds()) continue;
            max = duration;
        }
        return max;
    }

    @Override
    @Nonnull
    public MediaFileType getMediaFileType() {
        return MediaFileType.mpeg2;
    }

    @Override
    @Nonnull
    public String getMediaName() {
        return this.name;
    }

    @Nonnull
    public List<Mpeg2psTrack> getTracks() {
        return this.tracks;
    }

    @Override
    @Nonnull
    public MediaTrack getTrackById(@Nonnull BigInteger mediaTrackId) throws NoSuchElementException {
        throw new NoSuchElementException(this.name + "#" + mediaTrackId.toString());
    }

    @Override
    @Nonnull
    public <T extends MediaTrack> List<T> getTracks(Class<T> trackType, MediaTrackCriteria ... criteria) {
        ArrayList<MediaTrack> tracks = new ArrayList<MediaTrack>(this.trackById.size());
        for (MediaTrack mediaTrack : this.trackById.values()) {
            MediaTrack track;
            if (!trackType.isInstance(mediaTrack) || !MediaUtil.meetsCriteria(track = (MediaTrack)trackType.cast(mediaTrack), criteria)) continue;
            tracks.add(track);
        }
        return Collections.unmodifiableList(tracks);
    }

    @Override
    public boolean hasTrack(MediaTrackCriteria ... criteria) {
        for (MediaTrack mediaTrack : this.trackById.values()) {
            if (!MediaUtil.meetsCriteria(mediaTrack, criteria)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public <T extends MediaTrack> T getFirstTrack(@Nonnull Class<T> trackType, MediaTrackCriteria ... criteria) {
        for (MediaTrack mediaTrack : this.trackById.values()) {
            MediaTrack track;
            if (!trackType.isInstance(mediaTrack) || !MediaUtil.meetsCriteria(track = (MediaTrack)trackType.cast(mediaTrack), criteria)) continue;
            return (T)track;
        }
        throw new NoSuchElementException(trackType.getSimpleName() + Arrays.toString((Object[])criteria));
    }

    public static void main(String[] parms) {
        try {
            final File file = new File(parms[0]);
            final MediaProperties properties = MediaPropertiesBase.nullProperties;
            final ValidationResultSet issues = new ValidationResultSet();
            MediaFileContext ctx = new MediaFileContext(){

                @Override
                public UniformTypeIdentifier getUniformTypeIdentifier() {
                    return UniformTypeIdentifier.byFileName((String)file.getName());
                }

                @Override
                public MediaProperties getMediaProperties() {
                    return properties;
                }

                @Override
                public String getMediaName() {
                    return file.getName();
                }

                @Override
                public String getMediaLocale() {
                    return null;
                }

                @Override
                public Map<String, String> getMediaAttributes() {
                    return Collections.emptyMap();
                }

                @Override
                public String getDescriptionToolVersion() {
                    return "1.0";
                }

                @Override
                public String getDescriptionToolName() {
                    return "cli";
                }

                @Override
                public MediaFileContext child(String childLabel) {
                    return this;
                }

                @Override
                public ValidationResult addIssue(MediaValidationCode code, ValidationLevel defaultLevel, String assetId, SimpleDictionary parameters) {
                    return issues.addResult(code, defaultLevel, assetId, parameters);
                }

                @Override
                public ValidationResult addIssue(MediaValidationCode code, String assetId, SimpleDictionary parameters) {
                    return issues.addResult(code, assetId, parameters);
                }

                @Override
                public Set<MediaValidationCode> getSkipValidations() {
                    return null;
                }
            };
            Mpeg2psMediaFile mediaFile = (Mpeg2psMediaFile)MediaFactory.newMediaFile(ctx, file);
            if (!issues.getValidations().isEmpty()) {
                System.out.println("Issues:");
                for (ValidationResult result : issues.getValidations()) {
                    System.out.println(result);
                }
                System.out.println();
            }
            System.out.println();
            System.out.println(mediaFile);
            for (Mpeg2psTrack track : mediaFile.getTracks()) {
                System.out.println("  " + track);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

