/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.file.misc;

import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.XmlObjectMediaBase;
import com.apple.jingle.leghorn.media.file.MediaTrackKind;
import com.apple.jingle.leghorn.media.file.MediaWebVTTTrack;
import com.apple.jingle.leghorn.media.file.misc.WebVTTMediaFileImpl;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.locale.LocaleCode;
import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.xmlbeans.XmlObject;

public class WebVTTMediaTrackImpl
extends XmlObjectMediaBase<XmlObject>
implements MediaWebVTTTrack {
    @Nonnull
    private final WebVTTMediaFileImpl _mediaFile;
    @Nonnull
    private final MediaValue<MediaTime> _duration;
    private final boolean _hasRuby;
    private final boolean _hasVertical;
    @Nonnull
    private final List<String> _styles;
    @Nonnull
    private final List<String> _features;

    WebVTTMediaTrackImpl(WebVTTMediaFileImpl mediaFile, XmlObject xmlObject) {
        super(mediaFile.getMediaFileMetaData(), mediaFile.getMediaName() + "#1", xmlObject);
        XmlObjectMediaParser parser = new XmlObjectMediaParser(mediaFile.getMediaFileMetaData(), this.getMediaName(), xmlObject);
        this._mediaFile = mediaFile;
        String ss = parser.toXmlString("vtt_description/lastSampleTime");
        this._duration = ss != null ? parser.toMediaValue(new MediaTime(Long.parseLong(ss), 1000L)) : parser.toMediaValue(new MediaTime(0L, 1000L));
        this._hasRuby = parser.toXmlBoolean("vtt_description/containsRuby");
        this._hasVertical = parser.toXmlBoolean("vtt_description/containsVerticals");
        this._styles = parser.toXmlStrings("vtt_description/styles/style");
        this._features = parser.toXmlStrings("vtt_description/features/feature");
    }

    @Override
    @Nonnull
    public String getMediaName() {
        return this.name;
    }

    @Override
    @Nonnull
    public MediaTrackKind getMediaTrackKind() {
        return MediaTrackKind.WEBVTT;
    }

    @Override
    @Nonnull
    public BigInteger getTrackId() {
        return BigInteger.ONE;
    }

    @Override
    @Nullable
    public LocaleCode getLocale() {
        return null;
    }

    public MediaValue<MediaTime> duration() {
        return this._duration;
    }

    @Override
    public boolean hasRuby() {
        return this._hasRuby;
    }

    @Override
    public boolean hasVertical() {
        return this._hasVertical;
    }

    @Override
    public boolean hasStyles() {
        return this._styles.size() > 0;
    }

    @Override
    public boolean hasFeatures() {
        return this._features.size() > 0;
    }

    @Override
    public List<String> features() {
        return Lists.newArrayList(this._features);
    }
}

