/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.file.misc;

import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.MediaValueImpl;
import com.apple.jingle.leghorn.media.XmlObjectMediaBase;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.file.MediaTexmlTrack;
import com.apple.jingle.leghorn.media.file.MediaTrackKind;
import com.apple.jingle.leghorn.media.file.misc.TexmlMediaFileImpl;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import com.apple.jingle.leghorn.texml.xml.TexmlDescriptionDocument;
import com.apple.jingle.locale.BCP47Tag;
import com.apple.jingle.locale.BCP47TagParseException;
import com.apple.jingle.locale.BCP47TagSupport;
import com.apple.jingle.locale.ISO639_2Code;
import com.apple.jingle.locale.LocaleCode;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.xmlbeans.XmlObject;

public class TexmlMediaTrackImpl
extends XmlObjectMediaBase<TexmlDescriptionDocument.TexmlDescription>
implements MediaTexmlTrack {
    @Nonnull
    private final TexmlMediaFileImpl _mediaFile;
    @Nonnull
    private final MediaValue<LocaleCode> _locale;
    @Nonnull
    private final MediaValue<Long> _topPositionCount;
    @Nonnull
    private final MediaValue<Long> _bottomPositionCount;

    public TexmlMediaTrackImpl(@Nonnull MediaFileContext ctx, TexmlMediaFileImpl mediaFile, TexmlDescriptionDocument.TexmlDescription xmlObject) {
        super(ctx, mediaFile.getMediaName() + "#1", xmlObject);
        XmlObjectMediaParser parser = new XmlObjectMediaParser(ctx, this.getMediaName(), (XmlObject)xmlObject);
        this._mediaFile = mediaFile;
        this._topPositionCount = TexmlMediaTrackImpl.calcTopPosition(parser, xmlObject);
        this._bottomPositionCount = TexmlMediaTrackImpl.calcBottomPosition(parser, xmlObject);
        this._locale = TexmlMediaTrackImpl.calcLocale(parser, xmlObject);
    }

    private static MediaValue<Long> calcTopPosition(@Nonnull XmlObjectMediaParser parser, @Nonnull TexmlDescriptionDocument.TexmlDescription xmlObject) {
        return new MediaValueImpl<Long>(xmlObject.getSampleCountStats().getTopSamples().longValue());
    }

    private static MediaValue<Long> calcBottomPosition(@Nonnull XmlObjectMediaParser parser, @Nonnull TexmlDescriptionDocument.TexmlDescription xmlObject) {
        return new MediaValueImpl<Long>(xmlObject.getSampleCountStats().getBottomSamples().longValue());
    }

    private static MediaValue<LocaleCode> calcLocale(@Nonnull XmlObjectMediaParser parser, @Nonnull TexmlDescriptionDocument.TexmlDescription xmlObject) {
        String lang = xmlObject.getLanguage();
        if (null != lang) {
            BCP47Tag code;
            try {
                code = BCP47TagSupport.createBCP47Tag((String)lang);
                if (null != code) {
                    return parser.toMediaValue(code);
                }
            }
            catch (BCP47TagParseException e) {
                // empty catch block
            }
            try {
                code = ISO639_2Code.getBCP47TagForISO639Tag((String)lang);
                if (null != code) {
                    return parser.toMediaValue(code);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return parser.toMediaError(MediaValidationCode.ITT_LOCALE_INVALID, MediaUtil.dictionary.add("localeCode", lang));
        }
        return parser.toMediaError(MediaValidationCode.ITT_LOCALE_MISSING, MediaUtil.dictionary);
    }

    @Override
    @Nonnull
    public String getMediaName() {
        return this.name;
    }

    @Override
    @Nonnull
    public MediaTrackKind getMediaTrackKind() {
        return MediaTrackKind.SUBTITLES;
    }

    @Override
    @Nonnull
    public BigInteger getTrackId() {
        return BigInteger.ONE;
    }

    @Override
    @Nullable
    public LocaleCode getLocale() {
        return this._locale.get();
    }

    public long topPositionCount() {
        return this._topPositionCount.tryGet();
    }

    public long bottomPositionCount() {
        return this._bottomPositionCount.tryGet();
    }
}

