/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.file.misc;

import com.apple.jingle.leghorn.media.MediaTrackCriteria;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.MediaValueError;
import com.apple.jingle.leghorn.media.XmlObjectMediaBase;
import com.apple.jingle.leghorn.media.file.MediaFileBackedByXmlDescription;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.file.MediaFileType;
import com.apple.jingle.leghorn.media.file.MediaTrack;
import com.apple.jingle.leghorn.media.file.misc.TexmlMediaTrackImpl;
import com.apple.jingle.leghorn.media.validator.ValidationLevel;
import com.apple.jingle.leghorn.media.validator.ValidationResult;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import com.apple.jingle.leghorn.texml.xml.TexmlDescriptionDocument;
import com.apple.jingle.leghorn.timecode.MediaTime;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.apache.xmlbeans.XmlObject;

public class TexmlMediaFileImpl
extends XmlObjectMediaBase<TexmlDescriptionDocument.TexmlDescription>
implements MediaFileBackedByXmlDescription {
    @Nonnull
    private final MediaFileType mediaFileType = MediaFileType.tx3g;
    @Nonnull
    private final TexmlMediaTrackImpl track;

    public TexmlMediaFileImpl(@Nonnull MediaFileContext ctx, @Nonnull TexmlDescriptionDocument.TexmlDescription xmlObject) {
        super(ctx, ctx.getMediaName(), xmlObject);
        XmlObjectMediaParser parser = new XmlObjectMediaParser(ctx, this.getMediaName(), (XmlObject)xmlObject);
        this.track = new TexmlMediaTrackImpl(ctx, this, xmlObject);
        parser.processNotificationList(xmlObject.getNotifications(), MediaValidationCode.FILE_ALERT_PASSTHROUGH);
    }

    @Override
    @Nonnull
    public MediaFileType getMediaFileType() {
        return this.mediaFileType;
    }

    @Override
    @Nonnull
    public String getMediaName() {
        return this.name;
    }

    @Override
    @Nonnull
    public List<? extends MediaTrack> getTracks() {
        return Collections.singletonList(this.track);
    }

    @Override
    public boolean hasTrack(MediaTrackCriteria ... criteria) {
        return MediaUtil.meetsCriteria(this.track, criteria);
    }

    @Override
    @Nonnull
    public <T extends MediaTrack> List<T> getTracks(@Nonnull Class<T> trackType, MediaTrackCriteria ... criteria) {
        if (trackType.isInstance(this.track) && MediaUtil.meetsCriteria(this.track, criteria)) {
            return Collections.singletonList(trackType.cast(this.track));
        }
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public <T extends MediaTrack> T getFirstTrack(@Nonnull Class<T> trackType, MediaTrackCriteria ... criteria) {
        if (trackType.isInstance(this.track) && MediaUtil.meetsCriteria(this.track, criteria)) {
            return (T)((MediaTrack)trackType.cast(this.track));
        }
        throw new NoSuchElementException(trackType.getSimpleName() + Arrays.toString(criteria));
    }

    @Override
    @Nonnull
    public MediaValue<MediaTime> duration() {
        return new MediaValueError<MediaTime>(new ValidationResult(ValidationLevel.ERROR, MediaValidationCode.SUBTITLE_FAILS_SCHEMA_VALIDATION, this.name, "duration has not been implemented", MediaUtil.dictionary));
    }

    @Override
    @Nonnull
    public MediaTrack getTrackById(@Nonnull BigInteger mediaTrackId) throws NoSuchElementException {
        if (mediaTrackId.longValue() == 1L) {
            return this.track;
        }
        return null;
    }
}

