/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.file.misc;

import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.XmlObjectMediaBase;
import com.apple.jingle.leghorn.media.file.MediaCaptionsTrack;
import com.apple.jingle.leghorn.media.file.MediaTrackKind;
import com.apple.jingle.leghorn.media.file.misc.SccMediaFileImpl;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.leghorn.timecode.SMPTETimeCode;
import com.apple.jingle.locale.LocaleCode;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.xmlbeans.XmlObject;

public class SccMediaTrackImpl
extends XmlObjectMediaBase<XmlObject>
implements MediaCaptionsTrack {
    @Nonnull
    private final SccMediaFileImpl mediaFile;
    @Nonnull
    private final MediaValue<SMPTETimeCode> firstTimeCode;
    @Nonnull
    private final MediaValue<SMPTETimeCode> lastTimeCode;

    SccMediaTrackImpl(SccMediaFileImpl mediaFile, XmlObject xmlObject) {
        super(mediaFile.getMediaFileMetaData(), mediaFile.getMediaName() + "#1", xmlObject);
        XmlObjectMediaParser parser = new XmlObjectMediaParser(mediaFile.getMediaFileMetaData(), this.getMediaName(), xmlObject);
        this.mediaFile = mediaFile;
        this.firstTimeCode = SccMediaTrackImpl.calcTimeCode(parser, "firstTimeCode", MediaValidationCode.CC_FIRSTTIMECODE_MISSING);
        this.lastTimeCode = SccMediaTrackImpl.calcTimeCode(parser, "lastTimeCode", MediaValidationCode.CC_LASTTIMECODE_MISSING);
    }

    @Nonnull
    public SMPTETimeCode getFirstTimeCode() {
        return this.firstTimeCode.get();
    }

    @Nonnull
    public SMPTETimeCode getLastTimeCode() {
        return this.lastTimeCode.get();
    }

    @Override
    @Nonnull
    public String getMediaName() {
        return this.name;
    }

    @Override
    @Nonnull
    public MediaTrackKind getMediaTrackKind() {
        return MediaTrackKind.CAPTIONS;
    }

    @Override
    @Nonnull
    public BigInteger getTrackId() {
        return BigInteger.ONE;
    }

    @Override
    @Nullable
    public LocaleCode getLocale() {
        return null;
    }

    @Nonnull
    protected static MediaValue<SMPTETimeCode> calcTimeCode(@Nonnull XmlObjectMediaParser parser, @Nonnull String nodeName, @Nonnull MediaValidationCode mediaValidationCode) {
        String timeCodeStringValue = parser.getNodeValue(nodeName);
        if (null == timeCodeStringValue) {
            return parser.toMediaError(mediaValidationCode, MediaUtil.dictionary.add("value", timeCodeStringValue));
        }
        return SccMediaTrackImpl.calcTimeCode(parser, timeCodeStringValue);
    }

    @Nonnull
    protected static MediaValue<SMPTETimeCode> calcTimeCode(@Nonnull XmlObjectMediaParser parser, @Nonnull String timeCodeStringValue) {
        MediaTime captionMediaTime;
        SMPTETimeCode.Mode timeCodeMode = SMPTETimeCode.guessMode(timeCodeStringValue);
        SMPTETimeCode timeCode = SMPTETimeCode.parseTimeCode(timeCodeStringValue, SMPTETimeCode.ntsc2997, timeCodeMode);
        String sccOffsetAttribute = parser.mediaFileCtx().getMediaAttributes().get("program.start.timecode");
        if (null != sccOffsetAttribute) {
            if (SMPTETimeCode.guessMode(sccOffsetAttribute) == null) {
                return parser.toMediaError(MediaValidationCode.CC_PROGRAMSTARTTIMECODE_INVALID, MediaUtil.dictionary.add("timeCode", sccOffsetAttribute));
            }
            SMPTETimeCode.Mode assetTimecodeMode = "true".equalsIgnoreCase(parser.getNodeValue("containsDropFrame")) ? SMPTETimeCode.Mode.dropNTSC : SMPTETimeCode.Mode.nonDrop;
            SMPTETimeCode offsetTimeCode = SMPTETimeCode.parseTimeCodeWithSwapFrameMode(sccOffsetAttribute, SMPTETimeCode.ntsc2997, assetTimecodeMode);
            MediaTime offsetMediaTime = offsetTimeCode.getMediaTime();
            MediaTime lastTimeCodeMediaTime = timeCode.getMediaTime();
            captionMediaTime = lastTimeCodeMediaTime.timeByAddingTime(offsetMediaTime);
            if (captionMediaTime.getSampleCount() < 0L) {
                parser.addIssue(MediaValidationCode.CC_FIRSTTIMECODE_NEGATIVE, MediaUtil.dictionary.add("captionMediaTime", captionMediaTime.toString()));
            }
        } else {
            captionMediaTime = timeCode.getMediaTime();
        }
        return parser.toMediaValue(new SMPTETimeCode(captionMediaTime, timeCode.getMode()));
    }
}

