/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.file.misc;

import com.apple.jingle.leghorn.media.MediaTrackCriteria;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.XmlObjectMediaBase;
import com.apple.jingle.leghorn.media.file.MediaFileBackedByXmlDescription;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.file.MediaFileType;
import com.apple.jingle.leghorn.media.file.MediaTrack;
import com.apple.jingle.leghorn.media.file.misc.SccMediaTrackImpl;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import com.apple.jingle.leghorn.scc.xml.SccDescriptionDocument;
import com.apple.jingle.leghorn.timecode.MediaTime;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.apache.mahout.math.Arrays;
import org.apache.xmlbeans.XmlObject;

public class SccMediaFileImpl
extends XmlObjectMediaBase<SccDescriptionDocument.SccDescription>
implements MediaFileBackedByXmlDescription {
    @Nonnull
    private final MediaFileType mediaFileType = MediaFileType.scc;
    @Nonnull
    private final SccMediaTrackImpl track;
    @Nonnull
    private final MediaValue<MediaTime> duration;

    public SccMediaFileImpl(@Nonnull MediaFileContext metaData, @Nonnull SccDescriptionDocument.SccDescription xmlObject) {
        super(metaData, metaData.getMediaName(), xmlObject);
        XmlObjectMediaParser parser = new XmlObjectMediaParser(metaData, this.getMediaName(), (XmlObject)xmlObject);
        this.track = new SccMediaTrackImpl(this, (XmlObject)xmlObject);
        this.duration = parser.toMediaValue(this.track.getLastTimeCode().getMediaTime());
        parser.processNotificationList(xmlObject.getNotifications(), MediaValidationCode.FILE_ALERT_PASSTHROUGH);
    }

    @Nonnull
    MediaFileContext getMediaFileMetaData() {
        return this.metaFile;
    }

    @Override
    @Nonnull
    public MediaFileType getMediaFileType() {
        return this.mediaFileType;
    }

    @Override
    @Nonnull
    public String getMediaName() {
        return this.name;
    }

    @Nonnull
    public SccMediaTrackImpl getTrack() {
        return this.track;
    }

    @Nonnull
    public List<? extends SccMediaTrackImpl> getTracks() {
        return Collections.singletonList(this.track);
    }

    @Override
    public boolean hasTrack(MediaTrackCriteria ... criteria) {
        return MediaUtil.meetsCriteria(this.track, criteria);
    }

    @Override
    @Nonnull
    public <T extends MediaTrack> List<T> getTracks(@Nonnull Class<T> trackType, MediaTrackCriteria ... criteria) {
        if (trackType.isInstance(this.track) && MediaUtil.meetsCriteria(this.track, criteria)) {
            return Collections.singletonList(trackType.cast(this.track));
        }
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public <T extends MediaTrack> T getFirstTrack(@Nonnull Class<T> trackType, MediaTrackCriteria ... criteria) {
        if (trackType.isInstance(this.track) && MediaUtil.meetsCriteria(this.track, criteria)) {
            return (T)((MediaTrack)trackType.cast(this.track));
        }
        throw new NoSuchElementException(trackType.getSimpleName() + Arrays.toString((Object[])criteria));
    }

    @Override
    @Nonnull
    public MediaTrack getTrackById(@Nonnull BigInteger mediaTrackId) throws NoSuchElementException {
        if (this.track.getTrackId().equals(mediaTrackId)) {
            return this.track;
        }
        throw new NoSuchElementException("MediaTrack[" + mediaTrackId + "]");
    }

    @Override
    @Nonnull
    public MediaValue<MediaTime> duration() {
        return this.duration;
    }
}

