/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.file.misc;

import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.MediaValueImpl;
import com.apple.jingle.leghorn.media.XmlObjectMediaBase;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.file.MediaSubtitleTrack;
import com.apple.jingle.leghorn.media.file.MediaTrackKind;
import com.apple.jingle.leghorn.media.file.misc.IttMediaFileImpl;
import com.apple.jingle.leghorn.media.validator.ValidationLevel;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import com.apple.jingle.leghorn.subtitle.xml.DisplayLocation;
import com.apple.jingle.leghorn.subtitle.xml.OverlappingPElements;
import com.apple.jingle.leghorn.subtitle.xml.PElement;
import com.apple.jingle.leghorn.subtitle.xml.PElementsWithMoreThanTwoLines;
import com.apple.jingle.leghorn.subtitle.xml.SubtitleDescriptionDocument;
import com.apple.jingle.leghorn.subtitle.xml.SubtitleDiagnostic;
import com.apple.jingle.leghorn.subtitle.xml.SubtitleDiagnosticList;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.leghorn.timecode.SMPTETimeCode;
import com.apple.jingle.leghorn.timecode.SampleRate;
import com.apple.jingle.locale.BCP47Tag;
import com.apple.jingle.locale.BCP47TagParseException;
import com.apple.jingle.locale.BCP47TagSupport;
import com.apple.jingle.locale.ISO639_2Code;
import com.apple.jingle.locale.LocaleCode;
import com.google.common.base.Joiner;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.mahout.math.Arrays;
import org.apache.xmlbeans.XmlObject;

public class IttMediaTrackImpl
extends XmlObjectMediaBase<SubtitleDescriptionDocument.SubtitleDescription>
implements MediaSubtitleTrack {
    @Nonnull
    private final IttMediaFileImpl mediaFile;
    @Nonnull
    private final MediaValue<LocaleCode> locale;
    @Nonnull
    private final MediaValue<SampleRate> sampleRate;
    @Nonnull
    private final MediaValue<SMPTETimeCode.Mode> dropMode;
    @Nullable
    private final MediaTime offset;
    @Nonnull
    private final MediaValue<SMPTETimeCode> lastTimeCode;
    @Nonnull
    private final MediaValue<SubtitleLocationCount> subtitleLocationCount;
    @Nonnull
    private static final String outOfSyncITT_RCN_Schema_hack = "attribute \"ry:kind\" not allowed here; expected attribute \"begin\", \"dur\", \"end\", \"ns:agent\", \"ns:role\", \"region\", \"style\", \"timeContainer\", \"tts:backgroundColor\", \"tts:color\", \"tts:direction\", \"tts:display\", \"tts:displayAlign\", \"tts:dynamicFlow\", \"tts:extent\", \"tts:fontFamily\", \"tts:fontSize\", \"tts:fontStyle\", \"tts:fontWeight\", \"tts:lineHeight\", \"tts:opacity\", \"tts:origin\", \"tts:overflow\", \"tts:padding\", \"tts:showBackground\", \"tts:textAlign\", \"tts:textDecoration\", \"tts:textOutline\", \"tts:unicodeBidi\", \"tts:visibility\", \"tts:wrapOption\", \"tts:writingMode\", \"tts:zIndex\", \"xml:id\", \"xml:lang\" or \"xml:space\" (with xmlns:ns=\"http://www.w3.org/ns/ttml#metadata\")";
    @Nullable
    private final String language;
    @Nullable
    private final BigInteger numberOfRubyTags;
    @Nullable
    private final BigInteger numberOfVerticalSamples;

    IttMediaTrackImpl(@Nonnull MediaFileContext ctx, IttMediaFileImpl mediaFile, SubtitleDescriptionDocument.SubtitleDescription xmlObject) {
        super(ctx, mediaFile.getMediaName() + "#1", xmlObject);
        SubtitleDiagnosticList diagnostics;
        MediaValue<BigDecimal> controlCharCount;
        XmlObjectMediaParser parser = new XmlObjectMediaParser(ctx, this.getMediaName(), (XmlObject)xmlObject);
        this.mediaFile = mediaFile;
        this.locale = IttMediaTrackImpl.calcLocale(parser, xmlObject);
        this.language = xmlObject.getLanguage();
        this.sampleRate = IttMediaTrackImpl.calcSampleRate(parser, xmlObject);
        this.dropMode = IttMediaTrackImpl.calcDropMode(parser, xmlObject);
        this.offset = this.calcOffset(parser, xmlObject);
        this.lastTimeCode = this.calcLastTimeCode(parser, xmlObject);
        this.subtitleLocationCount = IttMediaTrackImpl.calcSubtitleLocation(parser, xmlObject);
        this.numberOfRubyTags = xmlObject.getNumberOfRubyTags();
        this.numberOfVerticalSamples = xmlObject.getNumberOfVerticalSamples();
        List<String> locations = IttMediaTrackImpl.getMultiLineElements(parser, xmlObject);
        if (!locations.isEmpty()) {
            parser.addIssue(MediaValidationCode.ITT_MULTILINETEXT_NOTSUPPORTED, MediaUtil.dictionary.add("locations", locations.toString()).add("exampleLocation", locations.get(0)));
        }
        if (!(locations = IttMediaTrackImpl.getOverlappingElements(parser, xmlObject)).isEmpty()) {
            parser.addIssue(MediaValidationCode.ITT_OVERLAPPINGTEXT_NOTSUPPORTED, MediaUtil.dictionary.add("locations", Joiner.on((String)", ").skipNulls().join(locations)).add("exampleLocation", locations.get(0)));
        }
        if (!(locations = IttMediaTrackImpl.getBlankElements(parser, xmlObject)).isEmpty()) {
            parser.addIssue(MediaValidationCode.ITT_BLANKTEXT_NOTSUPPORTED, MediaUtil.dictionary.add("locations", locations.toString()).add("exampleLocation", locations.get(0)));
        }
        if ((controlCharCount = parser.toMediaDecimal("declare namespace NS='http://jingle.apple.com/leghorn/subtitle/xml'; ./NS:unicode_statistics/NS:control/@count", null)).get(BigDecimal.ZERO).longValue() > 0L) {
            parser.addIssue(MediaValidationCode.ITT_CTRLCHAR_NOTSUPPORTED, MediaUtil.dictionary.add("controlCharCount", controlCharCount.get().toPlainString()));
        }
        if (null != (diagnostics = xmlObject.getSubtitleDiagnostics())) {
            for (SubtitleDiagnostic item : diagnostics.getDiagnosticArray()) {
                String message = item.getMessage();
                MediaValidationCode alertCode = MediaValidationCode.valueOfIntegerCode(item.getCode(), MediaValidationCode.FILE_ALERT_PASSTHROUGH);
                if (alertCode == MediaValidationCode.SUBTITLE_FAILS_SCHEMA_VALIDATION && outOfSyncITT_RCN_Schema_hack.equals(message)) {
                    parser.addIssue(alertCode, ValidationLevel.SHADOW, MediaUtil.dictionary.add("message", message));
                    continue;
                }
                parser.addIssue(alertCode, MediaUtil.dictionary.add("message", message));
            }
        }
    }

    @Nonnull
    public static List<String> getMultiLineElements(@Nonnull XmlObjectMediaParser parser, @Nonnull SubtitleDescriptionDocument.SubtitleDescription xmlObject) {
        PElementsWithMoreThanTwoLines badPElements = xmlObject.getPElementsWithMoreThanTwoLines();
        if (null != badPElements && badPElements.sizeOfPElementArray() > 0) {
            ArrayList<String> locations = new ArrayList<String>(badPElements.sizeOfPElementArray());
            for (PElement p : badPElements.getPElementArray()) {
                locations.add(p.getBegin());
            }
            return Collections.unmodifiableList(locations);
        }
        return Collections.emptyList();
    }

    @Nonnull
    public static List<String> getOverlappingElements(@Nonnull XmlObjectMediaParser parser, @Nonnull SubtitleDescriptionDocument.SubtitleDescription xmlObject) {
        OverlappingPElements badPElements = xmlObject.getOverlappingPElements();
        if (null != badPElements && (badPElements.sizeOfOverlapArray() > 0 || badPElements.sizeOfPElementArray() > 0)) {
            ArrayList<String> locations = new ArrayList<String>(badPElements.sizeOfOverlapArray() + badPElements.sizeOfPElementArray());
            for (PElement pElement : badPElements.getPElementArray()) {
                locations.add(String.format("%s - %s", pElement.getBegin(), pElement.getEnd()));
            }
            for (PElement pElement : badPElements.getOverlapArray()) {
                if (!pElement.getFirstRegion().equalsIgnoreCase(pElement.getSecondRegion())) {
                    locations.add(String.format("%s - %s (%s) with %s - %s (%s)", pElement.getFirstPElement().getBegin(), pElement.getFirstPElement().getEnd(), pElement.getFirstRegion(), pElement.getSecondPElement().getBegin(), pElement.getSecondPElement().getEnd(), pElement.getSecondRegion()));
                    continue;
                }
                locations.add(String.format("%s - %s with %s - %s (%s)", pElement.getFirstPElement().getBegin(), pElement.getFirstPElement().getEnd(), pElement.getSecondPElement().getBegin(), pElement.getSecondPElement().getEnd(), pElement.getSecondRegion()));
            }
            return Collections.unmodifiableList(locations);
        }
        return Collections.emptyList();
    }

    @Nonnull
    public static List<String> getBlankElements(@Nonnull XmlObjectMediaParser parser, @Nonnull SubtitleDescriptionDocument.SubtitleDescription xmlObject) {
        if (xmlObject.getBlankPElements() == null) {
            return Collections.emptyList();
        }
        PElement[] badPElements = xmlObject.getBlankPElements().getPElementArray();
        if (null != badPElements && badPElements.length != 0) {
            ArrayList<String> ret = new ArrayList<String>();
            for (PElement e : badPElements) {
                ret.add(e.getBegin());
            }
            return ret;
        }
        return Collections.emptyList();
    }

    @Nonnull
    public SampleRate getSampleRate() {
        return this.sampleRate.get();
    }

    @Nullable
    public MediaTime tryGetDuration() {
        SMPTETimeCode lastTime = this.lastTimeCode.tryGet();
        if (lastTime != null) {
            return lastTime.getMediaTime();
        }
        return null;
    }

    @Nonnull
    public MediaTime getDuration() {
        return this.lastTimeCode.get().getMediaTime();
    }

    public SMPTETimeCode.Mode getDropMode() {
        return this.dropMode.get();
    }

    @Nullable
    public MediaTime getOffset() {
        return this.offset;
    }

    @Override
    @Nonnull
    public String getMediaName() {
        return this.name;
    }

    @Override
    @Nonnull
    public MediaTrackKind getMediaTrackKind() {
        return MediaTrackKind.SUBTITLES;
    }

    @Override
    @Nonnull
    public BigInteger getTrackId() {
        return BigInteger.ONE;
    }

    @Override
    @Nullable
    public LocaleCode getLocale() {
        return this.locale.get();
    }

    @Nullable
    public String getLanguage() {
        return this.language;
    }

    @Nonnull
    protected static MediaValue<SampleRate> calcSampleRate(@Nonnull XmlObjectMediaParser parser, @Nonnull SubtitleDescriptionDocument.SubtitleDescription xmlObject) {
        BigInteger frameRate = xmlObject.getFrameRate();
        String frameRateMultiplier = xmlObject.getFrameRateMultiplier();
        if (null != frameRate && null != frameRateMultiplier) {
            try {
                SampleRate subtitleSampleRate = new SampleRate(frameRate.longValue(), frameRateMultiplier);
                return new MediaValueImpl<SampleRate>(subtitleSampleRate);
            }
            catch (Exception e) {
                return parser.toMediaError(MediaValidationCode.ITT_SAMPLERATE_INVALID, MediaUtil.dictionary.add("frameRate", frameRate.toString()).add("frameRateMultiplier", frameRateMultiplier));
            }
        }
        return parser.toMediaError(MediaValidationCode.ITT_SAMPLERATE_MISSING, MediaUtil.dictionary);
    }

    @Nonnull
    protected static MediaValue<SMPTETimeCode.Mode> calcDropMode(@Nonnull XmlObjectMediaParser parser, @Nonnull SubtitleDescriptionDocument.SubtitleDescription xmlObject) {
        String dropMode = xmlObject.getDropMode();
        if (null != dropMode) {
            try {
                return new MediaValueImpl<SMPTETimeCode.Mode>(SMPTETimeCode.Mode.valueOf(dropMode));
            }
            catch (Exception e) {
                return parser.toMediaError(MediaValidationCode.ITT_DROPMODE_INVALID, MediaUtil.dictionary.add("dropMode", dropMode).add("values", Arrays.toString((Object[])SMPTETimeCode.Mode.values())));
            }
        }
        return parser.toMediaError(MediaValidationCode.ITT_DROPMODE_MISSING, MediaUtil.dictionary);
    }

    @Nullable
    protected MediaTime calcOffset(@Nonnull XmlObjectMediaParser parser, @Nonnull SubtitleDescriptionDocument.SubtitleDescription xmlObject) {
        String offset = xmlObject.getOffsetTimeCode();
        if (null != offset) {
            if (!SMPTETimeCode.isValid(offset)) {
                parser.addIssue(MediaValidationCode.ITT_INVALID_FORMAT_SMPTE_TIMECODE, MediaUtil.dictionary.add("timestamp", offset));
                return null;
            }
            if (offset != null && this.dropMode.hasNonNullValue() && this.sampleRate.hasNonNullValue()) {
                SMPTETimeCode.Mode mode = this.dropMode.get();
                SampleRate subtitleSampleRate = this.sampleRate.get();
                return SMPTETimeCode.parseTimeCodeWithSwapFrameMode(offset, subtitleSampleRate, mode).getMediaTime();
            }
        }
        return null;
    }

    @Nonnull
    protected MediaValue<SMPTETimeCode> calcLastTimeCode(@Nonnull XmlObjectMediaParser parser, @Nonnull SubtitleDescriptionDocument.SubtitleDescription xmlObject) {
        String lastTimeCodeString = xmlObject.getLastTimeCode();
        try {
            if (lastTimeCodeString == null) {
                return parser.toMediaError(MediaValidationCode.ITT_LASTTIMECODE_MISSING, MediaUtil.dictionary);
            }
            if (!SMPTETimeCode.isValid(lastTimeCodeString)) {
                return parser.toMediaError(MediaValidationCode.ITT_LASTTIMECODE_INVALID, MediaUtil.dictionary.add("lastTimeCode", lastTimeCodeString));
            }
            if (this.dropMode.hasError()) {
                return parser.toMediaError(this.dropMode.getError().getRegisteredValidationCode(), MediaUtil.dictionary.add("value", this.dropMode.toString()));
            }
            if (this.sampleRate.hasError()) {
                return parser.toMediaError(this.sampleRate.getError().getRegisteredValidationCode(), MediaUtil.dictionary.add("value", this.sampleRate.toString()));
            }
            SMPTETimeCode.Mode mode = this.dropMode.get();
            SampleRate subtitleSampleRate = this.sampleRate.get();
            SMPTETimeCode lastTimeCode = SMPTETimeCode.parseTimeCodeWithSwapFrameMode(lastTimeCodeString, subtitleSampleRate, mode);
            MediaTime subtitleMediaTime = lastTimeCode.getMediaTime();
            if (this.offset != null) {
                subtitleMediaTime = subtitleMediaTime.timeByAddingTime(this.offset);
                lastTimeCode = new SMPTETimeCode(subtitleMediaTime, lastTimeCode.getMode());
            }
            return new MediaValueImpl<SMPTETimeCode>(lastTimeCode);
        }
        catch (Exception e) {
            return parser.toMediaError(MediaValidationCode.ITT_LASTTIMECODE_INVALID, MediaUtil.dictionary.add("lastTimeCode", lastTimeCodeString));
        }
    }

    @Nonnull
    protected static MediaValue<SubtitleLocationCount> calcSubtitleLocation(@Nonnull XmlObjectMediaParser parser, @Nonnull SubtitleDescriptionDocument.SubtitleDescription xmlObject) {
        DisplayLocation displayLocation = xmlObject.getDisplayLocation();
        if (displayLocation == null) {
            return new MediaValueImpl<Object>(null);
        }
        SubtitleLocationCount locCount = new SubtitleLocationCount();
        locCount.top = displayLocation.getTop().longValue();
        locCount.bottom = displayLocation.getBottom().longValue();
        locCount.left = displayLocation.getLeft().longValue();
        locCount.right = displayLocation.getRight().longValue();
        return new MediaValueImpl<SubtitleLocationCount>(locCount);
    }

    @Nonnull
    protected static MediaValue<LocaleCode> calcLocale(@Nonnull XmlObjectMediaParser parser, @Nonnull SubtitleDescriptionDocument.SubtitleDescription xmlObject) {
        String lang = xmlObject.getLanguage();
        if (null != lang) {
            BCP47Tag code;
            try {
                code = BCP47TagSupport.createBCP47Tag((String)lang);
                if (null != code) {
                    return parser.toMediaValue(code);
                }
            }
            catch (BCP47TagParseException e) {
                // empty catch block
            }
            try {
                code = ISO639_2Code.getBCP47TagForISO639Tag((String)lang);
                if (null != code) {
                    return parser.toMediaValue(code);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return parser.toMediaError(MediaValidationCode.ITT_LOCALE_INVALID, MediaUtil.dictionary.add("localeCode", lang));
        }
        return parser.toMediaError(MediaValidationCode.ITT_LOCALE_MISSING, MediaUtil.dictionary);
    }

    public boolean hasRubyAnnotations() {
        return this.numberOfRubyTags != null && this.numberOfRubyTags.signum() > 0;
    }

    public boolean hasVerticals() {
        return this.numberOfVerticalSamples != null && this.numberOfVerticalSamples.signum() > 0;
    }

    public MediaValue<SubtitleLocationCount> getSubtitleLocationCount() {
        return this.subtitleLocationCount;
    }

    public static class SubtitleLocationCount {
        public long top = 0L;
        public long bottom = 0L;
        public long left = 0L;
        public long right = 0L;

        SubtitleLocationCount() {
        }
    }
}

