/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.file.misc;

import com.apple.jingle.leghorn.media.MediaTrackCriteria;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.XmlObjectMediaBase;
import com.apple.jingle.leghorn.media.file.MediaFileBackedByXmlDescription;
import com.apple.jingle.leghorn.media.file.MediaFileContext;
import com.apple.jingle.leghorn.media.file.MediaFileType;
import com.apple.jingle.leghorn.media.file.MediaTrack;
import com.apple.jingle.leghorn.media.file.misc.IttMediaTrackImpl;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import com.apple.jingle.leghorn.subtitle.xml.SubtitleDescriptionDocument;
import com.apple.jingle.leghorn.timecode.MediaTime;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.apache.mahout.math.Arrays;
import org.apache.xmlbeans.XmlObject;

public class IttMediaFileImpl
extends XmlObjectMediaBase<SubtitleDescriptionDocument.SubtitleDescription>
implements MediaFileBackedByXmlDescription {
    @Nonnull
    private final MediaFileType mediaFileType = MediaFileType.subtitle;
    @Nonnull
    private final IttMediaTrackImpl track;
    @Nonnull
    private final MediaValue<MediaTime> duration;

    public IttMediaFileImpl(@Nonnull MediaFileContext ctx, @Nonnull SubtitleDescriptionDocument.SubtitleDescription xmlObject) {
        super(ctx, ctx.getMediaName(), xmlObject);
        XmlObjectMediaParser parser = new XmlObjectMediaParser(ctx, this.getMediaName(), (XmlObject)xmlObject);
        this.track = new IttMediaTrackImpl(ctx, this, xmlObject);
        this.duration = parser.toMediaValue(this.track.tryGetDuration());
        parser.processNotificationList(xmlObject.getNotifications(), MediaValidationCode.FILE_ALERT_PASSTHROUGH);
    }

    @Override
    @Nonnull
    public MediaFileType getMediaFileType() {
        return this.mediaFileType;
    }

    @Override
    @Nonnull
    public String getMediaName() {
        return this.name;
    }

    @Nonnull
    public IttMediaTrackImpl getTrack() {
        return this.track;
    }

    @Nonnull
    public List<? extends IttMediaTrackImpl> getTracks() {
        return Collections.singletonList(this.track);
    }

    @Override
    public boolean hasTrack(MediaTrackCriteria ... criteria) {
        return MediaUtil.meetsCriteria(this.track, criteria);
    }

    @Override
    @Nonnull
    public <T extends MediaTrack> List<T> getTracks(@Nonnull Class<T> trackType, MediaTrackCriteria ... criteria) {
        if (trackType.isInstance(this.track) && MediaUtil.meetsCriteria(this.track, criteria)) {
            return Collections.singletonList(trackType.cast(this.track));
        }
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public <T extends MediaTrack> T getFirstTrack(@Nonnull Class<T> trackType, MediaTrackCriteria ... criteria) {
        if (trackType.isInstance(this.track) && MediaUtil.meetsCriteria(this.track, criteria)) {
            return (T)((MediaTrack)trackType.cast(this.track));
        }
        throw new NoSuchElementException(trackType.getSimpleName() + Arrays.toString((Object[])criteria));
    }

    @Override
    @Nonnull
    public MediaTrack getTrackById(@Nonnull BigInteger mediaTrackId) throws NoSuchElementException {
        if (this.track.getTrackId().equals(mediaTrackId)) {
            return this.track;
        }
        throw new NoSuchElementException("MediaTrack[" + mediaTrackId + "]");
    }

    @Override
    @Nonnull
    public MediaValue<MediaTime> duration() {
        return this.duration;
    }
}

