/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.media.file.misc;

import com.apple.jingle.leghorn.audio.caf.beans.CafDescriptionDocument;
import com.apple.jingle.leghorn.audio.caf.beans.DialogueAnchor;
import com.apple.jingle.leghorn.audio.caf.beans.SoundcheckInfo;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.MediaValue;
import com.apple.jingle.leghorn.media.XmlObjectMediaBase;
import com.apple.jingle.leghorn.media.feature.MediaAudioChannel;
import com.apple.jingle.leghorn.media.file.MediaSoundTrack;
import com.apple.jingle.leghorn.media.file.MediaTrackKind;
import com.apple.jingle.leghorn.media.file.misc.CoreAudioMediaFileImpl;
import com.apple.jingle.leghorn.media.xml.XmlObjectMediaParser;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.locale.LocaleCode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.xmlbeans.XmlObject;

public class CoreAudioMediaTrackImpl
extends XmlObjectMediaBase<CafDescriptionDocument.CafDescription>
implements MediaSoundTrack {
    @Nonnull
    private final CoreAudioMediaFileImpl _mediaFile;
    @Nonnull
    private final MediaValue<MediaTime> _duration;
    @Nonnull
    private final MediaValue<BigDecimal> _dataSize;
    @Nonnull
    private final MediaValue<BigDecimal> _sampleRate;
    @Nonnull
    private final MediaValue<String> _codec;
    @Nonnull
    private final MediaValue<BigDecimal> _bitdepth;
    @Nonnull
    private final MediaValue<Map<String, Double>> _soundcheck;
    @Nonnull
    private final MediaValue<Map<String, Double>> _dialogueAnchor;
    @Nonnull
    private final MediaValue<BigDecimal> dataRateInBps;

    CoreAudioMediaTrackImpl(CoreAudioMediaFileImpl mediaFile, CafDescriptionDocument.CafDescription xmlObject) {
        super(mediaFile.getMediaFileMetaData(), mediaFile.getMediaName() + "#1", xmlObject);
        XmlObjectMediaParser parser = new XmlObjectMediaParser(mediaFile.getMediaFileMetaData(), this.getMediaName(), (XmlObject)xmlObject);
        this._mediaFile = mediaFile;
        this._dataSize = parser.toMediaDataSize("/caf_description/data_size", "/caf_description/data_size/@units", null);
        this._duration = parser.toMediaDuration("/caf_description/duration", "/caf_description/duration/@units", null);
        this._sampleRate = parser.toMediaDecimal("/caf_description/sample_rate", null);
        this._codec = parser.toMediaString("/caf_description/codec", null);
        this._soundcheck = parser.toMediaValue(CoreAudioMediaTrackImpl.calcSoundcheck(parser, xmlObject));
        this._dialogueAnchor = parser.toMediaValue(CoreAudioMediaTrackImpl.calcDialogueAnchor(parser, xmlObject));
        this.dataRateInBps = parser.toMediaError(MediaValidationCode.AUDIO_DATARATE_MISSING, MediaUtil.dictionary);
        BigDecimal bitdepth = BigDecimal.ZERO;
        if (xmlObject.isSetBitDepth()) {
            bitdepth = new BigDecimal(xmlObject.getBitDepth());
        }
        this._bitdepth = parser.toMediaValue(bitdepth);
    }

    private static Map<String, Double> calcSoundcheck(@Nonnull XmlObjectMediaParser parser, CafDescriptionDocument.CafDescription xmlObject) {
        if (!xmlObject.isSetSoundcheckInfo()) {
            return Collections.emptyMap();
        }
        HashMap<String, Double> scmap = new HashMap<String, Double>();
        SoundcheckInfo scinfo = xmlObject.getSoundcheckInfo();
        if (scinfo.isSetEbuLoudnessRangeTopKey()) {
            scmap.put("aa ebu top of loudness range", scinfo.getEbuLoudnessRangeTopKey());
        }
        if (scinfo.isSetEbuMaxMomentaryLoudnessKey()) {
            scmap.put("aa ebu max momentary loudness", scinfo.getEbuMaxMomentaryLoudnessKey());
        }
        if (scinfo.isSetEbuMaxShortTermLoudnessKey()) {
            scmap.put("aa ebu max short-term loudness", scinfo.getEbuMaxShortTermLoudnessKey());
        }
        if (scinfo.isSetEbuLoudnessRangeKey()) {
            scmap.put("aa ebu loudness range", scinfo.getEbuLoudnessRangeKey());
        }
        if (scinfo.isSetItuLoudnessKey()) {
            scmap.put("aa itu loudness", scinfo.getItuLoudnessKey());
        }
        if (scinfo.isSetItuTruePeakKey()) {
            scmap.put("aa itu true peak", scinfo.getItuTruePeakKey());
        }
        return scmap;
    }

    private static Map<String, Double> calcDialogueAnchor(@Nonnull XmlObjectMediaParser parser, CafDescriptionDocument.CafDescription xmlObject) {
        if (!xmlObject.isSetDialogueAnchor()) {
            return Collections.emptyMap();
        }
        HashMap<String, Double> scmap = new HashMap<String, Double>();
        DialogueAnchor dialogueAnchor = xmlObject.getDialogueAnchor();
        if (dialogueAnchor.isSetEbuLoudnessRangeKey()) {
            scmap.put("aa ebu loudness range", dialogueAnchor.getEbuLoudnessRangeKey());
        }
        if (dialogueAnchor.isSetItuLoudnessKey()) {
            scmap.put("aa itu loudness", dialogueAnchor.getItuLoudnessKey());
        }
        if (dialogueAnchor.isSetSpeechActivityPercentageKey()) {
            scmap.put("aa speech activity percentage", dialogueAnchor.getSpeechActivityPercentageKey());
        }
        return scmap;
    }

    @Override
    @Nonnull
    public List<MediaAudioChannel> channels() {
        return Arrays.asList(MediaAudioChannel.L, MediaAudioChannel.R);
    }

    @Override
    @Nonnull
    public MediaValue<MediaTime> duration() {
        return this._duration;
    }

    @Override
    @Nonnull
    public BigDecimal getSampleRate() {
        return this._sampleRate.get();
    }

    @Override
    @Nonnull
    public MediaValue<BigDecimal> dataRateInBps() {
        return this.dataRateInBps;
    }

    @Override
    @Nonnull
    public String getMediaName() {
        return this.name;
    }

    @Override
    @Nonnull
    public MediaTrackKind getMediaTrackKind() {
        return MediaTrackKind.AUDIO;
    }

    @Override
    @Nonnull
    public BigInteger getTrackId() {
        return BigInteger.ONE;
    }

    @Override
    @Nullable
    public LocaleCode getLocale() {
        return null;
    }

    @Override
    @Nonnull
    public MediaValue<BigDecimal> bitDepth() {
        return this._bitdepth;
    }

    @Override
    @Nonnull
    public MediaValue<String> codec() {
        return this._codec;
    }

    @Override
    public MediaValue<Map<String, Double>> loudness() {
        return this._soundcheck;
    }

    @Override
    public boolean isTrackEnabled() {
        return true;
    }
}

